/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.util;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMAsForeignLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;

@GenerateUncached
public abstract class LLVMSameObjectNode
extends LLVMNode {
    public abstract boolean execute(Object var1, Object var2);

    @Specialization(guards={"a == b"})
    boolean doSame(Object a, Object b) {
        assert (a == b);
        return true;
    }

    @Specialization(limit="3", guards={"a != b"})
    @GenerateAOT.Exclude
    boolean doForeign(Object a, Object b, @CachedLibrary(value="a") LLVMAsForeignLibrary aForeigns, @CachedLibrary(value="b") LLVMAsForeignLibrary bForeigns, @Cached CompareForeignNode compare) {
        return aForeigns.isForeign(a) && bForeigns.isForeign(b) && compare.execute(aForeigns.asForeign(a), bForeigns.asForeign(b));
    }

    static boolean fallbackGuard(Object a, Object b, LLVMAsForeignLibrary aForeigns, LLVMAsForeignLibrary bForeigns) {
        return a != b && (!aForeigns.isForeign(a) || !bForeigns.isForeign(b));
    }

    @Specialization(limit="3", guards={"fallbackGuard(a, b, aForeigns, bForeigns)"})
    @GenerateAOT.Exclude
    boolean doNotSame(Object a, Object b, @CachedLibrary(value="a") LLVMAsForeignLibrary aForeigns, @CachedLibrary(value="b") LLVMAsForeignLibrary bForeigns) {
        assert (a != b);
        return false;
    }

    @GenerateUncached
    static abstract class CompareForeignNode
    extends LLVMNode {
        CompareForeignNode() {
        }

        abstract boolean execute(Object var1, Object var2);

        @Specialization(guards={"a == b"})
        boolean doSame(Object a, Object b) {
            assert (a == b);
            return true;
        }

        @Specialization(limit="3", guards={"a != b"})
        @GenerateAOT.Exclude
        boolean doIdentical(Object a, Object b, @CachedLibrary(value="a") InteropLibrary aInterop, @CachedLibrary(value="b") InteropLibrary bInterop) {
            return aInterop.isIdentical(a, b, bInterop);
        }
    }
}

