/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.op;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.LLVMNativePointerSupport;
import com.oracle.truffle.llvm.runtime.nodes.op.LLVMAbstractCompareNode;
import com.oracle.truffle.llvm.runtime.nodes.op.LLVMAddressEqualsNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.op.LLVMPointerCompareNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.op.ToComparableValue;
import com.oracle.truffle.llvm.runtime.nodes.util.LLVMSameObjectNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;

@NodeChildren(value={@NodeChild(type=LLVMExpressionNode.class), @NodeChild(type=LLVMExpressionNode.class)})
public abstract class LLVMPointerCompareNode
extends LLVMAbstractCompareNode {
    private final NativePointerCompare op;

    public LLVMPointerCompareNode(NativePointerCompare op) {
        this.op = op;
    }

    @Specialization
    boolean doCompare(long a, long b) {
        return this.op.compare(a, b);
    }

    @Specialization
    boolean doCompare(LLVMNativePointer a, LLVMNativePointer b) {
        return this.op.compare(a.asNative(), b.asNative());
    }

    @Specialization(guards={"isPointerA.execute(a)", "isPointerB.execute(b)"}, rewriteOn={UnsupportedMessageException.class})
    protected boolean doPointerPointer(Object a, Object b, @Cached LLVMNativePointerSupport.IsPointerNode isPointerA, @Cached LLVMNativePointerSupport.AsPointerNode asPointerA, @Cached LLVMNativePointerSupport.IsPointerNode isPointerB, @Cached LLVMNativePointerSupport.AsPointerNode asPointerB) throws UnsupportedMessageException {
        return this.op.compare(asPointerA.execute(a), asPointerB.execute(b));
    }

    @Specialization(guards={"isPointerA.execute(a)", "isPointerB.execute(b)"})
    protected boolean doPointerPointerException(Object a, Object b, @Cached LLVMNativePointerSupport.IsPointerNode isPointerA, @Cached LLVMNativePointerSupport.AsPointerNode asPointerA, @Cached LLVMNativePointerSupport.IsPointerNode isPointerB, @Cached LLVMNativePointerSupport.AsPointerNode asPointerB, @Cached LLVMManagedCompareNode managedCompare) {
        try {
            return this.doPointerPointer(a, b, isPointerA, asPointerA, isPointerB, asPointerB);
        }
        catch (UnsupportedMessageException ex) {
            return this.doOther(a, b, isPointerA, asPointerA, isPointerB, asPointerB, managedCompare);
        }
    }

    @Specialization(guards={"!isPointerA.execute(a) || !isPointerB.execute(b)"})
    protected boolean doOther(Object a, Object b, @Cached LLVMNativePointerSupport.IsPointerNode isPointerA, @Cached LLVMNativePointerSupport.AsPointerNode asPointerA, @Cached LLVMNativePointerSupport.IsPointerNode isPointerB, @Cached LLVMNativePointerSupport.AsPointerNode asPointerB, @Cached LLVMManagedCompareNode managedCompare) {
        return managedCompare.execute(a, b, isPointerA, asPointerA, isPointerB, asPointerB, this.op);
    }

    public static LLVMAbstractCompareNode create(Kind kind, LLVMExpressionNode l, LLVMExpressionNode r) {
        switch (kind.ordinal()) {
            case 2: {
                return LLVMPointerCompareNodeGen.create(new NativePointerCompare(){

                    @Override
                    public boolean compare(long a, long b) {
                        return a < b;
                    }
                }, l, r);
            }
            case 3: {
                return LLVMPointerCompareNodeGen.create(new NativePointerCompare(){

                    @Override
                    public boolean compare(long a, long b) {
                        return a <= b;
                    }
                }, l, r);
            }
            case 1: {
                return LLVMPointerCompareNodeGen.create(new NativePointerCompare(){

                    @Override
                    public boolean compare(long a, long b) {
                        return Long.compareUnsigned(a, b) <= 0;
                    }
                }, l, r);
            }
            case 0: {
                return LLVMPointerCompareNodeGen.create(new NativePointerCompare(){

                    @Override
                    public boolean compare(long a, long b) {
                        return Long.compareUnsigned(a, b) < 0;
                    }
                }, l, r);
            }
            case 4: {
                return LLVMAddressEqualsNodeGen.create(l, r);
            }
            case 5: {
                return LLVMNegateNode.create(LLVMAddressEqualsNodeGen.create(l, r));
            }
        }
        throw new AssertionError();
    }

    protected static abstract class NativePointerCompare {
        protected NativePointerCompare() {
        }

        abstract boolean compare(long var1, long var3);
    }

    static abstract class LLVMManagedCompareNode
    extends LLVMNode {
        private static final long TYPICAL_POINTER = 0x7F0000000000L;

        LLVMManagedCompareNode() {
        }

        abstract boolean execute(Object var1, Object var2, LLVMNativePointerSupport.IsPointerNode var3, LLVMNativePointerSupport.AsPointerNode var4, LLVMNativePointerSupport.IsPointerNode var5, LLVMNativePointerSupport.AsPointerNode var6, NativePointerCompare var7);

        @Specialization(guards={"pointToSameObject.execute(a.getObject(), b.getObject())"})
        protected boolean doForeignSameObject(LLVMManagedPointer a, LLVMManagedPointer b, LLVMNativePointerSupport.IsPointerNode isPointerA, LLVMNativePointerSupport.AsPointerNode asPointerA, LLVMNativePointerSupport.IsPointerNode isPointerB, LLVMNativePointerSupport.AsPointerNode asPointerB, NativePointerCompare op, @Cached LLVMSameObjectNode pointToSameObject) {
            return op.compare(0x7F0000000000L + a.getOffset(), 0x7F0000000000L + b.getOffset());
        }

        @Specialization(guards={"!pointToSameObject.execute(a.getObject(), b.getObject())"})
        protected boolean doForeignDifferentObjects(LLVMManagedPointer a, LLVMManagedPointer b, LLVMNativePointerSupport.IsPointerNode isPointerA, LLVMNativePointerSupport.AsPointerNode asPointerA, LLVMNativePointerSupport.IsPointerNode isPointerB, LLVMNativePointerSupport.AsPointerNode asPointerB, NativePointerCompare op, @Cached(value="createIgnoreOffset()") ToComparableValue.ManagedToComparableValue convertA, @Cached(value="createIgnoreOffset()") ToComparableValue.ManagedToComparableValue convertB, @Cached LLVMSameObjectNode pointToSameObject) {
            return op.compare(convertA.executeWithTarget(a), convertB.executeWithTarget(b));
        }

        @Specialization(guards={"isPointerA.execute(a)"}, rewriteOn={UnsupportedMessageException.class})
        protected boolean doNativeManaged(Object a, Object b, LLVMNativePointerSupport.IsPointerNode isPointerA, LLVMNativePointerSupport.AsPointerNode asPointerA, LLVMNativePointerSupport.IsPointerNode isPointerB, LLVMNativePointerSupport.AsPointerNode asPointerB, NativePointerCompare op, @Cached(value="createIgnoreOffset()") ToComparableValue.ManagedToComparableValue convert) throws UnsupportedMessageException {
            return op.compare(asPointerA.execute(a), convert.executeWithTarget(b));
        }

        @Specialization(guards={"isPointerB.execute(b)"}, rewriteOn={UnsupportedMessageException.class})
        protected boolean doManagedNative(Object a, Object b, LLVMNativePointerSupport.IsPointerNode isPointerA, LLVMNativePointerSupport.AsPointerNode asPointerA, LLVMNativePointerSupport.IsPointerNode isPointerB, LLVMNativePointerSupport.AsPointerNode asPointerB, NativePointerCompare op, @Cached(value="createIgnoreOffset()") ToComparableValue.ManagedToComparableValue convert) throws UnsupportedMessageException {
            return op.compare(convert.executeWithTarget(a), asPointerB.execute(b));
        }

        @Specialization(guards={"isPointerA.execute(a) || isPointerB.execute(b)"})
        protected boolean doManagedNativeException(Object a, Object b, LLVMNativePointerSupport.IsPointerNode isPointerA, LLVMNativePointerSupport.AsPointerNode asPointerA, LLVMNativePointerSupport.IsPointerNode isPointerB, LLVMNativePointerSupport.AsPointerNode asPointerB, NativePointerCompare op, @Cached(value="createIgnoreOffset()") ToComparableValue.ManagedToComparableValue convert) {
            try {
                return op.compare(asPointerA.execute(a), convert.executeWithTarget(b));
            }
            catch (UnsupportedMessageException e) {
                try {
                    return op.compare(convert.executeWithTarget(a), asPointerB.execute(b));
                }
                catch (UnsupportedMessageException ex) {
                    return op.compare(convert.executeWithTarget(a), convert.executeWithTarget(b));
                }
            }
        }
    }

    public static enum Kind {
        ULT,
        ULE,
        SLT,
        SLE,
        EQ,
        NEQ;

    }

    public static abstract class LLVMNegateNode
    extends LLVMAbstractCompareNode {
        @Node.Child
        private LLVMAbstractCompareNode booleanExpression;

        LLVMNegateNode(LLVMAbstractCompareNode booleanExpression) {
            this.booleanExpression = booleanExpression;
        }

        public static LLVMAbstractCompareNode create(LLVMAbstractCompareNode booleanExpression) {
            return LLVMPointerCompareNodeGen.LLVMNegateNodeGen.create(booleanExpression);
        }

        @Override
        public final boolean executeWithTarget(Object a, Object b) {
            return !this.booleanExpression.executeWithTarget(a, b);
        }

        @Specialization
        public boolean doNegate(VirtualFrame frame) {
            return !this.booleanExpression.executeGenericBoolean(frame);
        }
    }
}

