/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory.store;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedWriteLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStoreNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToNativeNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToPointerNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMDerefHandleGetReceiverNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMOffsetStoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMPointerStoreNodeGen;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

public abstract class LLVMPointerStoreNode
extends LLVMStoreNode {
    public static LLVMPointerStoreNode create() {
        return LLVMPointerStoreNodeGen.create(null, null);
    }

    public abstract void executeWithTarget(LLVMPointer var1, Object var2);

    @Specialization(guards={"!isAutoDerefHandle(addr)"})
    protected void doAddress(LLVMNativePointer addr, Object value, @Cached(value="createToNativeWithTarget()") LLVMToNativeNode toNative) {
        this.getLanguage().getLLVMMemory().putPointer((Node)this, addr, toNative.executeWithTarget(value));
    }

    @Specialization(guards={"!isAutoDerefHandle(addr)"})
    protected void doAddress(long addr, Object value, @Cached(value="createToNativeWithTarget()") LLVMToNativeNode toNative) {
        this.getLanguage().getLLVMMemory().putPointer((Node)this, addr, toNative.executeWithTarget(value));
    }

    @Specialization(guards={"isAutoDerefHandle(addr)"})
    protected static void doOpDerefHandle(LLVMNativePointer addr, Object value, @Cached LLVMToPointerNode toPointer, @Cached LLVMDerefHandleGetReceiverNode getReceiver, @CachedLibrary(limit="3") LLVMManagedWriteLibrary nativeWrite) {
        LLVMPointerStoreNode.doManaged(getReceiver.execute(addr), value, toPointer, nativeWrite);
    }

    @Specialization(guards={"isAutoDerefHandle(addr)"})
    protected static void doDerefAddress(long addr, Object value, @Cached LLVMToPointerNode toPointer, @Cached LLVMDerefHandleGetReceiverNode getReceiver, @CachedLibrary(limit="3") LLVMManagedWriteLibrary nativeWrite) {
        LLVMPointerStoreNode.doManaged(getReceiver.execute(addr), value, toPointer, nativeWrite);
    }

    @Specialization(limit="3")
    protected static void doManaged(LLVMManagedPointer address, Object value, @Cached LLVMToPointerNode toPointer, @CachedLibrary(value="address.getObject()") LLVMManagedWriteLibrary nativeWrite) {
        nativeWrite.writePointer(address.getObject(), address.getOffset(), toPointer.executeWithTarget(value));
    }

    @Specialization(replaces={"doManaged"})
    protected static void doManagedAOT(LLVMManagedPointer address, Object value, @Cached LLVMToPointerNode toPointer, @CachedLibrary(limit="3") LLVMManagedWriteLibrary nativeWrite) {
        LLVMPointerStoreNode.doManaged(address, value, toPointer, nativeWrite);
    }

    @GenerateUncached
    public static abstract class LLVMPointerOffsetStoreNode
    extends LLVMOffsetStoreNode.LLVMPrimitiveOffsetStoreNode {
        public static LLVMPointerOffsetStoreNode create() {
            return LLVMPointerStoreNodeGen.LLVMPointerOffsetStoreNodeGen.create(null, null, null);
        }

        public static LLVMPointerOffsetStoreNode create(LLVMExpressionNode value) {
            return LLVMPointerStoreNodeGen.LLVMPointerOffsetStoreNodeGen.create(null, null, value);
        }

        public abstract void executeWithTarget(LLVMPointer var1, long var2, Object var4);

        @Specialization(guards={"!isAutoDerefHandle(addr)"})
        protected void doAddress(LLVMNativePointer addr, long offset, Object value, @Cached(value="createToNativeWithTarget()") LLVMToNativeNode toNative) {
            this.getLanguage().getLLVMMemory().putPointer((Node)this, addr.asNative() + offset, toNative.executeWithTarget(value));
        }

        @Specialization(guards={"isAutoDerefHandle(addr)"})
        protected static void doOpDerefHandle(LLVMNativePointer addr, long offset, Object value, @Cached LLVMToPointerNode toPointer, @Cached LLVMDerefHandleGetReceiverNode getReceiver, @CachedLibrary(limit="3") LLVMManagedWriteLibrary nativeWrite) {
            LLVMPointerOffsetStoreNode.doManaged(getReceiver.execute(addr), offset, value, toPointer, nativeWrite);
        }

        @Specialization(guards={"isAutoDerefHandle(addr)"})
        protected static void doDerefAddress(long addr, long offset, Object value, @Cached LLVMToPointerNode toPointer, @Cached LLVMDerefHandleGetReceiverNode getReceiver, @CachedLibrary(limit="3") LLVMManagedWriteLibrary nativeWrite) {
            LLVMPointerOffsetStoreNode.doManaged(getReceiver.execute(addr), offset, value, toPointer, nativeWrite);
        }

        @Specialization(limit="3")
        protected static void doManaged(LLVMManagedPointer addr, long offset, Object value, @Cached LLVMToPointerNode toPointer, @CachedLibrary(value="addr.getObject()") LLVMManagedWriteLibrary nativeWrite) {
            nativeWrite.writePointer(addr.getObject(), addr.getOffset() + offset, toPointer.executeWithTarget(value));
        }

        @Specialization(replaces={"doManaged"})
        protected static void doManagedAOT(LLVMManagedPointer addr, long offset, Object value, @Cached LLVMToPointerNode toPointer, @CachedLibrary(limit="3") LLVMManagedWriteLibrary nativeWrite) {
            LLVMPointerOffsetStoreNode.doManaged(addr, offset, value, toPointer, nativeWrite);
        }
    }
}

