/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory.store;

import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.CommonNodeFactory;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStoreNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

@NodeChildren(value={@NodeChild(value="target", type=LLVMExpressionNode.class), @NodeChild(value="offset", type=LLVMExpressionNode.class), @NodeChild(value="value", type=LLVMExpressionNode.class)})
public abstract class LLVMOffsetStoreNode
extends LLVMNode {
    public abstract void executeWithTarget(VirtualFrame var1, LLVMPointer var2, long var3);

    public static abstract class LLVMGenericOffsetStoreNode
    extends LLVMOffsetStoreNode {
        @Node.Child
        private LLVMStoreNode store;

        protected LLVMGenericOffsetStoreNode(LLVMStoreNode store) {
            this.store = store;
        }

        @Specialization
        protected void doOp(VirtualFrame frame, LLVMPointer addr, long offset, Object value) {
            this.store.executeWithTarget(frame, addr.increment(offset), value);
        }
    }

    public static abstract class LLVMPrimitiveOffsetStoreNode
    extends LLVMOffsetStoreNode {
        public abstract void executeWithTargetGeneric(LLVMPointer var1, long var2, Object var4);

        public static final LLVMPrimitiveOffsetStoreNode create(LLVMInteropType.ValueKind kind) {
            return CommonNodeFactory.createOffsetStoreNode(kind);
        }

        public static LLVMPrimitiveOffsetStoreNode getUncached(LLVMInteropType.ValueKind kind) {
            return CommonNodeFactory.getUncachedOffsetStoreNode(kind);
        }
    }
}

