/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory.store;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedWriteLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMDerefHandleGetReceiverNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI1StoreNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMOffsetStoreNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

public abstract class LLVMI1StoreNode
extends LLVMStoreNode {
    public abstract void executeWithTarget(LLVMPointer var1, boolean var2);

    @Specialization(guards={"!isAutoDerefHandle(addr)"})
    protected void doOp(LLVMNativePointer addr, boolean value) {
        this.getLanguage().getLLVMMemory().putI1((Node)this, addr, value);
    }

    @Specialization(guards={"isAutoDerefHandle(addr)"})
    protected static void doOpDerefHandle(LLVMNativePointer addr, boolean value, @Cached LLVMDerefHandleGetReceiverNode getReceiver, @CachedLibrary(limit="3") LLVMManagedWriteLibrary nativeWrite) {
        LLVMI1StoreNode.doOpManaged(getReceiver.execute(addr), value, nativeWrite);
    }

    @Specialization(limit="3")
    @GenerateAOT.Exclude
    protected static void doOpManaged(LLVMManagedPointer address, boolean value, @CachedLibrary(value="address.getObject()") LLVMManagedWriteLibrary nativeWrite) {
        nativeWrite.writeI8(address.getObject(), address.getOffset(), value ? (byte)1 : 0);
    }

    public static LLVMI1StoreNode create() {
        return LLVMI1StoreNodeGen.create(null, null);
    }

    @GenerateUncached
    public static abstract class LLVMI1OffsetStoreNode
    extends LLVMOffsetStoreNode.LLVMPrimitiveOffsetStoreNode {
        public static LLVMI1OffsetStoreNode create() {
            return LLVMI1StoreNodeGen.LLVMI1OffsetStoreNodeGen.create(null, null, null);
        }

        public static LLVMI1OffsetStoreNode create(LLVMExpressionNode value) {
            return LLVMI1StoreNodeGen.LLVMI1OffsetStoreNodeGen.create(null, null, value);
        }

        public abstract void executeWithTarget(LLVMPointer var1, long var2, boolean var4);

        @Specialization(guards={"!isAutoDerefHandle(addr)"})
        protected void doOp(LLVMNativePointer addr, long offset, boolean value) {
            this.getLanguage().getLLVMMemory().putI1((Node)this, addr.asNative() + offset, value);
        }

        @Specialization(guards={"isAutoDerefHandle(addr)"})
        protected static void doOpDerefHandle(LLVMNativePointer addr, long offset, boolean value, @Cached LLVMDerefHandleGetReceiverNode getReceiver, @CachedLibrary(limit="3") LLVMManagedWriteLibrary nativeWrite) {
            LLVMI1OffsetStoreNode.doOpManaged(getReceiver.execute(addr), offset, value, nativeWrite);
        }

        @Specialization(limit="3")
        @GenerateAOT.Exclude
        protected static void doOpManaged(LLVMManagedPointer address, long offset, boolean value, @CachedLibrary(value="address.getObject()") LLVMManagedWriteLibrary nativeWrite) {
            nativeWrite.writeI8(address.getObject(), address.getOffset() + offset, value ? (byte)1 : 0);
        }
    }
}

