/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory;

import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.interop.LLVMNegatedForeignObject;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStatementNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMOffsetStoreNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

@NodeChildren(value={@NodeChild(value="base", type=LLVMExpressionNode.class), @NodeChild(value="offset", type=LLVMExpressionNode.class)})
public abstract class LLVMWithElementPtrStoreNode
extends LLVMStatementNode {
    private final long typeWidth;
    @Node.Child
    private LLVMOffsetStoreNode store;

    public LLVMWithElementPtrStoreNode(LLVMOffsetStoreNode store, long typeWidth) {
        this.store = store;
        this.typeWidth = typeWidth;
    }

    protected static boolean isNegated(Object obj, Object negatedObj) {
        if (negatedObj instanceof LLVMNegatedForeignObject) {
            return ((LLVMNegatedForeignObject)negatedObj).getForeign() == obj;
        }
        return false;
    }

    @Specialization(guards={"isNegated(addr.getObject(), element.getObject())"})
    protected void doPointerDiff(VirtualFrame frame, LLVMManagedPointer addr, LLVMManagedPointer element) {
        this.store.executeWithTarget(frame, LLVMNativePointer.create(addr.getOffset() + element.getOffset()), 0L);
    }

    @Specialization(guards={"isNegated(element.getObject(), addr.getObject())"})
    protected void doPointerDiffRev(VirtualFrame frame, LLVMManagedPointer addr, LLVMManagedPointer element) {
        this.store.executeWithTarget(frame, LLVMNativePointer.create(element.getOffset() + addr.getOffset()), 0L);
    }

    @Specialization
    protected void doInt(VirtualFrame frame, LLVMPointer addr, int element) {
        this.store.executeWithTarget(frame, addr, this.typeWidth * (long)element);
    }

    @Specialization
    protected void doLong(VirtualFrame frame, LLVMPointer addr, long element) {
        this.store.executeWithTarget(frame, addr, this.typeWidth * element);
    }

    @Specialization
    protected void doNativePointer(VirtualFrame frame, LLVMPointer addr, LLVMNativePointer element) {
        this.store.executeWithTarget(frame, addr, this.typeWidth * element.asNative());
    }
}

