/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory;

import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.LLVMWithElementPtrStoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMDoubleLoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMFloatLoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI16LoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI32LoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI64LoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI8LoadNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

@NodeChildren(value={@NodeChild(value="base", type=LLVMExpressionNode.class), @NodeChild(value="offset", type=LLVMExpressionNode.class)})
public abstract class LLVMWithElementPtrLoadNode
extends LLVMExpressionNode {
    final long typeWidth;

    protected LLVMWithElementPtrLoadNode(long typeWidth) {
        this.typeWidth = typeWidth;
    }

    public final long getTypeWidth() {
        return this.typeWidth;
    }

    @ImportStatic(value={LLVMWithElementPtrStoreNode.class})
    public static abstract class LLVMWithElementPtrLoadFloatNode
    extends LLVMWithElementPtrLoadNode {
        @Node.Child
        private LLVMFloatLoadNode.LLVMFloatOffsetLoadNode load = LLVMFloatLoadNode.LLVMFloatOffsetLoadNode.create();

        protected LLVMWithElementPtrLoadFloatNode(long typeWidth) {
            super(typeWidth);
        }

        @Specialization(guards={"isNegated(addr.getObject(), element.getObject())"})
        protected float doPointerDiff(LLVMManagedPointer addr, LLVMManagedPointer element) {
            return this.load.executeWithTarget(LLVMNativePointer.create(addr.getOffset() + element.getOffset()), 0L);
        }

        @Specialization(guards={"isNegated(element.getObject(), addr.getObject())"})
        protected float doPointerDiffRev(LLVMManagedPointer addr, LLVMManagedPointer element) {
            return this.load.executeWithTarget(LLVMNativePointer.create(element.getOffset() + addr.getOffset()), 0L);
        }

        @Specialization
        protected float doInt(LLVMPointer addr, int element) {
            return this.load.executeWithTarget(addr, this.typeWidth * (long)element);
        }

        @Specialization
        protected float doLong(LLVMPointer addr, long element) {
            return this.load.executeWithTarget(addr, this.typeWidth * element);
        }

        @Specialization
        protected float doNativePointer(LLVMPointer addr, LLVMNativePointer element) {
            return this.load.executeWithTarget(addr, this.typeWidth * element.asNative());
        }
    }

    @ImportStatic(value={LLVMWithElementPtrStoreNode.class})
    public static abstract class LLVMWithElementPtrLoadDoubleNode
    extends LLVMWithElementPtrLoadNode {
        @Node.Child
        private LLVMDoubleLoadNode.LLVMDoubleOffsetLoadNode load = LLVMDoubleLoadNode.LLVMDoubleOffsetLoadNode.create();

        protected LLVMWithElementPtrLoadDoubleNode(long typeWidth) {
            super(typeWidth);
        }

        @Specialization(guards={"isNegated(addr.getObject(), element.getObject())"})
        protected double doPointerDiff(LLVMManagedPointer addr, LLVMManagedPointer element) {
            return this.load.executeWithTarget(LLVMNativePointer.create(addr.getOffset() + element.getOffset()), 0L);
        }

        @Specialization(guards={"isNegated(element.getObject(), addr.getObject())"})
        protected double doPointerDiffRev(LLVMManagedPointer addr, LLVMManagedPointer element) {
            return this.load.executeWithTarget(LLVMNativePointer.create(element.getOffset() + addr.getOffset()), 0L);
        }

        @Specialization
        protected double doInt(LLVMPointer addr, int element) {
            return this.load.executeWithTarget(addr, this.typeWidth * (long)element);
        }

        @Specialization
        protected double doLong(LLVMPointer addr, long element) {
            return this.load.executeWithTarget(addr, this.typeWidth * element);
        }

        @Specialization
        protected double doNativePointer(LLVMPointer addr, LLVMNativePointer element) {
            return this.load.executeWithTarget(addr, this.typeWidth * element.asNative());
        }
    }

    @ImportStatic(value={LLVMWithElementPtrStoreNode.class})
    public static abstract class LLVMWithElementPtrLoadI64Node
    extends LLVMWithElementPtrLoadNode {
        @Node.Child
        private LLVMI64LoadNode.LLVMI64OffsetLoadNode load = LLVMI64LoadNode.LLVMI64OffsetLoadNode.create();

        protected LLVMWithElementPtrLoadI64Node(long typeWidth) {
            super(typeWidth);
        }

        @Specialization(guards={"isNegated(addr.getObject(), element.getObject())"}, rewriteOn={UnexpectedResultException.class})
        protected long doPointerDiff(LLVMManagedPointer addr, LLVMManagedPointer element) throws UnexpectedResultException {
            return this.load.executeWithTarget(LLVMNativePointer.create(addr.getOffset() + element.getOffset()), 0L);
        }

        @Specialization(guards={"isNegated(element.getObject(), addr.getObject())"}, rewriteOn={UnexpectedResultException.class})
        protected long doPointerDiffRev(LLVMManagedPointer addr, LLVMManagedPointer element) throws UnexpectedResultException {
            return this.load.executeWithTarget(LLVMNativePointer.create(element.getOffset() + addr.getOffset()), 0L);
        }

        @Specialization(rewriteOn={UnexpectedResultException.class})
        protected long doInt(LLVMPointer addr, int element) throws UnexpectedResultException {
            return this.load.executeWithTarget(addr, this.typeWidth * (long)element);
        }

        @Specialization(rewriteOn={UnexpectedResultException.class})
        protected long doLong(LLVMPointer addr, long element) throws UnexpectedResultException {
            return this.load.executeWithTarget(addr, this.typeWidth * element);
        }

        @Specialization(rewriteOn={UnexpectedResultException.class})
        protected long doNativePointer(LLVMPointer addr, LLVMNativePointer element) throws UnexpectedResultException {
            return this.load.executeWithTarget(addr, this.typeWidth * element.asNative());
        }

        @Specialization(guards={"isNegated(addr.getObject(), element.getObject())"}, replaces={"doPointerDiff"})
        protected Object doPointerDiffGeneric(LLVMManagedPointer addr, LLVMManagedPointer element) {
            return this.load.executeWithTargetGeneric(LLVMNativePointer.create(addr.getOffset() + element.getOffset()), 0L);
        }

        @Specialization(guards={"isNegated(element.getObject(), addr.getObject())"}, replaces={"doPointerDiffRev"})
        protected Object doPointerDiffRevGeneric(LLVMManagedPointer addr, LLVMManagedPointer element) {
            return this.load.executeWithTargetGeneric(LLVMNativePointer.create(element.getOffset() + addr.getOffset()), 0L);
        }

        @Specialization(replaces={"doInt"})
        protected Object doIntGeneric(LLVMPointer addr, int element) {
            return this.load.executeWithTargetGeneric(addr, this.typeWidth * (long)element);
        }

        @Specialization(replaces={"doLong"})
        protected Object doLongGeneric(LLVMPointer addr, long element) {
            return this.load.executeWithTargetGeneric(addr, this.typeWidth * element);
        }

        @Specialization(replaces={"doNativePointer"})
        protected Object doNativePointerGeneric(LLVMPointer addr, LLVMNativePointer element) {
            return this.load.executeWithTargetGeneric(addr, this.typeWidth * element.asNative());
        }
    }

    @ImportStatic(value={LLVMWithElementPtrStoreNode.class})
    public static abstract class LLVMWithElementPtrLoadI32Node
    extends LLVMWithElementPtrLoadNode {
        @Node.Child
        private LLVMI32LoadNode.LLVMI32OffsetLoadNode load = LLVMI32LoadNode.LLVMI32OffsetLoadNode.create();

        protected LLVMWithElementPtrLoadI32Node(long typeWidth) {
            super(typeWidth);
        }

        @Specialization(guards={"isNegated(addr.getObject(), element.getObject())"})
        protected int doPointerDiff(LLVMManagedPointer addr, LLVMManagedPointer element) {
            return this.load.executeWithTarget(LLVMNativePointer.create(addr.getOffset() + element.getOffset()), 0L);
        }

        @Specialization(guards={"isNegated(element.getObject(), addr.getObject())"})
        protected int doPointerDiffRev(LLVMManagedPointer addr, LLVMManagedPointer element) {
            return this.load.executeWithTarget(LLVMNativePointer.create(element.getOffset() + addr.getOffset()), 0L);
        }

        @Specialization
        protected int doInt(LLVMPointer addr, int element) {
            return this.load.executeWithTarget(addr, this.typeWidth * (long)element);
        }

        @Specialization
        protected int doLong(LLVMPointer addr, long element) {
            return this.load.executeWithTarget(addr, this.typeWidth * element);
        }

        @Specialization
        protected int doNativePointer(LLVMPointer addr, LLVMNativePointer element) {
            return this.load.executeWithTarget(addr, this.typeWidth * element.asNative());
        }
    }

    @ImportStatic(value={LLVMWithElementPtrStoreNode.class})
    public static abstract class LLVMWithElementPtrLoadI16Node
    extends LLVMWithElementPtrLoadNode {
        @Node.Child
        private LLVMI16LoadNode.LLVMI16OffsetLoadNode load = LLVMI16LoadNode.LLVMI16OffsetLoadNode.create();

        protected LLVMWithElementPtrLoadI16Node(long typeWidth) {
            super(typeWidth);
        }

        @Specialization(guards={"isNegated(addr.getObject(), element.getObject())"})
        protected short doPointerDiff(LLVMManagedPointer addr, LLVMManagedPointer element) {
            return this.load.executeWithTarget(LLVMNativePointer.create(addr.getOffset() + element.getOffset()), 0L);
        }

        @Specialization(guards={"isNegated(element.getObject(), addr.getObject())"})
        protected short doPointerDiffRev(LLVMManagedPointer addr, LLVMManagedPointer element) {
            return this.load.executeWithTarget(LLVMNativePointer.create(element.getOffset() + addr.getOffset()), 0L);
        }

        @Specialization
        protected short doInt(LLVMPointer addr, int element) {
            return this.load.executeWithTarget(addr, this.typeWidth * (long)element);
        }

        @Specialization
        protected short doLong(LLVMPointer addr, long element) {
            return this.load.executeWithTarget(addr, this.typeWidth * element);
        }

        @Specialization
        protected short doNativePointer(LLVMPointer addr, LLVMNativePointer element) {
            return this.load.executeWithTarget(addr, this.typeWidth * element.asNative());
        }
    }

    @ImportStatic(value={LLVMWithElementPtrStoreNode.class})
    public static abstract class LLVMWithElementPtrLoadI8Node
    extends LLVMWithElementPtrLoadNode {
        @Node.Child
        private LLVMI8LoadNode.LLVMI8OffsetLoadNode load = LLVMI8LoadNode.LLVMI8OffsetLoadNode.create();

        protected LLVMWithElementPtrLoadI8Node(long typeWidth) {
            super(typeWidth);
        }

        @Specialization(guards={"isNegated(addr.getObject(), element.getObject())"})
        protected byte doPointerDiff(LLVMManagedPointer addr, LLVMManagedPointer element) {
            return this.load.executeWithTarget(LLVMNativePointer.create(addr.getOffset() + element.getOffset()), 0L);
        }

        @Specialization(guards={"isNegated(element.getObject(), addr.getObject())"})
        protected byte doPointerDiffRev(LLVMManagedPointer addr, LLVMManagedPointer element) {
            return this.load.executeWithTarget(LLVMNativePointer.create(element.getOffset() + addr.getOffset()), 0L);
        }

        @Specialization
        protected byte doInt(LLVMPointer addr, int element) {
            return this.load.executeWithTarget(addr, this.typeWidth * (long)element);
        }

        @Specialization
        protected byte doLong(LLVMPointer addr, long element) {
            return this.load.executeWithTarget(addr, this.typeWidth * element);
        }

        @Specialization
        protected byte doNativePointer(LLVMPointer addr, LLVMNativePointer element) {
            return this.load.executeWithTarget(addr, this.typeWidth * element.asNative());
        }
    }
}

