/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.llvm.runtime.CommonNodeFactory;
import com.oracle.truffle.llvm.runtime.except.LLVMPolyglotException;
import com.oracle.truffle.llvm.runtime.interop.convert.ForeignToLLVM;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMReadStringNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMIntrinsic;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;

@NodeChild(value="name", type=LLVMExpressionNode.class)
public abstract class LLVMPolyglotImport
extends LLVMIntrinsic {
    @Specialization
    @GenerateAOT.Exclude
    protected Object doImport(Object name, @Cached LLVMReadStringNode readString, @CachedLibrary(limit="3") InteropLibrary interop, @Cached(value="createToLLVM()") ForeignToLLVM toLLVM, @Cached BranchProfile notFound, @Cached BranchProfile exception) {
        String symbolName = readString.executeWithTarget(name);
        try {
            Object ret = interop.readMember(this.getContext().getEnv().getPolyglotBindings(), symbolName);
            return toLLVM.executeWithTarget(ret);
        }
        catch (UnknownIdentifierException ex) {
            notFound.enter();
            return LLVMNativePointer.createNull();
        }
        catch (UnsupportedMessageException ex) {
            exception.enter();
            throw new LLVMPolyglotException(this, ex.getMessage());
        }
    }

    ForeignToLLVM createToLLVM() {
        return CommonNodeFactory.createForeignToLLVM(ForeignToLLVM.ForeignToLLVMType.POINTER);
    }
}

