/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.llvm.runtime.LLVMArgumentBuffer;
import com.oracle.truffle.llvm.runtime.except.LLVMPolyglotException;
import com.oracle.truffle.llvm.runtime.interop.LLVMAsForeignNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMIntrinsic;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;

@NodeChild(type=LLVMExpressionNode.class)
public abstract class LLVMPolyglotGetArraySize
extends LLVMIntrinsic {
    static boolean isLLVMArgumentBuffer(LLVMManagedPointer pointer) {
        return pointer.getObject() instanceof LLVMArgumentBuffer;
    }

    @Specialization(guards={"isLLVMArgumentBuffer(pointer)"})
    protected long doLLVMArgumentBuffer(LLVMManagedPointer pointer) {
        return ((LLVMArgumentBuffer)pointer.getObject()).getArraySize();
    }

    @Specialization(guards={"!isLLVMArgumentBuffer(pointer)"})
    @GenerateAOT.Exclude
    protected long doGenericManagedPointer(LLVMManagedPointer pointer, @Cached LLVMAsForeignNode asForeign, @CachedLibrary(limit="3") InteropLibrary interop, @Cached BranchProfile exception) {
        Object foreign = asForeign.execute(pointer);
        try {
            return interop.getArraySize(foreign);
        }
        catch (UnsupportedMessageException ex) {
            exception.enter();
            throw new LLVMPolyglotException(this, "Polyglot value is no array.");
        }
    }

    @Fallback
    public long fallback(Object value) {
        throw new LLVMPolyglotException(this, "Invalid argument to polyglot builtin.");
    }
}

