/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.control;

import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.instrumentation.ProbeNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStatementNode;
import com.oracle.truffle.llvm.runtime.nodes.control.LLVMSwitchNode;

@GeneratedBy(value=LLVMSwitchNode.class)
final class LLVMSwitchNodeWrapper
extends LLVMSwitchNode
implements InstrumentableNode.WrapperNode {
    @Node.Child
    private LLVMSwitchNode delegateNode;
    @Node.Child
    private ProbeNode probeNode;

    LLVMSwitchNodeWrapper(LLVMSwitchNode delegateNode, ProbeNode probeNode) {
        this.delegateNode = delegateNode;
        this.probeNode = probeNode;
    }

    public LLVMSwitchNode getDelegateNode() {
        return this.delegateNode;
    }

    public ProbeNode getProbeNode() {
        return this.probeNode;
    }

    @Override
    public Object executeCondition(VirtualFrame frame) {
        Object returnValue;
        while (true) {
            boolean wasOnReturnExecuted = false;
            try {
                this.probeNode.onEnter(frame);
                returnValue = this.delegateNode.executeCondition(frame);
                wasOnReturnExecuted = true;
                this.probeNode.onReturnValue(frame, returnValue);
            }
            catch (Throwable t) {
                Object result;
                if ((result = this.probeNode.onReturnExceptionalOrUnwind(frame, t, wasOnReturnExecuted)) == ProbeNode.UNWIND_ACTION_REENTER) continue;
                if (result != null) {
                    returnValue = result;
                    break;
                }
                throw t;
            }
            break;
        }
        return returnValue;
    }

    @Override
    public int getSuccessorCount() {
        return this.delegateNode.getSuccessorCount();
    }

    @Override
    public int[] getSuccessors() {
        return this.delegateNode.getSuccessors();
    }

    @Override
    public LLVMStatementNode getPhiNode(int successorIndex) {
        return this.delegateNode.getPhiNode(successorIndex);
    }

    @Override
    public boolean checkCase(VirtualFrame frame, int i, Object value) {
        return this.delegateNode.checkCase(frame, i, value);
    }
}

