/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.cast;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.llvm.runtime.CommonNodeFactory;
import com.oracle.truffle.llvm.runtime.floating.LLVM128BitFloat;
import com.oracle.truffle.llvm.runtime.floating.LLVM80BitFloat;
import com.oracle.truffle.llvm.runtime.interop.convert.ForeignToLLVM;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMAsForeignLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToNativeNode;
import com.oracle.truffle.llvm.runtime.nodes.cast.LLVMToDoubleNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.cast.LLVMToI64Node;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.vector.LLVMDoubleVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMFloatVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI16Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI1Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI32Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI64Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI8Vector;

@NodeChild(value="fromNode", type=LLVMExpressionNode.class)
public abstract class LLVMToDoubleNode
extends LLVMExpressionNode {
    protected final boolean isRecursive;

    protected LLVMToDoubleNode() {
        this(false);
    }

    protected LLVMToDoubleNode(boolean isRecursive) {
        this.isRecursive = isRecursive;
    }

    protected abstract double executeWith(long var1);

    protected LLVMToDoubleNode createRecursive() {
        throw new IllegalStateException("abstract node LLVMToDoubleNode used");
    }

    @Specialization(guards={"isForeignNumber(from, foreigns, interop)"})
    @GenerateAOT.Exclude
    protected double doManagedPointer(LLVMManagedPointer from, @Cached(value="createForeignToLLVM()") ForeignToLLVM toLLVM, @Cached(value="createRecursive()") LLVMToDoubleNode recursive, @CachedLibrary(limit="1") LLVMAsForeignLibrary foreigns, @CachedLibrary(limit="3") InteropLibrary interop) {
        long ptr = (Long)toLLVM.executeWithTarget(foreigns.asForeign(from.getObject()));
        return recursive.executeWith(ptr);
    }

    @Specialization(guards={"!isRecursive"})
    protected double doPointer(LLVMPointer from, @Cached(value="createToNativeWithTarget()") LLVMToNativeNode toNative, @Cached(value="createRecursive()") LLVMToDoubleNode recursive) {
        long ptr = toNative.executeWithTarget(from).asNative();
        return recursive.executeWith(ptr);
    }

    protected ForeignToLLVM createForeignToLLVM() {
        return CommonNodeFactory.createForeignToLLVM(ForeignToLLVM.ForeignToLLVMType.DOUBLE);
    }

    protected static boolean isForeignNumber(LLVMManagedPointer pointer, LLVMAsForeignLibrary foreigns, InteropLibrary interop) {
        return foreigns.isForeign(pointer) && interop.isNumber(pointer.getObject());
    }

    public static abstract class LLVMBitcastToDoubleNode
    extends LLVMToDoubleNode {
        protected LLVMBitcastToDoubleNode() {
        }

        protected LLVMBitcastToDoubleNode(boolean isRecursive) {
            super(isRecursive);
        }

        @Override
        protected LLVMToDoubleNode createRecursive() {
            return LLVMToDoubleNodeGen.LLVMBitcastToDoubleNodeGen.create(true, null);
        }

        @Specialization
        protected double doDouble(long from) {
            return Double.longBitsToDouble(from);
        }

        @Specialization
        protected double doDouble(double from) {
            return from;
        }

        @Specialization
        protected double doFloat(float from) {
            return from;
        }

        @Specialization
        protected double doI1Vector(LLVMI1Vector from) {
            long raw = LLVMToI64Node.LLVMBitcastToI64Node.castI1Vector(from, 64);
            return Double.longBitsToDouble(raw);
        }

        @Specialization
        protected double doI8Vector(LLVMI8Vector from) {
            long raw = LLVMToI64Node.LLVMBitcastToI64Node.castI8Vector(from, 8);
            return Double.longBitsToDouble(raw);
        }

        @Specialization
        protected double doI16Vector(LLVMI16Vector from) {
            long raw = LLVMToI64Node.LLVMBitcastToI64Node.castI16Vector(from, 4);
            return Double.longBitsToDouble(raw);
        }

        @Specialization
        protected double doI32Vector(LLVMI32Vector from) {
            long raw = LLVMToI64Node.LLVMBitcastToI64Node.castI32Vector(from, 2);
            return Double.longBitsToDouble(raw);
        }

        @Specialization
        protected double doFloatVector(LLVMFloatVector from) {
            long raw = LLVMToI64Node.LLVMBitcastToI64Node.castFloatVector(from, 2);
            return Double.longBitsToDouble(raw);
        }

        @Specialization
        protected double doI64Vector(LLVMI64Vector from) {
            assert (from.getLength() == 1) : "invalid vector size";
            return Double.longBitsToDouble(from.getValue(0));
        }

        @Specialization
        protected double doDoubleVector(LLVMDoubleVector from) {
            assert (from.getLength() == 1) : "invalid vector size";
            return from.getValue(0);
        }
    }

    public static abstract class LLVMUnsignedCastToDoubleNode
    extends LLVMToDoubleNode {
        private static final double LEADING_BIT = 9.223372036854776E18;

        protected LLVMUnsignedCastToDoubleNode() {
        }

        protected LLVMUnsignedCastToDoubleNode(boolean isRecursive) {
            super(isRecursive);
        }

        @Override
        protected LLVMToDoubleNode createRecursive() {
            return LLVMToDoubleNodeGen.LLVMUnsignedCastToDoubleNodeGen.create(true, null);
        }

        @Specialization
        protected double doDouble(boolean from) {
            return from ? 1.0 : 0.0;
        }

        @Specialization
        protected double doDouble(byte from) {
            return from & 0xFF;
        }

        @Specialization
        protected double doDouble(short from) {
            return from & 0xFFFF;
        }

        @Specialization
        protected double doDouble(int from) {
            return (long)from & 0xFFFFFFFFL;
        }

        @Specialization
        protected double doDouble(long from) {
            return LLVMUnsignedCastToDoubleNode.doI64(from);
        }

        public static double doI64(long from) {
            double val = from & Long.MAX_VALUE;
            if (from < 0L) {
                val += 9.223372036854776E18;
            }
            return val;
        }

        @Specialization
        protected double doDouble(double from) {
            return from;
        }
    }

    public static abstract class LLVMSignedCastToDoubleNode
    extends LLVMToDoubleNode {
        protected LLVMSignedCastToDoubleNode() {
        }

        protected LLVMSignedCastToDoubleNode(boolean isRecursive) {
            super(isRecursive);
        }

        @Override
        protected LLVMToDoubleNode createRecursive() {
            return LLVMToDoubleNodeGen.LLVMSignedCastToDoubleNodeGen.create(true, null);
        }

        @Specialization
        protected double doDouble(boolean from) {
            return from ? -1.0 : 0.0;
        }

        @Specialization
        protected double doDouble(byte from) {
            return from;
        }

        @Specialization
        protected double doDouble(short from) {
            return from;
        }

        @Specialization
        protected double doDouble(int from) {
            return from;
        }

        @Specialization
        protected double doDouble(long from) {
            return from;
        }

        @Specialization
        protected double doDouble(float from) {
            return from;
        }

        @Specialization
        protected double doDouble(double from) {
            return from;
        }

        @Specialization
        protected double doDouble(LLVM80BitFloat from) {
            return from.toDoubleValue();
        }

        @Specialization
        protected double doDouble(LLVM128BitFloat from) {
            return from.toDoubleValue();
        }
    }
}

