/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.asm.support;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypesGen;
import com.oracle.truffle.llvm.runtime.nodes.asm.support.LLVMAMD64AddressComputationNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.util.concurrent.locks.ReentrantLock;

@GeneratedBy(value=LLVMAMD64AddressComputationNode.class)
public final class LLVMAMD64AddressComputationNodeFactory {

    @GeneratedBy(value=LLVMAMD64AddressComputationNode.LLVMAMD64AddressSegmentComputationNode.class)
    public static final class LLVMAMD64AddressSegmentComputationNodeGen
    extends LLVMAMD64AddressComputationNode.LLVMAMD64AddressSegmentComputationNode
    implements GenerateAOT.Provider {
        @Node.Child
        private LLVMExpressionNode base_;
        @Node.Child
        private LLVMExpressionNode offset_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private LLVMAMD64AddressSegmentComputationNodeGen(LLVMExpressionNode base, LLVMExpressionNode offset) {
            this.base_ = base;
            this.offset_ = offset;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object baseValue_ = this.base_.executeGeneric(frameValue);
            if ((state_0 & 2) == 0 && (state_0 & 6) != 0) {
                return this.executeGeneric_long0(state_0, frameValue, baseValue_);
            }
            return this.executeGeneric_generic1(state_0, frameValue, baseValue_);
        }

        private Object executeGeneric_long0(int state_0__, VirtualFrame frameValue, Object baseValue_) {
            long offsetValue_;
            int state_0 = state_0__;
            try {
                offsetValue_ = this.offset_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(baseValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(baseValue_, offsetValue_);
            }
            assert ((state_0 & 4) != 0);
            if (LLVMTypes.isPointer(baseValue_)) {
                LLVMPointer baseValue__ = LLVMTypes.asPointer(baseValue_);
                return this.doI64(baseValue__, offsetValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(baseValue_, offsetValue_);
        }

        private Object executeGeneric_generic1(int state_0__, VirtualFrame frameValue, Object baseValue_) {
            int state_0 = state_0__;
            Object offsetValue_ = this.offset_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(baseValue_, offsetValue_);
            }
            if ((state_0 & 6) != 0 && LLVMTypes.isPointer(baseValue_)) {
                LLVMPointer baseValue__ = LLVMTypes.asPointer(baseValue_);
                if ((state_0 & 2) != 0 && LLVMTypes.isNativePointer(offsetValue_)) {
                    LLVMNativePointer offsetValue__ = LLVMTypes.asNativePointer(offsetValue_);
                    return this.doLLVMPointer(baseValue__, offsetValue__);
                }
                if ((state_0 & 4) != 0 && offsetValue_ instanceof Long) {
                    long offsetValue__ = (Long)offsetValue_;
                    return this.doI64(baseValue__, offsetValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(baseValue_, offsetValue_);
        }

        private LLVMPointer executeAndSpecialize(Object baseValue, Object offsetValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (LLVMTypes.isPointer(baseValue)) {
                LLVMPointer baseValue_ = LLVMTypes.asPointer(baseValue);
                if (LLVMTypes.isNativePointer(offsetValue)) {
                    LLVMNativePointer offsetValue_ = LLVMTypes.asNativePointer(offsetValue);
                    this.state_0_ = state_0 |= 2;
                    return this.doLLVMPointer(baseValue_, offsetValue_);
                }
                if (offsetValue instanceof Long) {
                    long offsetValue_ = (Long)offsetValue;
                    this.state_0_ = state_0 |= 4;
                    return this.doI64(baseValue_, offsetValue_);
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.base_, this.offset_}, new Object[]{baseValue, offsetValue});
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            this.state_0_ |= 4;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMAMD64AddressComputationNode.LLVMAMD64AddressSegmentComputationNode create(LLVMExpressionNode base, LLVMExpressionNode offset) {
            return new LLVMAMD64AddressSegmentComputationNodeGen(base, offset);
        }
    }

    @GeneratedBy(value=LLVMAMD64AddressComputationNode.LLVMAMD64AddressNoBaseOffsetComputationNode.class)
    public static final class LLVMAMD64AddressNoBaseOffsetComputationNodeGen
    extends LLVMAMD64AddressComputationNode.LLVMAMD64AddressNoBaseOffsetComputationNode
    implements GenerateAOT.Provider {
        @Node.Child
        private LLVMExpressionNode offset_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private LLVMAMD64AddressNoBaseOffsetComputationNodeGen(int displacement, int shift, LLVMExpressionNode offset) {
            super(displacement, shift);
            this.offset_ = offset;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0xC) == 0 && (state_0 & 0xE) != 0) {
                return this.executeGeneric_int0(state_0, frameValue);
            }
            if ((state_0 & 0xA) == 0 && (state_0 & 0xE) != 0) {
                return this.executeGeneric_long1(state_0, frameValue);
            }
            return this.executeGeneric_generic2(state_0, frameValue);
        }

        private Object executeGeneric_int0(int state_0__, VirtualFrame frameValue) {
            int offsetValue_;
            int state_0 = state_0__;
            try {
                offsetValue_ = this.offset_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(offsetValue_);
            }
            assert ((state_0 & 2) != 0);
            return this.doInt(offsetValue_);
        }

        private Object executeGeneric_long1(int state_0__, VirtualFrame frameValue) {
            long offsetValue_;
            int state_0 = state_0__;
            try {
                offsetValue_ = this.offset_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(offsetValue_);
            }
            assert ((state_0 & 4) != 0);
            return this.doLong(offsetValue_);
        }

        private Object executeGeneric_generic2(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object offsetValue_ = this.offset_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(offsetValue_);
            }
            if ((state_0 & 0xE) != 0) {
                if ((state_0 & 2) != 0 && offsetValue_ instanceof Integer) {
                    int offsetValue__ = (Integer)offsetValue_;
                    return this.doInt(offsetValue__);
                }
                if ((state_0 & 4) != 0 && offsetValue_ instanceof Long) {
                    long offsetValue__ = (Long)offsetValue_;
                    return this.doLong(offsetValue__);
                }
                if ((state_0 & 8) != 0 && LLVMTypes.isNativePointer(offsetValue_)) {
                    LLVMNativePointer offsetValue__ = LLVMTypes.asNativePointer(offsetValue_);
                    return this.doLLVMNativePointer(offsetValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(offsetValue_);
        }

        @Override
        public long executeI64(VirtualFrame frameValue) throws UnexpectedResultException {
            long offsetValue_;
            int state_0 = this.state_0_;
            try {
                offsetValue_ = this.offset_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(ex.getResult()));
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(offsetValue_));
            }
            if ((state_0 & 4) != 0) {
                return this.doLong(offsetValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectLong(this.executeAndSpecialize(offsetValue_));
        }

        private Object executeAndSpecialize(Object offsetValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (offsetValue instanceof Integer) {
                int offsetValue_ = (Integer)offsetValue;
                this.state_0_ = state_0 |= 2;
                return this.doInt(offsetValue_);
            }
            if (offsetValue instanceof Long) {
                long offsetValue_ = (Long)offsetValue;
                this.state_0_ = state_0 |= 4;
                return this.doLong(offsetValue_);
            }
            if (LLVMTypes.isNativePointer(offsetValue)) {
                LLVMNativePointer offsetValue_ = LLVMTypes.asNativePointer(offsetValue);
                this.state_0_ = state_0 |= 8;
                return this.doLLVMNativePointer(offsetValue_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.offset_}, new Object[]{offsetValue});
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            this.state_0_ |= 4;
            this.state_0_ |= 8;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMAMD64AddressComputationNode.LLVMAMD64AddressNoBaseOffsetComputationNode create(int displacement, int shift, LLVMExpressionNode offset) {
            return new LLVMAMD64AddressNoBaseOffsetComputationNodeGen(displacement, shift, offset);
        }
    }

    @GeneratedBy(value=LLVMAMD64AddressComputationNode.LLVMAMD64AddressOffsetComputationNode.class)
    public static final class LLVMAMD64AddressOffsetComputationNodeGen
    extends LLVMAMD64AddressComputationNode.LLVMAMD64AddressOffsetComputationNode
    implements GenerateAOT.Provider {
        @Node.Child
        private LLVMExpressionNode base_;
        @Node.Child
        private LLVMExpressionNode offset_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private LLVMAMD64AddressOffsetComputationNodeGen(int displacement, int shift, LLVMExpressionNode base, LLVMExpressionNode offset) {
            super(displacement, shift);
            this.base_ = base;
            this.offset_ = offset;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0x3C) == 0 && (state_0 & 0x3E) != 0) {
                return this.executeGeneric_int_int0(state_0, frameValue);
            }
            if ((state_0 & 0x3A) == 0 && (state_0 & 0x3E) != 0) {
                return this.executeGeneric_long_int1(state_0, frameValue);
            }
            if ((state_0 & 0x36) == 0 && (state_0 & 0x3E) != 0) {
                return this.executeGeneric_long_long2(state_0, frameValue);
            }
            if ((state_0 & 0x2E) == 0 && (state_0 & 0x3E) != 0) {
                return this.executeGeneric_int3(state_0, frameValue);
            }
            if ((state_0 & 0x1E) == 0 && (state_0 & 0x3E) != 0) {
                return this.executeGeneric_long4(state_0, frameValue);
            }
            return this.executeGeneric_generic5(state_0, frameValue);
        }

        private Object executeGeneric_int_int0(int state_0__, VirtualFrame frameValue) {
            int offsetValue_;
            int baseValue_;
            int state_0 = state_0__;
            try {
                baseValue_ = this.base_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object offsetValue = this.offset_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), offsetValue);
            }
            try {
                offsetValue_ = this.offset_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(baseValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(baseValue_, offsetValue_);
            }
            assert ((state_0 & 2) != 0);
            return this.doI64(baseValue_, offsetValue_);
        }

        private Object executeGeneric_long_int1(int state_0__, VirtualFrame frameValue) {
            int offsetValue_;
            long baseValue_;
            int state_0 = state_0__;
            try {
                baseValue_ = this.base_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object offsetValue = this.offset_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), offsetValue);
            }
            try {
                offsetValue_ = this.offset_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(baseValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(baseValue_, offsetValue_);
            }
            assert ((state_0 & 4) != 0);
            return this.doI64(baseValue_, offsetValue_);
        }

        private Object executeGeneric_long_long2(int state_0__, VirtualFrame frameValue) {
            long offsetValue_;
            long baseValue_;
            int state_0 = state_0__;
            try {
                baseValue_ = this.base_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object offsetValue = this.offset_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), offsetValue);
            }
            try {
                offsetValue_ = this.offset_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(baseValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(baseValue_, offsetValue_);
            }
            assert ((state_0 & 8) != 0);
            return this.doI64(baseValue_, offsetValue_);
        }

        private Object executeGeneric_int3(int state_0__, VirtualFrame frameValue) {
            int offsetValue_;
            int state_0 = state_0__;
            Object baseValue_ = this.base_.executeGeneric(frameValue);
            try {
                offsetValue_ = this.offset_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(baseValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(baseValue_, offsetValue_);
            }
            assert ((state_0 & 0x10) != 0);
            if (LLVMTypes.isPointer(baseValue_)) {
                LLVMPointer baseValue__ = LLVMTypes.asPointer(baseValue_);
                return this.doLLVMPointer(baseValue__, offsetValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(baseValue_, offsetValue_);
        }

        private Object executeGeneric_long4(int state_0__, VirtualFrame frameValue) {
            long offsetValue_;
            int state_0 = state_0__;
            Object baseValue_ = this.base_.executeGeneric(frameValue);
            try {
                offsetValue_ = this.offset_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(baseValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(baseValue_, offsetValue_);
            }
            assert ((state_0 & 0x20) != 0);
            if (LLVMTypes.isPointer(baseValue_)) {
                LLVMPointer baseValue__ = LLVMTypes.asPointer(baseValue_);
                return this.doLLVMPointer(baseValue__, offsetValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(baseValue_, offsetValue_);
        }

        private Object executeGeneric_generic5(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object baseValue_ = this.base_.executeGeneric(frameValue);
            Object offsetValue_ = this.offset_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(baseValue_, offsetValue_);
            }
            if ((state_0 & 0x3E) != 0) {
                if ((state_0 & 6) != 0 && offsetValue_ instanceof Integer) {
                    int offsetValue__ = (Integer)offsetValue_;
                    if ((state_0 & 2) != 0 && baseValue_ instanceof Integer) {
                        int baseValue__ = (Integer)baseValue_;
                        return this.doI64(baseValue__, offsetValue__);
                    }
                    if ((state_0 & 4) != 0 && baseValue_ instanceof Long) {
                        long baseValue__ = (Long)baseValue_;
                        return this.doI64(baseValue__, offsetValue__);
                    }
                }
                if ((state_0 & 8) != 0 && baseValue_ instanceof Long) {
                    long baseValue__ = (Long)baseValue_;
                    if (offsetValue_ instanceof Long) {
                        long offsetValue__ = (Long)offsetValue_;
                        return this.doI64(baseValue__, offsetValue__);
                    }
                }
                if ((state_0 & 0x30) != 0 && LLVMTypes.isPointer(baseValue_)) {
                    LLVMPointer baseValue__ = LLVMTypes.asPointer(baseValue_);
                    if ((state_0 & 0x10) != 0 && offsetValue_ instanceof Integer) {
                        int offsetValue__ = (Integer)offsetValue_;
                        return this.doLLVMPointer(baseValue__, offsetValue__);
                    }
                    if ((state_0 & 0x20) != 0 && offsetValue_ instanceof Long) {
                        long offsetValue__ = (Long)offsetValue_;
                        return this.doLLVMPointer(baseValue__, offsetValue__);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(baseValue_, offsetValue_);
        }

        @Override
        public long executeI64(VirtualFrame frameValue) throws UnexpectedResultException {
            int state_0 = this.state_0_;
            if ((state_0 & 0xC) == 0 && (state_0 & 0xE) != 0) {
                return this.executeI64_int_int6(state_0, frameValue);
            }
            if ((state_0 & 0xA) == 0 && (state_0 & 0xE) != 0) {
                return this.executeI64_long_int7(state_0, frameValue);
            }
            if ((state_0 & 6) == 0 && (state_0 & 0xE) != 0) {
                return this.executeI64_long_long8(state_0, frameValue);
            }
            return this.executeI64_generic9(state_0, frameValue);
        }

        private long executeI64_int_int6(int state_0__, VirtualFrame frameValue) throws UnexpectedResultException {
            int offsetValue_;
            int baseValue_;
            int state_0 = state_0__;
            try {
                baseValue_ = this.base_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object offsetValue = this.offset_.executeGeneric(frameValue);
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(ex.getResult(), offsetValue));
            }
            try {
                offsetValue_ = this.offset_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(baseValue_, ex.getResult()));
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(baseValue_, offsetValue_));
            }
            assert ((state_0 & 2) != 0);
            return this.doI64(baseValue_, offsetValue_);
        }

        private long executeI64_long_int7(int state_0__, VirtualFrame frameValue) throws UnexpectedResultException {
            int offsetValue_;
            long baseValue_;
            int state_0 = state_0__;
            try {
                baseValue_ = this.base_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object offsetValue = this.offset_.executeGeneric(frameValue);
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(ex.getResult(), offsetValue));
            }
            try {
                offsetValue_ = this.offset_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(baseValue_, ex.getResult()));
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(baseValue_, offsetValue_));
            }
            assert ((state_0 & 4) != 0);
            return this.doI64(baseValue_, offsetValue_);
        }

        private long executeI64_long_long8(int state_0__, VirtualFrame frameValue) throws UnexpectedResultException {
            long offsetValue_;
            long baseValue_;
            int state_0 = state_0__;
            try {
                baseValue_ = this.base_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object offsetValue = this.offset_.executeGeneric(frameValue);
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(ex.getResult(), offsetValue));
            }
            try {
                offsetValue_ = this.offset_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(baseValue_, ex.getResult()));
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(baseValue_, offsetValue_));
            }
            assert ((state_0 & 8) != 0);
            return this.doI64(baseValue_, offsetValue_);
        }

        private long executeI64_generic9(int state_0__, VirtualFrame frameValue) throws UnexpectedResultException {
            int state_0 = state_0__;
            Object baseValue_ = this.base_.executeGeneric(frameValue);
            Object offsetValue_ = this.offset_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(baseValue_, offsetValue_));
            }
            if ((state_0 & 0xE) != 0) {
                if ((state_0 & 6) != 0 && offsetValue_ instanceof Integer) {
                    int offsetValue__ = (Integer)offsetValue_;
                    if ((state_0 & 2) != 0 && baseValue_ instanceof Integer) {
                        int baseValue__ = (Integer)baseValue_;
                        return this.doI64(baseValue__, offsetValue__);
                    }
                    if ((state_0 & 4) != 0 && baseValue_ instanceof Long) {
                        long baseValue__ = (Long)baseValue_;
                        return this.doI64(baseValue__, offsetValue__);
                    }
                }
                if ((state_0 & 8) != 0 && baseValue_ instanceof Long) {
                    long baseValue__ = (Long)baseValue_;
                    if (offsetValue_ instanceof Long) {
                        long offsetValue__ = (Long)offsetValue_;
                        return this.doI64(baseValue__, offsetValue__);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectLong(this.executeAndSpecialize(baseValue_, offsetValue_));
        }

        private Object executeAndSpecialize(Object baseValue, Object offsetValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (offsetValue instanceof Integer) {
                int offsetValue_ = (Integer)offsetValue;
                if (baseValue instanceof Integer) {
                    int baseValue_ = (Integer)baseValue;
                    this.state_0_ = state_0 |= 2;
                    return this.doI64(baseValue_, offsetValue_);
                }
                if (baseValue instanceof Long) {
                    long baseValue_ = (Long)baseValue;
                    this.state_0_ = state_0 |= 4;
                    return this.doI64(baseValue_, offsetValue_);
                }
            }
            if (baseValue instanceof Long) {
                long baseValue_ = (Long)baseValue;
                if (offsetValue instanceof Long) {
                    long offsetValue_ = (Long)offsetValue;
                    this.state_0_ = state_0 |= 8;
                    return this.doI64(baseValue_, offsetValue_);
                }
            }
            if (LLVMTypes.isPointer(baseValue)) {
                LLVMPointer baseValue_ = LLVMTypes.asPointer(baseValue);
                if (offsetValue instanceof Integer) {
                    int offsetValue_ = (Integer)offsetValue;
                    this.state_0_ = state_0 |= 0x10;
                    return this.doLLVMPointer(baseValue_, offsetValue_);
                }
                if (offsetValue instanceof Long) {
                    long offsetValue_ = (Long)offsetValue;
                    this.state_0_ = state_0 |= 0x20;
                    return this.doLLVMPointer(baseValue_, offsetValue_);
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.base_, this.offset_}, new Object[]{baseValue, offsetValue});
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            this.state_0_ |= 4;
            this.state_0_ |= 8;
            this.state_0_ |= 0x10;
            this.state_0_ |= 0x20;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMAMD64AddressComputationNode.LLVMAMD64AddressOffsetComputationNode create(int displacement, int shift, LLVMExpressionNode base, LLVMExpressionNode offset) {
            return new LLVMAMD64AddressOffsetComputationNodeGen(displacement, shift, base, offset);
        }
    }

    @GeneratedBy(value=LLVMAMD64AddressComputationNode.LLVMAMD64AddressDisplacementComputationNode.class)
    public static final class LLVMAMD64AddressDisplacementComputationNodeGen
    extends LLVMAMD64AddressComputationNode.LLVMAMD64AddressDisplacementComputationNode
    implements GenerateAOT.Provider {
        @Node.Child
        private LLVMExpressionNode base_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private LLVMAMD64AddressDisplacementComputationNodeGen(int displacement, LLVMExpressionNode base) {
            super(displacement);
            this.base_ = base;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0xA) == 0 && (state_0 & 0xE) != 0) {
                return this.executeGeneric_int0(state_0, frameValue);
            }
            if ((state_0 & 6) == 0 && (state_0 & 0xE) != 0) {
                return this.executeGeneric_long1(state_0, frameValue);
            }
            return this.executeGeneric_generic2(state_0, frameValue);
        }

        private Object executeGeneric_int0(int state_0__, VirtualFrame frameValue) {
            int baseValue_;
            int state_0 = state_0__;
            try {
                baseValue_ = this.base_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(baseValue_);
            }
            assert ((state_0 & 4) != 0);
            return this.doInt(baseValue_);
        }

        private Object executeGeneric_long1(int state_0__, VirtualFrame frameValue) {
            long baseValue_;
            int state_0 = state_0__;
            try {
                baseValue_ = this.base_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(baseValue_);
            }
            assert ((state_0 & 8) != 0);
            return this.doLong(baseValue_);
        }

        private Object executeGeneric_generic2(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object baseValue_ = this.base_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(baseValue_);
            }
            if ((state_0 & 0xE) != 0) {
                if ((state_0 & 2) != 0 && LLVMTypes.isPointer(baseValue_)) {
                    LLVMPointer baseValue__ = LLVMTypes.asPointer(baseValue_);
                    return this.doLLVMPointer(baseValue__);
                }
                if ((state_0 & 4) != 0 && baseValue_ instanceof Integer) {
                    int baseValue__ = (Integer)baseValue_;
                    return this.doInt(baseValue__);
                }
                if ((state_0 & 8) != 0 && baseValue_ instanceof Long) {
                    long baseValue__ = (Long)baseValue_;
                    return this.doLong(baseValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(baseValue_);
        }

        @Override
        public long executeI64(VirtualFrame frameValue) throws UnexpectedResultException {
            int state_0 = this.state_0_;
            if ((state_0 & 8) == 0 && (state_0 & 0xC) != 0) {
                return this.executeI64_int3(state_0, frameValue);
            }
            if ((state_0 & 4) == 0 && (state_0 & 0xC) != 0) {
                return this.executeI64_long4(state_0, frameValue);
            }
            return this.executeI64_generic5(state_0, frameValue);
        }

        private long executeI64_int3(int state_0__, VirtualFrame frameValue) throws UnexpectedResultException {
            int baseValue_;
            int state_0 = state_0__;
            try {
                baseValue_ = this.base_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(ex.getResult()));
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(baseValue_));
            }
            assert ((state_0 & 4) != 0);
            return this.doInt(baseValue_);
        }

        private long executeI64_long4(int state_0__, VirtualFrame frameValue) throws UnexpectedResultException {
            long baseValue_;
            int state_0 = state_0__;
            try {
                baseValue_ = this.base_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(ex.getResult()));
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(baseValue_));
            }
            assert ((state_0 & 8) != 0);
            return this.doLong(baseValue_);
        }

        private long executeI64_generic5(int state_0__, VirtualFrame frameValue) throws UnexpectedResultException {
            int state_0 = state_0__;
            Object baseValue_ = this.base_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(baseValue_));
            }
            if ((state_0 & 0xC) != 0) {
                if ((state_0 & 4) != 0 && baseValue_ instanceof Integer) {
                    int baseValue__ = (Integer)baseValue_;
                    return this.doInt(baseValue__);
                }
                if ((state_0 & 8) != 0 && baseValue_ instanceof Long) {
                    long baseValue__ = (Long)baseValue_;
                    return this.doLong(baseValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectLong(this.executeAndSpecialize(baseValue_));
        }

        private Object executeAndSpecialize(Object baseValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (LLVMTypes.isPointer(baseValue)) {
                LLVMPointer baseValue_ = LLVMTypes.asPointer(baseValue);
                this.state_0_ = state_0 |= 2;
                return this.doLLVMPointer(baseValue_);
            }
            if (baseValue instanceof Integer) {
                int baseValue_ = (Integer)baseValue;
                this.state_0_ = state_0 |= 4;
                return this.doInt(baseValue_);
            }
            if (baseValue instanceof Long) {
                long baseValue_ = (Long)baseValue;
                this.state_0_ = state_0 |= 8;
                return this.doLong(baseValue_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.base_}, new Object[]{baseValue});
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            this.state_0_ |= 4;
            this.state_0_ |= 8;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMAMD64AddressComputationNode.LLVMAMD64AddressDisplacementComputationNode create(int displacement, LLVMExpressionNode base) {
            return new LLVMAMD64AddressDisplacementComputationNodeGen(displacement, base);
        }
    }
}

