/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.asm;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStatementNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.LLVMAMD64DivNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.support.LLVMAMD64WriteTupelNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.support.LongDivision;

public abstract class LLVMAMD64IdivNode
extends LLVMExpressionNode {

    @NodeChildren(value={@NodeChild(value="high", type=LLVMExpressionNode.class), @NodeChild(value="left", type=LLVMExpressionNode.class), @NodeChild(value="right", type=LLVMExpressionNode.class)})
    public static abstract class LLVMAMD64IdivqNode
    extends LLVMStatementNode {
        @Node.Child
        private LLVMAMD64WriteTupelNode out;

        public LLVMAMD64IdivqNode(LLVMAMD64WriteTupelNode out) {
            this.out = out;
        }

        @Specialization
        protected void doOp(VirtualFrame frame, long high, long left, long right, @Cached BranchProfile exception) {
            LongDivision.Result result = LongDivision.divs128by64(high, left, right);
            if (result.isInvalid()) {
                exception.enter();
                throw new LLVMAMD64DivNode.QuotientTooLargeException();
            }
            long quotient = result.quotient;
            long remainder = result.remainder;
            this.out.execute(frame, quotient, remainder);
        }
    }

    @NodeChildren(value={@NodeChild(value="high", type=LLVMExpressionNode.class), @NodeChild(value="left", type=LLVMExpressionNode.class), @NodeChild(value="right", type=LLVMExpressionNode.class)})
    public static abstract class LLVMAMD64IdivlNode
    extends LLVMStatementNode {
        @Node.Child
        private LLVMAMD64WriteTupelNode out;

        public LLVMAMD64IdivlNode(LLVMAMD64WriteTupelNode out) {
            this.out = out;
        }

        @Specialization
        protected void doOp(VirtualFrame frame, int high, int left, int right) {
            long value = Integer.toUnsignedLong(high) << 32 | Integer.toUnsignedLong(left);
            int quotient = (int)(value / (long)right);
            int remainder = (int)(value % (long)right);
            this.out.execute(frame, quotient, remainder);
        }
    }

    @NodeChildren(value={@NodeChild(value="high", type=LLVMExpressionNode.class), @NodeChild(value="left", type=LLVMExpressionNode.class), @NodeChild(value="right", type=LLVMExpressionNode.class)})
    public static abstract class LLVMAMD64IdivwNode
    extends LLVMStatementNode {
        @Node.Child
        private LLVMAMD64WriteTupelNode out;

        public LLVMAMD64IdivwNode(LLVMAMD64WriteTupelNode out) {
            this.out = out;
        }

        @Specialization
        protected void doOp(VirtualFrame frame, short high, short left, short right) {
            int value = Short.toUnsignedInt(high) << 16 | Short.toUnsignedInt(left);
            short quotient = (short)(value / right);
            short remainder = (short)(value % right);
            this.out.execute(frame, quotient, remainder);
        }
    }

    @NodeChildren(value={@NodeChild(value="left", type=LLVMExpressionNode.class), @NodeChild(value="right", type=LLVMExpressionNode.class)})
    public static abstract class LLVMAMD64IdivbNode
    extends LLVMExpressionNode {
        @Specialization
        protected short doOp(short left, byte right) {
            byte quotient = (byte)(left / right);
            byte remainder = (byte)(left % right);
            return (short)(quotient & 0xFF | (remainder & 0xFF) << 8);
        }
    }
}

