/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.api;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.interop.NodeLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMDebuggerScopeFactory;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceLocation;
import com.oracle.truffle.llvm.runtime.except.LLVMIllegalSymbolIndexException;
import com.oracle.truffle.llvm.runtime.interop.LLVMDataEscapeNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMFunctionStartNode;
import com.oracle.truffle.llvm.runtime.options.SulongEngineOption;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

@ExportLibrary(value=NodeLibrary.class)
public abstract class LLVMInstrumentableNode
extends LLVMNode
implements InstrumentableNode {
    private LLVMSourceLocation sourceLocation;
    private boolean statement;

    private LLVMInstrumentableNode unwrap() {
        return this instanceof InstrumentableNode.WrapperNode ? (LLVMInstrumentableNode)((InstrumentableNode.WrapperNode)this).getDelegateNode() : this;
    }

    public final LLVMSourceLocation getSourceLocation() {
        return this.unwrap().sourceLocation;
    }

    public final void setSourceLocation(LLVMSourceLocation sourceLocation) {
        this.unwrap().sourceLocation = sourceLocation;
    }

    public final SourceSection getSourceSection() {
        LLVMSourceLocation location = this.getSourceLocation();
        return location == null ? null : location.getSourceSection();
    }

    protected final boolean isStatement() {
        return this.unwrap().statement;
    }

    protected final void setStatement(boolean statementTag) {
        this.unwrap().statement = statementTag;
    }

    public boolean hasStatementTag() {
        return this.isStatement() && this.getSourceLocation() != null;
    }

    public void setHasStatementTag(boolean b) {
        CompilerAsserts.neverPartOfCompilation();
        this.setStatement(b);
    }

    public final boolean isInstrumentable() {
        return this.getSourceLocation() != null;
    }

    public boolean hasTag(Class<? extends Tag> tag) {
        if (tag == StandardTags.StatementTag.class) {
            return this.hasStatementTag();
        }
        return false;
    }

    @ExportMessage
    boolean hasScope(Frame frame) {
        return this.sourceLocation != null;
    }

    @ExportMessage
    public boolean hasRootInstance(Frame frame) {
        return this.getRootNode() instanceof LLVMFunctionStartNode;
    }

    @ExportMessage
    public Object getScope(Frame frame, boolean nodeEnter, @CachedLibrary(value="this") NodeLibrary self) {
        MaterializedFrame materializedFrame;
        LLVMContext ctx = LLVMContext.get((Node)self);
        MaterializedFrame materializedFrame2 = materializedFrame = frame != null ? frame.materialize() : null;
        if (LLVMInstrumentableNode.isLLDebugEnabled(ctx)) {
            return LLVMDebuggerScopeFactory.createIRLevelScope(this, materializedFrame, ctx);
        }
        return LLVMDebuggerScopeFactory.createSourceLevelScope(this, materializedFrame, ctx);
    }

    @CompilerDirectives.TruffleBoundary
    private static boolean isLLDebugEnabled(LLVMContext ctx) {
        return (Boolean)ctx.getEnv().getOptions().get(SulongEngineOption.LL_DEBUG);
    }

    @ExportMessage
    public Object getRootInstance(Frame frame, @CachedLibrary(value="this") NodeLibrary self, @Cached LLVMDataEscapeNode.LLVMPointerDataEscapeNode dataEscapeNode, @Cached BranchProfile exception) throws UnsupportedMessageException {
        if (this.hasRootInstance(frame)) {
            LLVMContext ctx = LLVMContext.get((Node)self);
            try {
                LLVMPointer pointer = ctx.getSymbolResolved(((LLVMFunctionStartNode)this.getRootNode()).getRootFunction(), exception);
                return dataEscapeNode.executeWithTarget(pointer);
            }
            catch (LLVMIllegalSymbolIndexException lLVMIllegalSymbolIndexException) {
                // empty catch block
            }
        }
        exception.enter();
        throw UnsupportedMessageException.create();
    }
}

