/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.memory;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.FrameSlotTypeException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.except.LLVMAllocationFailureException;
import com.oracle.truffle.llvm.runtime.except.LLVMMemoryException;
import com.oracle.truffle.llvm.runtime.except.LLVMStackOverflowError;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemory;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMRootNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

public final class LLVMStack {
    public static final int STACK_ID = 0;
    public static final int UNIQUES_REGION_ID = 1;
    public static final int BASE_POINTER_ID = 2;
    private static final long MAX_ALLOCATION_SIZE = Integer.MAX_VALUE;
    public static final int NO_ALIGNMENT_REQUIREMENTS = 1;
    private final LLVMContext context;
    private final long stackSize;
    private long lowerBounds;
    private long upperBounds;
    private long stackPointer;

    public LLVMStack(long stackSize, LLVMContext context) {
        this.context = context;
        this.stackSize = stackSize;
        this.lowerBounds = 0L;
        this.upperBounds = 0L;
        this.stackPointer = 0L;
    }

    public LLVMContext getContext() {
        return this.context;
    }

    public long getStackPointer() {
        return this.stackPointer;
    }

    public void setStackPointer(long newStackPointer) {
        this.stackPointer = newStackPointer;
    }

    private boolean isAllocated() {
        return this.stackPointer != 0L;
    }

    @CompilerDirectives.TruffleBoundary
    public String toString() {
        if (!this.isAllocated()) {
            return "StackPointer (unallocated)";
        }
        return String.format("StackPointer (0x%x)", this.stackPointer);
    }

    @CompilerDirectives.TruffleBoundary
    private void allocate(Node location, LLVMMemory memory) {
        long stackAllocation;
        this.lowerBounds = stackAllocation = memory.allocateMemory(location, this.stackSize).asNative();
        this.upperBounds = stackAllocation + this.stackSize;
        this.stackPointer = this.upperBounds & 0xFFFFFFFFFFFFFFF8L;
        assert (this.stackPointer != 0L);
    }

    @CompilerDirectives.TruffleBoundary
    public void free(LLVMMemory memory) {
        if (this.isAllocated()) {
            memory.free(null, this.lowerBounds);
            this.lowerBounds = 0L;
            this.upperBounds = 0L;
            this.stackPointer = 0L;
        }
    }

    public static abstract class LLVMGetUniqueStackSpaceInstruction
    extends LLVMExpressionNode {
        private final long slotOffset;

        public LLVMGetUniqueStackSpaceInstruction(long slotOffset) {
            this.slotOffset = slotOffset;
        }

        @Override
        public String toString() {
            return this.getShortString("slotOffset", "uniquesRegionFrameSlot");
        }

        @Specialization
        protected LLVMPointer doOp(VirtualFrame frame) {
            try {
                return LLVMPointer.cast(frame.getObject(1)).increment(this.slotOffset);
            }
            catch (FrameSlotTypeException e) {
                CompilerDirectives.transferToInterpreter();
                throw new LLVMAllocationFailureException((Node)this, e);
            }
        }
    }

    @NodeChild(type=LLVMExpressionNode.class)
    public static abstract class LLVMAllocaInstruction
    extends LLVMGetStackSpaceInstruction {
        public LLVMAllocaInstruction(long size, int alignment) {
            super(size, alignment);
        }

        public abstract LLVMPointer executeWithTarget(VirtualFrame var1, long var2);

        @Specialization
        protected LLVMPointer doOp(VirtualFrame frame, int nr, @Cached(value="createStackAccessHolder()") LLVMStackAccessHolder stackAccessHolder) {
            return this.doOp(frame, (long)nr, stackAccessHolder);
        }

        @Specialization
        protected LLVMPointer doOp(VirtualFrame frame, long nr, @Cached(value="createStackAccessHolder()") LLVMStackAccessHolder stackAccessHolder) {
            return stackAccessHolder.stackAccess.executeAllocate(frame, this.size * nr, this.alignment);
        }
    }

    public static abstract class LLVMAllocaConstInstruction
    extends LLVMGetStackSpaceInstruction {
        public LLVMAllocaConstInstruction(long size, int alignment) {
            super(size, alignment);
        }

        @Specialization
        protected LLVMPointer doOp(VirtualFrame frame, @Cached(value="createStackAccessHolder()") LLVMStackAccessHolder stackAccessHolder) {
            return stackAccessHolder.stackAccess.executeAllocate(frame, this.size, this.alignment);
        }
    }

    public static abstract class LLVMGetStackSpaceInstruction
    extends LLVMExpressionNode {
        protected final long size;
        protected final int alignment;
        @CompilerDirectives.CompilationFinal
        private LLVMStackAccess stackAccess;

        public LLVMGetStackSpaceInstruction(long size, int alignment) {
            this.size = size;
            this.alignment = alignment;
        }

        public void setStackAccess(LLVMStackAccess stackAccess) {
            this.stackAccess = stackAccess;
        }

        protected final LLVMStackAccessHolder createStackAccessHolder() {
            if (this.stackAccess == null) {
                return new LLVMStackAccessHolder(((LLVMRootNode)this.getRootNode()).getStackAccess());
            }
            assert (this.getRootNode() == null);
            return new LLVMStackAccessHolder(this.stackAccess);
        }

        @Override
        public String toString() {
            return this.getShortString("size", "alignment", "stackAccess");
        }
    }

    public static final class LLVMNativeStackAccess
    extends LLVMStackAccess {
        private final LLVMMemory memory;
        private final Assumption noBasePointerAssumption;
        @CompilerDirectives.CompilationFinal
        private boolean hasAllocatedStack;

        public LLVMNativeStackAccess(LLVMMemory memory) {
            this.memory = memory;
            this.noBasePointerAssumption = Truffle.getRuntime().createAssumption("LLVM - no base pointer");
            this.hasAllocatedStack = false;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            this.noBasePointerAssumption.invalidate();
        }

        protected void ensureStackAllocated(LLVMStack llvmStack) {
            if (!llvmStack.isAllocated()) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.hasAllocatedStack = true;
                llvmStack.allocate(this, this.memory);
            }
        }

        protected void ensureBasePointerSlot(LLVMStack llvmStack) {
            this.ensureStackAllocated(llvmStack);
            if (this.noBasePointerAssumption.isValid()) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.noBasePointerAssumption.invalidate();
            }
        }

        @Override
        public void executeEnter(VirtualFrame frame) {
            this.executeEnter(frame, (LLVMStack)frame.getArguments()[0]);
        }

        @Override
        public void executeEnter(VirtualFrame frame, LLVMStack llvmStack) {
            frame.setObject(0, (Object)llvmStack);
            if (this.hasAllocatedStack && !llvmStack.isAllocated()) {
                llvmStack.allocate(this, this.memory);
            }
            if (!this.noBasePointerAssumption.isValid()) {
                this.ensureBasePointerSlot(llvmStack);
                frame.setLong(2, llvmStack.stackPointer);
            }
        }

        @Override
        public void executeExit(VirtualFrame frame) {
            if (!this.noBasePointerAssumption.isValid()) {
                try {
                    LLVMStack llvmStack = (LLVMStack)frame.getObject(0);
                    this.ensureBasePointerSlot(llvmStack);
                    long basePointer = frame.getLong(2);
                    if (basePointer == 0L) {
                        CompilerDirectives.transferToInterpreter();
                    } else {
                        llvmStack.stackPointer = basePointer;
                    }
                }
                catch (FrameSlotTypeException e) {
                    throw new LLVMMemoryException((Node)this, e);
                }
            }
        }

        private LLVMStack getStack(VirtualFrame frame) {
            try {
                LLVMStack llvmStack = (LLVMStack)frame.getObject(0);
                this.ensureStackAllocated(llvmStack);
                return llvmStack;
            }
            catch (FrameSlotTypeException e) {
                throw new LLVMMemoryException((Node)this, e);
            }
        }

        private void initializeBasePointer(VirtualFrame frame, LLVMStack llvmStack) {
            long basePointer;
            this.ensureBasePointerSlot(llvmStack);
            if (frame.isLong(2) && (basePointer = frame.getLong(2)) != 0L) {
                return;
            }
            CompilerDirectives.transferToInterpreter();
            frame.setLong(2, llvmStack.stackPointer);
        }

        @Override
        public LLVMPointer executeGet(VirtualFrame frame) {
            return LLVMNativePointer.create(this.getStack((VirtualFrame)frame).stackPointer);
        }

        @Override
        public void executeSet(VirtualFrame frame, LLVMPointer pointer) {
            LLVMStack llvmStack = this.getStack(frame);
            this.initializeBasePointer(frame, llvmStack);
            if (!LLVMNativePointer.isInstance(pointer)) {
                CompilerDirectives.transferToInterpreter();
                throw new LLVMMemoryException((Node)this, "invalid stack pointer");
            }
            llvmStack.stackPointer = LLVMNativePointer.cast(pointer).asNative();
        }

        @Override
        public LLVMPointer executeAllocate(VirtualFrame frame, long size, int alignment) {
            LLVMStack llvmStack = this.getStack(frame);
            this.initializeBasePointer(frame, llvmStack);
            long stackPointer = llvmStack.stackPointer;
            assert (stackPointer != 0L);
            long alignedAllocation = LLVMNativeStackAccess.getAlignedAllocation(stackPointer, size, Math.max(alignment, 8));
            assert ((alignedAllocation & 7L) == 0L) : "misaligned stack";
            llvmStack.stackPointer = alignedAllocation;
            return LLVMNativePointer.create(alignedAllocation);
        }

        private static long getAlignedAllocation(long address, long size, int alignment) {
            if (Long.compareUnsigned(size, Integer.MAX_VALUE) > 0) {
                CompilerDirectives.transferToInterpreter();
                throw new LLVMStackOverflowError(String.format("Stack allocation of %s bytes exceeds limit of %s", Long.toUnsignedString(size), Long.toUnsignedString(Integer.MAX_VALUE)));
            }
            assert (alignment >= 8 && LLVMNativeStackAccess.powerOfTwo(alignment));
            long alignedAllocation = address - size & (long)(-alignment);
            assert (alignedAllocation <= address);
            return alignedAllocation;
        }

        private static boolean powerOfTwo(int value) {
            return (value & -value) == value;
        }

        @Override
        public LLVMStack executeGetStack(VirtualFrame frame) {
            try {
                return (LLVMStack)frame.getObject(0);
            }
            catch (FrameSlotTypeException e) {
                throw new LLVMMemoryException((Node)this, e);
            }
        }
    }

    public static final class LLVMStackAccessHolder {
        public final LLVMStackAccess stackAccess;

        public LLVMStackAccessHolder(LLVMStackAccess stackAccess) {
            this.stackAccess = stackAccess;
        }
    }

    public static abstract class LLVMStackAccess
    extends Node
    implements GenerateAOT.Provider {
        public abstract void executeEnter(VirtualFrame var1);

        public abstract void executeEnter(VirtualFrame var1, LLVMStack var2);

        public abstract void executeExit(VirtualFrame var1);

        public abstract LLVMPointer executeGet(VirtualFrame var1);

        public abstract void executeSet(VirtualFrame var1, LLVMPointer var2);

        public abstract LLVMPointer executeAllocate(VirtualFrame var1, long var2, int var4);

        public abstract LLVMStack executeGetStack(VirtualFrame var1);
    }

    public static final class UniquesRegion {
        private long currentSlotOffset = 0L;
        private int alignment = 8;
        private boolean finished;

        public long addSlot(long slotSize, int slotAlignment) {
            CompilerAsserts.neverPartOfCompilation();
            assert (!this.finished) : "cannot add slots after size was queried";
            assert (Long.bitCount(slotAlignment) == 1) : "alignment must be a power of two";
            long slotOffset = this.currentSlotOffset + (long)slotAlignment - 1L & (long)(-slotAlignment);
            this.currentSlotOffset = slotOffset + slotSize;
            this.alignment = Integer.highestOneBit(this.alignment | slotAlignment);
            return slotOffset;
        }

        public long getSize() {
            this.finished = true;
            return this.currentSlotOffset;
        }

        public boolean isEmpty() {
            return this.getSize() == 0L;
        }

        public int getAlignment() {
            this.finished = true;
            return this.alignment;
        }
    }
}

