/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.library.internal;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMNativeLibrary;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMNativeLibraryDefaults;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import java.lang.invoke.VarHandle;

@GeneratedBy(value=LLVMNativeLibraryDefaults.DefaultLibrary.class)
final class DefaultLibraryGen {
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    private DefaultLibraryGen() {
    }

    static {
        LibraryExport.register(LLVMNativeLibraryDefaults.DefaultLibrary.class, (LibraryExport[])new LibraryExport[]{new LLVMNativeLibraryExports()});
    }

    @GeneratedBy(value=LLVMNativeLibraryDefaults.DefaultLibrary.class)
    private static final class LLVMNativeLibraryExports
    extends LibraryExport<LLVMNativeLibrary> {
        private LLVMNativeLibraryExports() {
            super(LLVMNativeLibrary.class, Object.class, true, false, 0);
        }

        protected LLVMNativeLibrary createUncached(Object receiver) {
            Uncached uncached = new Uncached(receiver);
            return uncached;
        }

        protected LLVMNativeLibrary createCached(Object receiver) {
            return new Cached(receiver);
        }

        @GeneratedBy(value=LLVMNativeLibraryDefaults.DefaultLibrary.class)
        @DenyReplace
        private static final class Uncached
        extends LLVMNativeLibrary
        implements UnadoptableNode {
            @Node.Child
            private DynamicDispatchLibrary dynamicDispatch_;
            private final Class<?> dynamicDispatchTarget_;

            protected Uncached(Object receiver) {
                this.dynamicDispatch_ = (DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver);
                this.dynamicDispatchTarget_ = this.dynamicDispatch_.dispatch(receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                return this.dynamicDispatch_.accepts(receiver) && this.dynamicDispatch_.dispatch(receiver) == this.dynamicDispatchTarget_;
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isPointer(Object arg0Value) {
                assert (this.accepts(arg0Value)) : "Invalid library usage. Library does not accept given receiver.";
                if (((InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value)).isPointer(arg0Value)) {
                    return LLVMNativeLibraryDefaults.DefaultLibrary.IsPointer.doPointer(arg0Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value));
                }
                if (!((InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value)).isPointer(arg0Value)) {
                    return LLVMNativeLibraryDefaults.DefaultLibrary.IsPointer.doOther(arg0Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value));
                }
                throw Uncached.newUnsupportedSpecializationException1((Node)this, arg0Value);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long asPointer(Object arg0Value) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value)) : "Invalid library usage. Library does not accept given receiver.";
                if (((InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value)).isPointer(arg0Value)) {
                    return LLVMNativeLibraryDefaults.DefaultLibrary.AsPointer.doPointer(arg0Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value), BranchProfile.getUncached());
                }
                if (!((InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value)).isPointer(arg0Value)) {
                    return LLVMNativeLibraryDefaults.DefaultLibrary.AsPointer.doNullCheck(arg0Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value), BranchProfile.getUncached());
                }
                throw Uncached.newUnsupportedSpecializationException1((Node)this, arg0Value);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public LLVMNativePointer toNativePointer(Object arg0Value) {
                assert (this.accepts(arg0Value)) : "Invalid library usage. Library does not accept given receiver.";
                if (((InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value)).isNull(arg0Value)) {
                    return LLVMNativeLibraryDefaults.DefaultLibrary.ToNativePointer.doNull(arg0Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value));
                }
                if (!((InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value)).isNull(arg0Value) && ((InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value)).isPointer(arg0Value)) {
                    try {
                        return LLVMNativeLibraryDefaults.DefaultLibrary.ToNativePointer.doAlreadyNative(arg0Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value));
                    }
                    catch (UnsupportedMessageException unsupportedMessageException) {
                        // empty catch block
                    }
                }
                if (!((InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value)).isNull(arg0Value)) {
                    return LLVMNativeLibraryDefaults.DefaultLibrary.ToNativePointer.doNotNull(arg0Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value), BranchProfile.getUncached());
                }
                throw Uncached.newUnsupportedSpecializationException1((Node)this, arg0Value);
            }

            @CompilerDirectives.TruffleBoundary
            private static UnsupportedSpecializationException newUnsupportedSpecializationException1(Node thisNode_, Object arg0Value) {
                return new UnsupportedSpecializationException(thisNode_, null, new Object[]{arg0Value});
            }
        }

        @GeneratedBy(value=LLVMNativeLibraryDefaults.DefaultLibrary.class)
        private static final class Cached
        extends LLVMNativeLibrary {
            @Node.Child
            private InteropLibrary receiverInteropLibrary_;
            @Node.Child
            private DynamicDispatchLibrary dynamicDispatch_;
            private final Class<?> dynamicDispatchTarget_;
            @CompilerDirectives.CompilationFinal
            private int state_0_;
            @CompilerDirectives.CompilationFinal
            private BranchProfile exception;

            protected Cached(Object receiver) {
                this.receiverInteropLibrary_ = (InteropLibrary)INTEROP_LIBRARY_.create(receiver);
                this.dynamicDispatch_ = (DynamicDispatchLibrary)this.insert((Node)((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.create(receiver)));
                this.dynamicDispatchTarget_ = ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver)).dispatch(receiver);
            }

            public boolean accepts(Object receiver) {
                if (!this.dynamicDispatch_.accepts(receiver) || this.dynamicDispatch_.dispatch(receiver) != this.dynamicDispatchTarget_) {
                    return false;
                }
                return this.receiverInteropLibrary_.accepts(receiver);
            }

            @Override
            public boolean isPointer(Object arg0Value) {
                assert (this.dynamicDispatch_.accepts(arg0Value) && this.dynamicDispatch_.dispatch(arg0Value) == this.dynamicDispatchTarget_) : "Invalid library usage. Library does not accept given receiver.";
                assert (LLVMNativeLibraryExports.assertAdopted((Node)((Node)this)));
                int state_0 = this.state_0_;
                if ((state_0 & 3) != 0) {
                    InteropLibrary interop__1;
                    InteropLibrary interop__;
                    if ((state_0 & 1) != 0 && (interop__ = this.receiverInteropLibrary_).isPointer(arg0Value)) {
                        return LLVMNativeLibraryDefaults.DefaultLibrary.IsPointer.doPointer(arg0Value, interop__);
                    }
                    if ((state_0 & 2) != 0 && !(interop__1 = this.receiverInteropLibrary_).isPointer(arg0Value)) {
                        return LLVMNativeLibraryDefaults.DefaultLibrary.IsPointer.doOther(arg0Value, interop__1);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isPointerAndSpecialize(arg0Value);
            }

            private boolean isPointerAndSpecialize(Object arg0Value) {
                int state_0 = this.state_0_;
                InteropLibrary interop__ = null;
                interop__ = this.receiverInteropLibrary_;
                if (interop__.isPointer(arg0Value)) {
                    this.state_0_ = state_0 |= 1;
                    return LLVMNativeLibraryDefaults.DefaultLibrary.IsPointer.doPointer(arg0Value, interop__);
                }
                InteropLibrary interop__1 = null;
                interop__1 = this.receiverInteropLibrary_;
                if (!interop__1.isPointer(arg0Value)) {
                    this.state_0_ = state_0 |= 2;
                    return LLVMNativeLibraryDefaults.DefaultLibrary.IsPointer.doOther(arg0Value, interop__1);
                }
                throw new UnsupportedSpecializationException((Node)this, null, new Object[]{arg0Value});
            }

            @Override
            public long asPointer(Object arg0Value) throws UnsupportedMessageException {
                assert (this.dynamicDispatch_.accepts(arg0Value) && this.dynamicDispatch_.dispatch(arg0Value) == this.dynamicDispatchTarget_) : "Invalid library usage. Library does not accept given receiver.";
                assert (LLVMNativeLibraryExports.assertAdopted((Node)((Node)this)));
                int state_0 = this.state_0_;
                if ((state_0 & 0xC) != 0) {
                    InteropLibrary interop__1;
                    BranchProfile exception_1;
                    InteropLibrary interop__;
                    BranchProfile exception_;
                    if ((state_0 & 4) != 0 && (exception_ = this.exception) != null && (interop__ = this.receiverInteropLibrary_).isPointer(arg0Value)) {
                        return LLVMNativeLibraryDefaults.DefaultLibrary.AsPointer.doPointer(arg0Value, interop__, exception_);
                    }
                    if ((state_0 & 8) != 0 && (exception_1 = this.exception) != null && !(interop__1 = this.receiverInteropLibrary_).isPointer(arg0Value)) {
                        return LLVMNativeLibraryDefaults.DefaultLibrary.AsPointer.doNullCheck(arg0Value, interop__1, exception_1);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.asPointerAndSpecialize(arg0Value);
            }

            private long asPointerAndSpecialize(Object arg0Value) throws UnsupportedMessageException {
                int state_0 = this.state_0_;
                InteropLibrary interop__ = null;
                interop__ = this.receiverInteropLibrary_;
                if (interop__.isPointer(arg0Value)) {
                    BranchProfile exception_;
                    BranchProfile exception__shared = this.exception;
                    if (exception__shared != null) {
                        exception_ = exception__shared;
                    } else {
                        exception_ = BranchProfile.create();
                        if (exception_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.exception == null) {
                        VarHandle.storeStoreFence();
                        this.exception = exception_;
                    }
                    this.state_0_ = state_0 |= 4;
                    return LLVMNativeLibraryDefaults.DefaultLibrary.AsPointer.doPointer(arg0Value, interop__, exception_);
                }
                InteropLibrary interop__1 = null;
                interop__1 = this.receiverInteropLibrary_;
                if (!interop__1.isPointer(arg0Value)) {
                    BranchProfile exception_1;
                    BranchProfile exception_1_shared = this.exception;
                    if (exception_1_shared != null) {
                        exception_1 = exception_1_shared;
                    } else {
                        exception_1 = BranchProfile.create();
                        if (exception_1 == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.exception == null) {
                        VarHandle.storeStoreFence();
                        this.exception = exception_1;
                    }
                    this.state_0_ = state_0 |= 8;
                    return LLVMNativeLibraryDefaults.DefaultLibrary.AsPointer.doNullCheck(arg0Value, interop__1, exception_1);
                }
                throw new UnsupportedSpecializationException((Node)this, null, new Object[]{arg0Value});
            }

            @Override
            public LLVMNativePointer toNativePointer(Object arg0Value) {
                assert (this.dynamicDispatch_.accepts(arg0Value) && this.dynamicDispatch_.dispatch(arg0Value) == this.dynamicDispatchTarget_) : "Invalid library usage. Library does not accept given receiver.";
                assert (LLVMNativeLibraryExports.assertAdopted((Node)((Node)this)));
                int state_0 = this.state_0_;
                if ((state_0 & 0xB0) != 0) {
                    InteropLibrary interop__2;
                    BranchProfile exception_;
                    InteropLibrary interop__1;
                    InteropLibrary interop__;
                    if ((state_0 & 0x10) != 0 && (interop__ = this.receiverInteropLibrary_).isNull(arg0Value)) {
                        return LLVMNativeLibraryDefaults.DefaultLibrary.ToNativePointer.doNull(arg0Value, interop__);
                    }
                    if ((state_0 & 0x20) != 0 && !(interop__1 = this.receiverInteropLibrary_).isNull(arg0Value) && interop__1.isPointer(arg0Value)) {
                        try {
                            return LLVMNativeLibraryDefaults.DefaultLibrary.ToNativePointer.doAlreadyNative(arg0Value, interop__1);
                        }
                        catch (UnsupportedMessageException ex) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            state_0 = this.state_0_;
                            state_0 &= 0xFFFFFFDF;
                            this.state_0_ = state_0 |= 0x40;
                            return this.toNativePointerAndSpecialize(arg0Value);
                        }
                    }
                    if ((state_0 & 0x80) != 0 && (exception_ = this.exception) != null && !(interop__2 = this.receiverInteropLibrary_).isNull(arg0Value)) {
                        return LLVMNativeLibraryDefaults.DefaultLibrary.ToNativePointer.doNotNull(arg0Value, interop__2, exception_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.toNativePointerAndSpecialize(arg0Value);
            }

            private LLVMNativePointer toNativePointerAndSpecialize(Object arg0Value) {
                int state_0 = this.state_0_;
                InteropLibrary interop__ = null;
                interop__ = this.receiverInteropLibrary_;
                if (interop__.isNull(arg0Value)) {
                    this.state_0_ = state_0 |= 0x10;
                    return LLVMNativeLibraryDefaults.DefaultLibrary.ToNativePointer.doNull(arg0Value, interop__);
                }
                InteropLibrary interop__1 = null;
                if ((state_0 & 0x80) == 0 && (state_0 & 0x40) == 0 && !(interop__1 = this.receiverInteropLibrary_).isNull(arg0Value) && interop__1.isPointer(arg0Value)) {
                    this.state_0_ = state_0 |= 0x20;
                    try {
                        return LLVMNativeLibraryDefaults.DefaultLibrary.ToNativePointer.doAlreadyNative(arg0Value, interop__1);
                    }
                    catch (UnsupportedMessageException ex) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        state_0 = this.state_0_;
                        state_0 &= 0xFFFFFFDF;
                        this.state_0_ = state_0 |= 0x40;
                        return this.toNativePointerAndSpecialize(arg0Value);
                    }
                }
                InteropLibrary interop__2 = null;
                interop__2 = this.receiverInteropLibrary_;
                if (!interop__2.isNull(arg0Value)) {
                    BranchProfile exception_;
                    BranchProfile exception__shared = this.exception;
                    if (exception__shared != null) {
                        exception_ = exception__shared;
                    } else {
                        exception_ = BranchProfile.create();
                        if (exception_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.exception == null) {
                        VarHandle.storeStoreFence();
                        this.exception = exception_;
                    }
                    state_0 &= 0xFFFFFFDF;
                    this.state_0_ = state_0 |= 0x80;
                    return LLVMNativeLibraryDefaults.DefaultLibrary.ToNativePointer.doNotNull(arg0Value, interop__2, exception_);
                }
                throw new UnsupportedSpecializationException((Node)this, null, new Object[]{arg0Value});
            }
        }
    }
}

