/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.interop.export;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.llvm.runtime.CommonNodeFactory;
import com.oracle.truffle.llvm.runtime.interop.LLVMDataEscapeNode;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMOffsetLoadNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

@GenerateUncached
@ImportStatic(value={CommonNodeFactory.class})
public abstract class LLVMForeignReadNode
extends LLVMNode {
    static final int VALUE_KIND_COUNT = LLVMInteropType.ValueKind.values().length;

    public abstract Object execute(LLVMPointer var1, LLVMInteropType var2);

    @Specialization
    static Object doStructured(LLVMPointer ptr, LLVMInteropType.Structured type) {
        return ptr;
    }

    @Specialization(guards={"type.kind == cachedKind"}, limit="VALUE_KIND_COUNT")
    @GenerateAOT.Exclude
    static Object doValue(LLVMPointer ptr, LLVMInteropType.Value type, @Cached(value="type.kind", allowUncached=true) LLVMInteropType.ValueKind cachedKind, @Cached(parameters={"cachedKind"}) LLVMOffsetLoadNode load, @Cached(parameters={"cachedKind.foreignToLLVMType"}) LLVMDataEscapeNode dataEscape) {
        Object ret = load.executeWithTargetGeneric(ptr, 0L);
        return dataEscape.executeWithType(ret, type.baseType);
    }
}

