/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.interop.access;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropMethodInvokeNodeGen;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropNonvirtualCallNode;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropVtableAccessNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

@GenerateUncached
public abstract class LLVMInteropMethodInvokeNode
extends LLVMNode {
    abstract Object execute(LLVMPointer var1, String var2, LLVMInteropType.Clazz var3, LLVMInteropType.Method var4, long var5, Object[] var7) throws UnsupportedTypeException, ArityException, UnsupportedMessageException, UnknownIdentifierException;

    public static LLVMInteropMethodInvokeNode create() {
        return LLVMInteropMethodInvokeNodeGen.create();
    }

    static boolean isVirtual(long virtualIndex) {
        return virtualIndex >= 0L;
    }

    @ExplodeLoop
    @Specialization(guards={"isVirtual(virtualIndex)", "type==typeHash"})
    @GenerateAOT.Exclude
    Object doVirtualCallCached(LLVMPointer receiver, String methodName, LLVMInteropType.Clazz type, LLVMInteropType.Method method, long virtualIndex, Object[] arguments, @CachedLibrary(limit="5") InteropLibrary interop, @Cached(value="type") LLVMInteropType.Clazz typeHash, @Cached(value="type.getVtableAccessNames()", allowUncached=true, dimensions=1) String[] vtableHelpNames, @Cached LLVMInteropVtableAccessNode vtableAccessNode) throws UnsupportedTypeException, ArityException, UnsupportedMessageException, UnknownIdentifierException {
        Object curReceiver = receiver;
        for (String name : vtableHelpNames) {
            curReceiver = interop.readMember(curReceiver, name);
        }
        return vtableAccessNode.execute(curReceiver, virtualIndex, arguments);
    }

    @ExplodeLoop
    @Specialization(guards={"isVirtual(virtualIndex)"}, replaces={"doVirtualCallCached"})
    @GenerateAOT.Exclude
    Object doVirtualCall(LLVMPointer receiver, String methodName, LLVMInteropType.Clazz type, LLVMInteropType.Method method, long virtualIndex, Object[] arguments, @CachedLibrary(limit="5") InteropLibrary interop, @Cached LLVMInteropVtableAccessNode vtableAccessNode) throws UnsupportedTypeException, ArityException, UnsupportedMessageException, UnknownIdentifierException {
        String[] vtableAccessNames = type.getVtableAccessNames();
        Object curReceiver = receiver;
        for (String name : vtableAccessNames) {
            curReceiver = interop.readMember(curReceiver, name);
        }
        return vtableAccessNode.execute(curReceiver, virtualIndex, arguments);
    }

    @Specialization(guards={"!isVirtual(virtualIndex)"})
    Object doNonvirtualCall(LLVMPointer receiver, String methodName, LLVMInteropType.Clazz type, LLVMInteropType.Method method, long virtualIndex, Object[] arguments, @Cached LLVMInteropNonvirtualCallNode call) throws UnsupportedMessageException, UnsupportedTypeException, ArityException {
        return call.execute(receiver, type, methodName, method, arguments);
    }
}

