/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.scanner;

import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.llvm.parser.listeners.BCFileRoot;
import com.oracle.truffle.llvm.parser.listeners.ParserListener;
import com.oracle.truffle.llvm.parser.model.ModelModule;
import com.oracle.truffle.llvm.parser.scanner.AbbreviatedRecord;
import com.oracle.truffle.llvm.parser.scanner.BitStream;
import com.oracle.truffle.llvm.parser.scanner.Block;
import com.oracle.truffle.llvm.parser.scanner.Primitive;
import com.oracle.truffle.llvm.parser.scanner.RecordBuffer;
import com.oracle.truffle.llvm.parser.scanner.ScannerState;
import com.oracle.truffle.llvm.runtime.Magic;
import com.oracle.truffle.llvm.runtime.except.LLVMParserException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.graalvm.polyglot.io.ByteSequence;

public class LLVMScanner {
    private static final String CHAR6 = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789._";
    private static final int DEFAULT_ID_SIZE = 2;
    private static final int MAX_BLOCK_DEPTH = 3;
    private final BitStream bitstream;
    private ParserListener parser;
    private final Map<Block, List<AbbreviatedRecord[]>> defaultAbbreviations;
    private final List<AbbreviatedRecord[]> abbreviationDefinitions = new ArrayList<AbbreviatedRecord[]>();
    private final Deque<ScannerState> parents = new ArrayDeque<ScannerState>(3);
    private final RecordBuffer recordBuffer = new RecordBuffer();
    private Block block;
    private int idSize;
    protected long offset;
    protected long oldOffset;

    private LLVMScanner(BitStream bitstream, ParserListener listener) {
        this.bitstream = bitstream;
        this.parser = listener;
        this.block = Block.ROOT;
        this.idSize = 2;
        this.offset = 0L;
        this.defaultAbbreviations = new HashMap<Block, List<AbbreviatedRecord[]>>();
    }

    public LLVMScanner(BitStream bitstream, ParserListener parser, Map<Block, List<AbbreviatedRecord[]>> defaultAbbreviations, Block block, int idSize, long offset) {
        assert (idSize > 0);
        this.bitstream = bitstream;
        this.defaultAbbreviations = defaultAbbreviations;
        this.block = block;
        this.idSize = idSize;
        this.parser = parser;
        this.offset = offset;
    }

    public static void parseBitcode(ByteSequence bitcode, ModelModule model, Source bcSource) {
        BCFileRoot fileParser;
        BitStream bitstream = BitStream.create(bitcode);
        LLVMScanner scanner = new LLVMScanner(bitstream, fileParser = new BCFileRoot(model, bcSource));
        long actualMagicWord = scanner.read(32);
        if (actualMagicWord != Magic.BC_MAGIC_WORD.magic) {
            throw new LLVMParserException("Not a valid Bitcode File!");
        }
        scanner.scanToEnd();
        fileParser.exit();
    }

    private static <V> List<V> subList(List<V> original, int from) {
        ArrayList<V> newList = new ArrayList<V>(original.size() - from);
        for (int i = from; i < original.size(); ++i) {
            newList.add(original.get(i));
        }
        return newList;
    }

    protected long read(int bits) {
        assert (bits >= 0);
        long value = this.bitstream.read(this.offset, bits);
        this.offset += (long)bits;
        return value;
    }

    private long read(Primitive primitive) {
        if (primitive.isFixed()) {
            return this.read(primitive.getBits());
        }
        return this.readVBR(primitive.getBits());
    }

    private long readChar() {
        long value = this.read(Primitive.CHAR6);
        return CHAR6.charAt((int)value);
    }

    private long readVBR(int width) {
        assert (width > 0);
        long value = this.bitstream.readVBR(this.offset, width);
        this.offset += BitStream.widthVBR(value, width);
        return value;
    }

    protected void scanToEnd() {
        this.scanToOffset(this.bitstream.size());
    }

    protected boolean scan() {
        this.oldOffset = this.offset;
        int id = (int)this.read(this.idSize);
        switch (id) {
            case 0: {
                return this.onEndBlock();
            }
            case 1: {
                this.onEnterSubBlock();
                break;
            }
            case 2: {
                this.defineAbbreviation();
                break;
            }
            case 3: {
                this.onUnabbreviatedRecord();
                break;
            }
            default: {
                this.onAbbreviatedRecord(id);
            }
        }
        return false;
    }

    private void scanToOffset(long to) {
        while (this.offset < to) {
            if (!this.scan()) continue;
            return;
        }
    }

    private void onAbbreviatedRecord(int recordId) {
        AbbreviatedRecord[] records;
        for (AbbreviatedRecord record : records = this.abbreviationDefinitions.get(recordId - 4)) {
            if (record == null) continue;
            record.scan(this);
        }
        this.unabbreviatedRecord(this.recordBuffer);
        this.recordBuffer.invalidate();
    }

    protected void alignInt() {
        long mask = 31L;
        if ((this.offset & mask) != 0L) {
            this.offset = (this.offset & (mask ^ 0xFFFFFFFFFFFFFFFFL)) + 32L;
        }
    }

    private void defineAbbreviation() {
        long operandCount = this.read(Primitive.ABBREVIATED_RECORD_OPERANDS);
        if (operandCount < 0L || operandCount != (long)((int)operandCount)) {
            throw new LLVMParserException("Invalid operand count!");
        }
        AbbreviatedRecord[] operandScanners = new AbbreviatedRecord[(int)operandCount];
        boolean containsArrayOperand = false;
        int i = 0;
        while ((long)i < operandCount) {
            boolean isLiteral;
            boolean bl = isLiteral = this.read(Primitive.USER_OPERAND_LITERALBIT) == 1L;
            if (isLiteral) {
                long fixedValue = this.read(Primitive.USER_OPERAND_LITERAL);
                operandScanners[i] = new ConstantAbbreviatedRecord(fixedValue);
            } else {
                long recordType = this.read(Primitive.USER_OPERAND_TYPE);
                switch ((int)recordType) {
                    case 1: {
                        long width = this.read(Primitive.USER_OPERAND_DATA);
                        if (width < 0L || width != (long)((int)width)) {
                            throw new LLVMParserException("invalid bitcode: overflow or negative size");
                        }
                        operandScanners[i] = new FixedAbbreviatedRecord((int)width);
                        break;
                    }
                    case 2: {
                        long width = this.read(Primitive.USER_OPERAND_DATA);
                        if (width <= 0L || width != (long)((int)width)) {
                            throw new LLVMParserException("invalid bitcode: overflow or negative size");
                        }
                        operandScanners[i] = new VBRAbbreviatedRecord((int)width);
                        break;
                    }
                    case 3: {
                        containsArrayOperand = true;
                        break;
                    }
                    case 4: {
                        operandScanners[i] = Char6AbbreviatedRecord.INSTANCE;
                        break;
                    }
                    case 5: {
                        operandScanners[i] = BlobAbbreviatedRecord.INSTANCE;
                        break;
                    }
                    default: {
                        throw new LLVMParserException("Unknown ID in for record abbreviation: " + recordType);
                    }
                }
            }
            ++i;
        }
        if (containsArrayOperand) {
            AbbreviatedRecord elementScanner = operandScanners[operandScanners.length - 1];
            ArrayAbbreviatedRecord arrayScanner = new ArrayAbbreviatedRecord(elementScanner);
            operandScanners[operandScanners.length - 1] = arrayScanner;
        }
        this.abbreviationDefinitions.add(operandScanners);
    }

    protected void enterSubBlock(long blockId, int newIdSize, long numWords) {
        assert (numWords > 0L);
        assert (newIdSize > 0);
        long endingOffset = this.offset + numWords * 32L;
        if (endingOffset < this.offset) {
            throw new LLVMParserException("invalid bitcode: overflow or negative size");
        }
        Block subBlock = Block.lookup(blockId);
        if (subBlock == null || subBlock.skip()) {
            this.offset = endingOffset;
        } else if (subBlock.parseLazily()) {
            LazyScanner lazyScanner = new LazyScanner(this.bitstream, new HashMap<Block, List<AbbreviatedRecord[]>>(this.defaultAbbreviations), this.offset, endingOffset, newIdSize, subBlock);
            this.offset = endingOffset;
            this.parser.skip(subBlock, lazyScanner);
        } else {
            int localAbbreviationDefinitionsOffset = this.defaultAbbreviations.getOrDefault((Object)this.block, Collections.emptyList()).size();
            this.parents.push(new ScannerState(LLVMScanner.subList(this.abbreviationDefinitions, localAbbreviationDefinitionsOffset), this.block, this.idSize, this.parser));
            this.parser = this.parser.enter(subBlock);
            this.startSubBlock(subBlock, newIdSize);
        }
    }

    private void onEnterSubBlock() {
        long blockId = this.read(Primitive.SUBBLOCK_ID);
        long newIdSize = this.read(Primitive.SUBBLOCK_ID_SIZE);
        this.alignInt();
        long numWords = this.read(32);
        if (numWords <= 0L || newIdSize <= 0L || newIdSize != (long)((int)newIdSize)) {
            throw new LLVMParserException("invalid bitcode: overflow or negative size");
        }
        this.enterSubBlock(blockId, (int)newIdSize, numWords);
    }

    private void startSubBlock(Block subBlock, int newIdSize) {
        this.abbreviationDefinitions.clear();
        this.abbreviationDefinitions.addAll(this.defaultAbbreviations.getOrDefault((Object)subBlock, Collections.emptyList()));
        this.block = subBlock;
        assert (newIdSize > 0);
        this.idSize = newIdSize;
        if (this.block == Block.BLOCKINFO) {
            final ParserListener parentListener = this.parser;
            this.parser = new ParserListener(){
                int currentBlockId = -1;
                final /* synthetic */ LLVMScanner this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public ParserListener enter(Block newBlock) {
                    return parentListener.enter(newBlock);
                }

                @Override
                public void exit() {
                    this.setDefaultAbbreviations();
                    parentListener.exit();
                }

                @Override
                public void record(RecordBuffer buffer) {
                    if (buffer.getId() == 1) {
                        this.setDefaultAbbreviations();
                        this.currentBlockId = (int)buffer.getAt(0);
                    }
                    parentListener.record(buffer);
                }

                private void setDefaultAbbreviations() {
                    if (this.currentBlockId >= 0) {
                        Block currentBlock = Block.lookup(this.currentBlockId);
                        this.this$0.defaultAbbreviations.putIfAbsent(currentBlock, new ArrayList());
                        this.this$0.defaultAbbreviations.get((Object)currentBlock).addAll(this.this$0.abbreviationDefinitions);
                        this.this$0.abbreviationDefinitions.clear();
                    }
                }
            };
        }
    }

    protected boolean exitBlock() {
        this.parser.exit();
        if (this.parents.isEmpty()) {
            return false;
        }
        ScannerState parentState = this.parents.pop();
        this.block = parentState.getBlock();
        this.abbreviationDefinitions.clear();
        this.abbreviationDefinitions.addAll(this.defaultAbbreviations.getOrDefault((Object)this.block, Collections.emptyList()));
        this.abbreviationDefinitions.addAll(parentState.getAbbreviatedRecords());
        this.idSize = parentState.getIdSize();
        this.parser = parentState.getParser();
        return false;
    }

    private boolean onEndBlock() {
        this.alignInt();
        return this.exitBlock();
    }

    protected void unabbreviatedRecord(RecordBuffer buffer) {
        this.parser.record(buffer);
    }

    private void onUnabbreviatedRecord() {
        long recordId = this.read(Primitive.UNABBREVIATED_RECORD_ID);
        this.recordBuffer.addOp(recordId);
        long opCount = this.read(Primitive.UNABBREVIATED_RECORD_OPS);
        this.recordBuffer.ensureFits(opCount);
        int i = 0;
        while ((long)i < opCount) {
            long op = this.read(Primitive.UNABBREVIATED_RECORD_OPERAND);
            this.recordBuffer.addOpNoCheck(op);
            ++i;
        }
        this.unabbreviatedRecord(this.recordBuffer);
        this.recordBuffer.invalidate();
    }

    private static final class ConstantAbbreviatedRecord
    implements AbbreviatedRecord {
        private final long value;

        ConstantAbbreviatedRecord(long value) {
            this.value = value;
        }

        @Override
        public void scan(LLVMScanner scanner) {
            scanner.recordBuffer.addOp(this.value);
        }
    }

    private static final class FixedAbbreviatedRecord
    implements AbbreviatedRecord {
        private final int width;

        FixedAbbreviatedRecord(int width) {
            assert (width >= 0);
            this.width = width;
        }

        @Override
        public void scan(LLVMScanner scanner) {
            scanner.recordBuffer.addOp(scanner.read(this.width));
        }
    }

    private static final class VBRAbbreviatedRecord
    implements AbbreviatedRecord {
        private final int width;

        VBRAbbreviatedRecord(int width) {
            assert (width > 0);
            this.width = width;
        }

        @Override
        public void scan(LLVMScanner scanner) {
            scanner.recordBuffer.addOp(scanner.readVBR(this.width));
        }
    }

    private static final class Char6AbbreviatedRecord
    implements AbbreviatedRecord {
        private static final Char6AbbreviatedRecord INSTANCE = new Char6AbbreviatedRecord();

        private Char6AbbreviatedRecord() {
        }

        @Override
        public void scan(LLVMScanner scanner) {
            scanner.recordBuffer.addOp(scanner.readChar());
        }
    }

    private static final class BlobAbbreviatedRecord
    implements AbbreviatedRecord {
        private static final BlobAbbreviatedRecord INSTANCE = new BlobAbbreviatedRecord();
        private static final long MAX_BLOB_PART_LENGTH = 64 / Primitive.USER_OPERAND_LITERAL.getBits();

        private BlobAbbreviatedRecord() {
        }

        @Override
        public void scan(LLVMScanner scanner) {
            long l;
            long blobLength;
            scanner.alignInt();
            scanner.recordBuffer.ensureFits(blobLength / MAX_BLOB_PART_LENGTH);
            for (blobLength = scanner.read(Primitive.USER_OPERAND_BLOB_LENGTH); blobLength > 0L; blobLength -= l) {
                l = Long.compareUnsigned(blobLength, MAX_BLOB_PART_LENGTH) <= 0 ? blobLength : MAX_BLOB_PART_LENGTH;
                long blobValue = scanner.read((int)((long)Primitive.USER_OPERAND_LITERAL.getBits() * l));
                scanner.recordBuffer.addOp(blobValue);
            }
            scanner.alignInt();
        }
    }

    private static final class ArrayAbbreviatedRecord
    implements AbbreviatedRecord {
        private final AbbreviatedRecord elementScanner;

        ArrayAbbreviatedRecord(AbbreviatedRecord elementScanner) {
            this.elementScanner = elementScanner;
        }

        @Override
        public void scan(LLVMScanner scanner) {
            long arrayLength = scanner.read(Primitive.USER_OPERAND_ARRAY_LENGTH);
            scanner.recordBuffer.ensureFits(arrayLength);
            int j = 0;
            while ((long)j < arrayLength) {
                this.elementScanner.scan(scanner);
                ++j;
            }
        }
    }

    public static final class LazyScanner {
        private final BitStream bitstream;
        private final Map<Block, List<AbbreviatedRecord[]>> oldDefaultAbbreviations;
        private final long startingOffset;
        private final long endingOffset;
        private final int startingIdSize;
        private final Block startingBlock;

        private LazyScanner(BitStream bitstream, Map<Block, List<AbbreviatedRecord[]>> oldDefaultAbbreviations, long startingOffset, long endingOffset, int startingIdSize, Block startingBlock) {
            assert (startingIdSize > 0);
            this.bitstream = bitstream;
            this.oldDefaultAbbreviations = oldDefaultAbbreviations;
            this.startingOffset = startingOffset;
            this.endingOffset = endingOffset;
            this.startingIdSize = startingIdSize;
            this.startingBlock = startingBlock;
        }

        public void scanBlock(ParserListener parser) {
            LLVMScanner scanner = new LLVMScanner(this.bitstream, parser, new HashMap<Block, List<AbbreviatedRecord[]>>(this.oldDefaultAbbreviations), this.startingBlock, this.startingIdSize, this.startingOffset);
            scanner.startSubBlock(this.startingBlock, this.startingIdSize);
            scanner.scanToOffset(this.endingOffset);
        }
    }

    public static class ToEndScanner
    extends LLVMScanner {
        public ToEndScanner(BitStream bitstream) {
            super(bitstream, null);
        }

        public static long parseToEnd(ByteSequence bitcode) {
            BitStream bitstream = BitStream.create(bitcode);
            ToEndScanner scanner = new ToEndScanner(bitstream);
            long actualMagicWord = scanner.read(32);
            if (actualMagicWord != Magic.BC_MAGIC_WORD.magic) {
                throw new LLVMParserException("Not a valid Bitcode File!");
            }
            scanner.scanToEnd();
            return scanner.offset / 8L;
        }

        @Override
        protected void enterSubBlock(long blockId, int newIdSize, long numWords) {
            assert (numWords > 0L);
            long startOffset = this.offset;
            this.offset += numWords * 32L;
            if (this.offset < startOffset) {
                throw new LLVMParserException("invalid bitcode: overflow or negative size");
            }
        }

        @Override
        protected boolean exitBlock() {
            this.offset = this.oldOffset;
            return true;
        }

        @Override
        protected void unabbreviatedRecord(RecordBuffer buffer) {
        }
    }
}

