/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.nodes;

import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.parser.metadata.debuginfo.SourceVariable;
import com.oracle.truffle.llvm.parser.metadata.debuginfo.ValueFragment;
import com.oracle.truffle.llvm.runtime.CommonNodeFactory;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceSymbol;
import com.oracle.truffle.llvm.runtime.debug.value.LLVMDebugObjectBuilder;
import com.oracle.truffle.llvm.runtime.debug.value.LLVMDebugValue;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.base.LLVMBasicBlockNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.debug.LLVMDebugAggregateObjectBuilder;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.debug.LLVMDebugSimpleObjectBuilder;
import com.oracle.truffle.llvm.runtime.types.symbols.LocalVariableDebugInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class LLVMRuntimeDebugInformation
implements LocalVariableDebugInfo {
    private final LocalVarDebugInfo[][] infos;
    private ArrayList<Integer>[] predecessors;
    private LLVMBasicBlockNode[] blocks;
    private ArrayList<HashMap<LLVMSourceSymbol, List<LocalVarDebugInfo>>> blockEntryDebugInfo;

    public LLVMRuntimeDebugInformation(int blockCount) {
        this.infos = new LocalVarDebugInfo[blockCount][];
    }

    public void setBlockDebugInfo(int blockIndex, LocalVarDebugInfo[] debugInfo) {
        assert (this.infos[blockIndex] == null);
        this.infos[blockIndex] = debugInfo;
    }

    public void setBlocks(LLVMBasicBlockNode[] blocks) {
        this.blocks = blocks;
    }

    @Override
    public Map<LLVMSourceSymbol, Object> getLocalVariables(Frame frame, Node node) {
        for (Node current = node; current != null; current = current.getParent()) {
            if (!(current.getParent() instanceof LLVMBasicBlockNode)) continue;
            LLVMBasicBlockNode block = (LLVMBasicBlockNode)current.getParent();
            for (int i = 0; i < block.getStatements().length; ++i) {
                if (block.getStatements()[i] != current) continue;
                return this.getLocalVariablesForIndex(frame, block.getBlockId(), i);
            }
            assert (current == block.getTerminatingInstruction());
            return this.getLocalVariablesForIndex(frame, block.getBlockId(), Integer.MAX_VALUE);
        }
        return this.getLocalVariablesForIndex(frame, 0, 0);
    }

    private HashMap<LLVMSourceSymbol, List<LocalVarDebugInfo>> applyBlockInfo(HashMap<LLVMSourceSymbol, List<LocalVarDebugInfo>> blockEntryState, int blockId, int end) {
        HashMap<LLVMSourceSymbol, List<LocalVarDebugInfo>> result = new HashMap<LLVMSourceSymbol, List<LocalVarDebugInfo>>();
        for (Map.Entry<LLVMSourceSymbol, List<LocalVarDebugInfo>> entry : blockEntryState.entrySet()) {
            result.put(entry.getKey(), new ArrayList(entry.getValue()));
        }
        for (LocalVarDebugInfo info : this.infos[blockId]) {
            List<LocalVarDebugInfo> list;
            if (info.instructionIndex > end) break;
            if (info.isInitialize()) {
                list = new ArrayList<LocalVarDebugInfo>();
                result.put(info.variable, list);
            } else {
                list = result.get(info.variable);
                if (list == null) {
                    list = new ArrayList<LocalVarDebugInfo>();
                    result.put(info.variable, list);
                }
            }
            list.add(info);
        }
        return result;
    }

    private Map<LLVMSourceSymbol, Object> getLocalVariablesForIndex(Frame frame, int blockId, int index) {
        this.initializePredecessors();
        this.initializeDebugInfo();
        HashMap<LLVMSourceSymbol, List<LocalVarDebugInfo>> info = this.applyBlockInfo(this.blockEntryDebugInfo.get(blockId), blockId, index);
        HashMap<LLVMSourceSymbol, Object> values = new HashMap<LLVMSourceSymbol, Object>();
        for (Map.Entry<LLVMSourceSymbol, List<LocalVarDebugInfo>> entry : info.entrySet()) {
            LLVMDebugObjectBuilder builder = null;
            for (LocalVarDebugInfo di : entry.getValue()) {
                builder = di.process(builder, frame);
            }
            values.put(entry.getKey(), builder.getValue(entry.getKey()));
        }
        return values;
    }

    private void initializePredecessors() {
        if (this.predecessors == null) {
            ArrayList[] result = new ArrayList[this.infos.length];
            for (int i = 0; i < this.infos.length; ++i) {
                result[i] = new ArrayList(2);
            }
            for (LLVMBasicBlockNode b : this.blocks) {
                for (int successor : b.getTerminatingInstruction().getSuccessors()) {
                    if (successor < 0) continue;
                    result[successor].add(b.getBlockId());
                }
            }
            this.predecessors = result;
        }
    }

    private void initializeDebugInfo() {
        if (this.blockEntryDebugInfo == null) {
            int i;
            boolean changed;
            ArrayList<HashMap<LLVMSourceSymbol, List<LocalVarDebugInfo>>> result = new ArrayList<HashMap<LLVMSourceSymbol, List<LocalVarDebugInfo>>>();
            for (int i2 = 0; i2 < this.infos.length; ++i2) {
                result.add(new HashMap());
            }
            do {
                changed = false;
                for (i = 0; i < this.infos.length; ++i) {
                    changed |= this.merge(i, result, this.predecessors[i], true);
                }
            } while (changed);
            do {
                changed = false;
                for (i = 0; i < this.infos.length; ++i) {
                    changed |= this.merge(i, result, this.predecessors[i], false);
                }
            } while (changed);
            this.blockEntryDebugInfo = result;
        }
    }

    private boolean merge(int blockId, List<HashMap<LLVMSourceSymbol, List<LocalVarDebugInfo>>> entryDebugInfo, ArrayList<Integer> preds, boolean propagate) {
        if (preds.isEmpty()) {
            return false;
        }
        HashMap<LLVMSourceSymbol, List<LocalVarDebugInfo>> result = this.applyBlockInfo(entryDebugInfo.get(preds.get(0)), preds.get(0), Integer.MAX_VALUE);
        for (int i = 1; i < preds.size(); ++i) {
            HashMap<LLVMSourceSymbol, List<LocalVarDebugInfo>> variables = this.applyBlockInfo(entryDebugInfo.get(preds.get(i)), preds.get(i), Integer.MAX_VALUE);
            Iterator<Map.Entry<LLVMSourceSymbol, List<LocalVarDebugInfo>>> iterator = variables.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<LLVMSourceSymbol, List<LocalVarDebugInfo>> existing = iterator.next();
                if (propagate) {
                    if (result.containsKey(existing.getKey())) continue;
                    result.put(existing.getKey(), existing.getValue());
                    continue;
                }
                if (Objects.equals(variables.get(existing.getKey()), existing.getValue())) continue;
                iterator.remove();
            }
        }
        HashMap<LLVMSourceSymbol, List<LocalVarDebugInfo>> old = entryDebugInfo.get(blockId);
        entryDebugInfo.set(blockId, result);
        return !old.equals(result);
    }

    static abstract class LocalVarDebugInfo {
        public final int instructionIndex;
        public final LLVMSourceSymbol variable;

        LocalVarDebugInfo(int instructionIndex, LLVMSourceSymbol variable) {
            this.instructionIndex = instructionIndex;
            this.variable = variable;
        }

        public abstract LLVMDebugObjectBuilder process(LLVMDebugObjectBuilder var1, Frame var2);

        public abstract boolean isInitialize();
    }

    static final class SetLocalVariablePart
    extends SimpleLocalVariable {
        private final int partIndex;

        SetLocalVariablePart(int instructionIndex, boolean mustDereference, Object value, int valueFrameSlot, LLVMSourceSymbol variable, int partIndex) {
            super(instructionIndex, mustDereference, value, valueFrameSlot, variable);
            this.partIndex = partIndex;
        }

        @Override
        public LLVMDebugObjectBuilder process(LLVMDebugObjectBuilder previous, Frame frame) {
            ((LLVMDebugAggregateObjectBuilder)previous).setPart(this.partIndex, this.createBuilder(), this.getValue(frame));
            return previous;
        }

        @Override
        public boolean isInitialize() {
            return false;
        }
    }

    static final class ClearLocalVariableParts
    extends LocalVarDebugInfo {
        private final int[] parts;

        ClearLocalVariableParts(int instructionIndex, LLVMSourceSymbol variable, int[] parts) {
            super(instructionIndex, variable);
            this.parts = parts;
        }

        @Override
        public LLVMDebugObjectBuilder process(LLVMDebugObjectBuilder previous, Frame frame) {
            ((LLVMDebugAggregateObjectBuilder)previous).clear(this.parts);
            return previous;
        }

        @Override
        public boolean isInitialize() {
            return false;
        }
    }

    static final class InitAggreateLocalVariable
    extends LocalVarDebugInfo {
        private final int[] offsets;
        private final int[] lengths;

        InitAggreateLocalVariable(int instructionIndex, SourceVariable variable) {
            super(instructionIndex, variable.getSymbol());
            assert (variable.hasFragments());
            List<ValueFragment> fragments = variable.getFragments();
            this.offsets = new int[fragments.size()];
            this.lengths = new int[fragments.size()];
            for (int i = 0; i < fragments.size(); ++i) {
                ValueFragment fragment = fragments.get(i);
                this.offsets[i] = fragment.getOffset();
                this.lengths[i] = fragment.getLength();
            }
        }

        @Override
        public LLVMDebugObjectBuilder process(LLVMDebugObjectBuilder previous, Frame frame) {
            return new LLVMDebugAggregateObjectBuilder(this.offsets, this.lengths);
        }

        @Override
        public boolean isInitialize() {
            return true;
        }
    }

    static class SimpleLocalVariable
    extends LocalVarDebugInfo {
        private final boolean mustDereference;
        private final Object value;
        private final int frameSlot;

        SimpleLocalVariable(int instructionIndex, boolean mustDereference, Object value, int frameSlot, LLVMSourceSymbol variable) {
            super(instructionIndex, variable);
            this.mustDereference = mustDereference;
            this.value = value;
            this.frameSlot = frameSlot;
        }

        protected Object getValue(Frame frame) {
            if (this.frameSlot != -1) {
                return frame.getValue(this.frameSlot);
            }
            if (this.value != null) {
                if (this.value instanceof LLVMExpressionNode) {
                    try {
                        return ((LLVMExpressionNode)((Object)this.value)).executeGeneric((VirtualFrame)frame);
                    }
                    catch (IllegalStateException illegalStateException) {
                    }
                } else {
                    return this.value;
                }
            }
            return null;
        }

        protected LLVMDebugValue.Builder createBuilder() {
            return this.mustDereference ? CommonNodeFactory.createDebugDeclarationBuilder() : CommonNodeFactory.createDebugValueBuilder();
        }

        @Override
        public LLVMDebugObjectBuilder process(LLVMDebugObjectBuilder previous, Frame frame) {
            return new LLVMDebugSimpleObjectBuilder(this.createBuilder(), this.getValue(frame));
        }

        @Override
        public boolean isInitialize() {
            return true;
        }
    }

    static class UnavailableLocalVariable
    extends LocalVarDebugInfo {
        UnavailableLocalVariable(int instructionIndex, LLVMSourceSymbol variable) {
            super(instructionIndex, variable);
        }

        @Override
        public LLVMDebugObjectBuilder process(LLVMDebugObjectBuilder previous, Frame frame) {
            return LLVMDebugObjectBuilder.UNAVAILABLE;
        }

        @Override
        public boolean isInitialize() {
            return true;
        }
    }
}

