/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.model.symbols.instructions;

import com.oracle.truffle.llvm.parser.model.SymbolImpl;
import com.oracle.truffle.llvm.parser.model.SymbolTable;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.ValueInstruction;
import com.oracle.truffle.llvm.parser.model.visitors.SymbolVisitor;
import com.oracle.truffle.llvm.runtime.types.Type;

public final class GetElementPointerInstruction
extends ValueInstruction {
    private final Type baseType;
    private SymbolImpl base;
    private final SymbolImpl[] indices;
    private final boolean isInbounds;

    private GetElementPointerInstruction(Type type, Type baseType, boolean isInbounds, int numIndices) {
        super(type);
        this.baseType = baseType;
        this.indices = new SymbolImpl[numIndices];
        this.isInbounds = isInbounds;
    }

    @Override
    public void accept(SymbolVisitor visitor) {
        visitor.visit(this);
    }

    public SymbolImpl getBasePointer() {
        return this.base;
    }

    public Type getBaseType() {
        return this.baseType;
    }

    public SymbolImpl[] getIndices() {
        return this.indices;
    }

    public boolean isInbounds() {
        return this.isInbounds;
    }

    @Override
    public void replace(SymbolImpl original, SymbolImpl replacement) {
        if (this.base == original) {
            this.base = replacement;
        }
        for (int i = 0; i < this.indices.length; ++i) {
            if (this.indices[i] != original) continue;
            this.indices[i] = replacement;
        }
    }

    public static GetElementPointerInstruction fromSymbols(SymbolTable symbols, Type type, Type baseType, int pointer, int[] indices, boolean isInbounds) {
        GetElementPointerInstruction inst = new GetElementPointerInstruction(type, baseType, isInbounds, indices.length);
        inst.base = symbols.getForwardReferenced(pointer, inst);
        for (int i = 0; i < indices.length; ++i) {
            inst.indices[i] = symbols.getForwardReferenced(indices[i], inst);
        }
        return inst;
    }
}

