/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.model.symbols.instructions;

import com.oracle.truffle.llvm.parser.model.SymbolImpl;
import com.oracle.truffle.llvm.parser.model.SymbolTable;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.ValueInstruction;
import com.oracle.truffle.llvm.parser.model.visitors.SymbolVisitor;
import com.oracle.truffle.llvm.runtime.types.Type;

public final class ExtractElementInstruction
extends ValueInstruction {
    private SymbolImpl vector;
    private SymbolImpl index;

    private ExtractElementInstruction(Type type) {
        super(type);
    }

    @Override
    public void accept(SymbolVisitor visitor) {
        visitor.visit(this);
    }

    public SymbolImpl getIndex() {
        return this.index;
    }

    public SymbolImpl getVector() {
        return this.vector;
    }

    @Override
    public void replace(SymbolImpl original, SymbolImpl replacement) {
        if (this.vector == original) {
            this.vector = replacement;
        }
        if (this.index == original) {
            this.index = replacement;
        }
    }

    public static ExtractElementInstruction fromSymbols(SymbolTable symbols, Type type, int vector, int index) {
        ExtractElementInstruction inst = new ExtractElementInstruction(type);
        inst.vector = symbols.getForwardReferenced(vector, inst);
        inst.index = symbols.getForwardReferenced(index, inst);
        return inst;
    }
}

