/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.model.symbols.instructions;

import com.oracle.truffle.llvm.parser.model.SymbolImpl;
import com.oracle.truffle.llvm.parser.model.SymbolTable;
import com.oracle.truffle.llvm.parser.model.blocks.InstructionBlock;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.TerminatingInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.ValueInstruction;
import com.oracle.truffle.llvm.parser.model.visitors.SymbolVisitor;
import com.oracle.truffle.llvm.runtime.types.MetaType;

public final class CatchSwitchInstruction
extends ValueInstruction
implements TerminatingInstruction {
    private final InstructionBlock block;
    private final InstructionBlock unwind;
    private SymbolImpl within;
    private final InstructionBlock[] cases;

    private CatchSwitchInstruction(InstructionBlock block, InstructionBlock[] cases, InstructionBlock unwind) {
        super(MetaType.TOKEN);
        assert (cases.length > 0);
        this.block = block;
        this.cases = cases;
        this.unwind = unwind;
    }

    public InstructionBlock getInstructionBlock() {
        return this.block;
    }

    public InstructionBlock getFirstCase() {
        return this.cases[0];
    }

    public boolean hasUnwindBlock() {
        return this.unwind != null;
    }

    public InstructionBlock getUnwindBlock() {
        return this.unwind;
    }

    @Override
    public void replace(SymbolImpl oldValue, SymbolImpl newValue) {
        if (this.within == oldValue) {
            this.within = newValue;
        }
    }

    @Override
    public void accept(SymbolVisitor visitor) {
        visitor.visit(this);
    }

    public static CatchSwitchInstruction generate(SymbolTable table, InstructionBlock block, int withinIndex, InstructionBlock[] cases, InstructionBlock unwind) {
        CatchSwitchInstruction l = new CatchSwitchInstruction(block, cases, unwind);
        l.within = table.getForwardReferencedOrNull(withinIndex, l);
        return l;
    }

    @Override
    public int getSuccessorCount() {
        return this.hasUnwindBlock() ? this.cases.length + 1 : this.cases.length;
    }

    @Override
    public InstructionBlock getSuccessor(int index) {
        assert (index < this.cases.length || this.unwind != null && index == this.cases.length);
        return index < this.cases.length ? this.cases[index] : this.unwind;
    }
}

