/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.model.symbols.constants.floatingpoint;

import com.oracle.truffle.llvm.parser.LLVMParserRuntime;
import com.oracle.truffle.llvm.parser.model.symbols.constants.floatingpoint.FloatingPointConstant;
import com.oracle.truffle.llvm.parser.model.visitors.SymbolVisitor;
import com.oracle.truffle.llvm.runtime.CommonNodeFactory;
import com.oracle.truffle.llvm.runtime.GetStackSpaceFactory;
import com.oracle.truffle.llvm.runtime.datalayout.DataLayout;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.types.PrimitiveType;
import java.util.Arrays;

public final class FP128Constant
extends FloatingPointConstant {
    private final byte[] value;
    private static final int HEX_MASK = 15;
    private static final int BYTE_MSB_SHIFT = 8;

    FP128Constant(byte[] value) {
        super(PrimitiveType.F128);
        this.value = value;
    }

    @Override
    public void accept(SymbolVisitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        return Arrays.toString(this.value);
    }

    @Override
    public String getStringValue() {
        StringBuilder builder = new StringBuilder("");
        for (byte aValue : this.value) {
            builder.append(String.format("%x%x", aValue >>> 8 & 0xF, aValue & 0xF));
        }
        return builder.toString();
    }

    @Override
    public LLVMExpressionNode createNode(LLVMParserRuntime runtime, DataLayout dataLayout, GetStackSpaceFactory stackFactory) {
        return CommonNodeFactory.createSimpleConstantNoArray(this.value, this.getType());
    }
}

