/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.model.enums;

public enum CastOperator {
    TRUNCATE("trunc"),
    ZERO_EXTEND("zext"),
    SIGN_EXTEND("sext"),
    FP_TO_UNSIGNED_INT("fptoui"),
    FP_TO_SIGNED_INT("fptosi"),
    UNSIGNED_INT_TO_FP("uitofp"),
    SIGNED_INT_TO_FP("sitofp"),
    FP_TRUNCATE("fptrunc"),
    FP_EXTEND("fpext"),
    PTR_TO_INT("ptrtoint"),
    INT_TO_PTR("inttoptr"),
    BITCAST("bitcast"),
    ADDRESS_SPACE_CAST("addrspacecast");

    private static final CastOperator[] VALUES;
    private final String irString;

    public static CastOperator decode(int code) {
        if (code >= 0 && code < VALUES.length) {
            return VALUES[code];
        }
        return null;
    }

    private CastOperator(String irString) {
        this.irString = irString;
    }

    public String getIrString() {
        return this.irString;
    }

    static {
        VALUES = CastOperator.values();
    }
}

