/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.model.blocks;

import com.oracle.truffle.llvm.parser.model.symbols.instructions.DebugInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.Instruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.TerminatingInstruction;
import com.oracle.truffle.llvm.parser.model.visitors.SymbolVisitor;
import java.util.ArrayList;
import java.util.List;

public final class InstructionBlock {
    private final int blockIndex;
    private final ArrayList<Instruction> instructions = new ArrayList();
    private String name = "<anon>";

    public InstructionBlock(int index) {
        this.blockIndex = index;
    }

    public void accept(SymbolVisitor visitor) {
        for (Instruction instruction : this.instructions) {
            instruction.accept(visitor);
        }
    }

    public void append(Instruction instruction) {
        this.instructions.add(instruction);
    }

    public void addDebug(DebugInstruction instruction) {
        int size = this.instructions.size();
        if (size == 0) {
            this.instructions.add(instruction);
        } else {
            this.instructions.add(size - 1, instruction);
        }
    }

    public int getBlockIndex() {
        return this.blockIndex;
    }

    public String getName() {
        return this.name;
    }

    public List<Instruction> getInstructions() {
        return this.instructions;
    }

    public Instruction getInstruction(int index) {
        return this.instructions.get(index);
    }

    public int getInstructionCount() {
        return this.instructions.size();
    }

    public void setName(String name) {
        this.name = name;
    }

    public TerminatingInstruction getTerminatingInstruction() {
        assert (this.instructions.get(this.instructions.size() - 1) instanceof TerminatingInstruction) : "last instruction must be a terminating instruction";
        return (TerminatingInstruction)((Object)this.instructions.get(this.instructions.size() - 1));
    }

    public String toString() {
        return String.format("Block (%d) %s", this.blockIndex, this.name);
    }
}

