/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.metadata.debuginfo;

import com.oracle.truffle.llvm.parser.metadata.debuginfo.SourceVariable;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceLocation;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceSymbol;
import com.oracle.truffle.llvm.runtime.debug.type.LLVMSourceFunctionType;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class SourceFunction {
    public static final String DEFAULT_SOURCE_NAME = "<anon>";
    public static final SourceFunction DEFAULT = new SourceFunction(LLVMSourceLocation.createBitcodeFunction("<anon>", null), null);
    private Map<LLVMSourceSymbol, SourceVariable> locals;
    private final LLVMSourceLocation lexicalScope;
    private final LLVMSourceFunctionType sourceType;

    public SourceFunction(LLVMSourceLocation lexicalScope, LLVMSourceFunctionType sourceType) {
        this.lexicalScope = lexicalScope;
        this.sourceType = sourceType;
    }

    public LLVMSourceLocation getLexicalScope() {
        return this.lexicalScope;
    }

    public LLVMSourceFunctionType getSourceType() {
        return this.sourceType;
    }

    SourceVariable getLocal(LLVMSourceSymbol symbol) {
        if (this.locals == null) {
            this.locals = new HashMap<LLVMSourceSymbol, SourceVariable>();
        } else if (this.locals.containsKey(symbol)) {
            return this.locals.get(symbol);
        }
        SourceVariable variable = new SourceVariable(symbol);
        this.locals.put(symbol, variable);
        return variable;
    }

    public Collection<SourceVariable> getVariables() {
        return this.locals == null ? Collections.emptySet() : this.locals.values();
    }

    public String getName() {
        return this.lexicalScope.getName();
    }

    public void clearLocals() {
        if (this.locals != null) {
            this.locals.clear();
        }
    }
}

