/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.metadata;

import com.oracle.truffle.llvm.parser.metadata.MDExpression;
import java.math.BigInteger;
import java.util.ArrayDeque;

public final class DwarfOpcode {
    public static final long ADDR = 3L;
    public static final long DEREF = 6L;
    public static final long CONST1U = 8L;
    public static final long CONST1S = 9L;
    public static final long CONST2U = 10L;
    public static final long CONST2S = 11L;
    public static final long CONST4U = 12L;
    public static final long CONST4S = 13L;
    public static final long CONST8U = 14L;
    public static final long CONST8S = 15L;
    public static final long CONSTU = 16L;
    public static final long CONSTS = 17L;
    public static final long DUP = 18L;
    public static final long DROP = 19L;
    public static final long OVER = 20L;
    public static final long PICK = 21L;
    public static final long SWAP = 22L;
    public static final long ROT = 23L;
    public static final long XDEREF = 24L;
    public static final long ABS = 25L;
    public static final long AND = 26L;
    public static final long DIV = 27L;
    public static final long MINUS = 28L;
    public static final long MOD = 29L;
    public static final long MUL = 30L;
    public static final long NEG = 31L;
    public static final long NOT = 32L;
    public static final long OR = 33L;
    public static final long PLUS = 34L;
    public static final long PLUS_UCONST = 35L;
    public static final long SHL = 36L;
    public static final long SHR = 37L;
    public static final long SHRA = 38L;
    public static final long XOR = 39L;
    public static final long BRA = 40L;
    public static final long EQ = 41L;
    public static final long GE = 42L;
    public static final long GT = 43L;
    public static final long LE = 44L;
    public static final long LT = 45L;
    public static final long NE = 46L;
    public static final long SKIP = 47L;
    public static final long LIT0 = 48L;
    public static final long LIT1 = 49L;
    public static final long LIT2 = 50L;
    public static final long LIT3 = 51L;
    public static final long LIT4 = 52L;
    public static final long LIT5 = 53L;
    public static final long LIT6 = 54L;
    public static final long LIT7 = 55L;
    public static final long LIT8 = 56L;
    public static final long LIT9 = 57L;
    public static final long LIT10 = 58L;
    public static final long LIT11 = 59L;
    public static final long LIT12 = 60L;
    public static final long LIT13 = 61L;
    public static final long LIT14 = 62L;
    public static final long LIT15 = 63L;
    public static final long LIT16 = 64L;
    public static final long LIT17 = 65L;
    public static final long LIT18 = 66L;
    public static final long LIT19 = 67L;
    public static final long LIT20 = 68L;
    public static final long LIT21 = 69L;
    public static final long LIT22 = 70L;
    public static final long LIT23 = 71L;
    public static final long LIT24 = 72L;
    public static final long LIT25 = 73L;
    public static final long LIT26 = 74L;
    public static final long LIT27 = 75L;
    public static final long LIT28 = 76L;
    public static final long LIT29 = 77L;
    public static final long LIT30 = 78L;
    public static final long LIT31 = 79L;
    public static final long REG0 = 80L;
    public static final long REG1 = 81L;
    public static final long REG2 = 82L;
    public static final long REG3 = 83L;
    public static final long REG4 = 84L;
    public static final long REG5 = 85L;
    public static final long REG6 = 86L;
    public static final long REG7 = 87L;
    public static final long REG8 = 88L;
    public static final long REG9 = 89L;
    public static final long REG10 = 90L;
    public static final long REG11 = 91L;
    public static final long REG12 = 92L;
    public static final long REG13 = 93L;
    public static final long REG14 = 94L;
    public static final long REG15 = 95L;
    public static final long REG16 = 96L;
    public static final long REG17 = 97L;
    public static final long REG18 = 98L;
    public static final long REG19 = 99L;
    public static final long REG20 = 100L;
    public static final long REG21 = 101L;
    public static final long REG22 = 102L;
    public static final long REG23 = 103L;
    public static final long REG24 = 104L;
    public static final long REG25 = 105L;
    public static final long REG26 = 106L;
    public static final long REG27 = 107L;
    public static final long REG28 = 108L;
    public static final long REG29 = 109L;
    public static final long REG30 = 110L;
    public static final long REG31 = 111L;
    public static final long BREG0 = 112L;
    public static final long BREG1 = 113L;
    public static final long BREG2 = 114L;
    public static final long BREG3 = 115L;
    public static final long BREG4 = 116L;
    public static final long BREG5 = 117L;
    public static final long BREG6 = 118L;
    public static final long BREG7 = 119L;
    public static final long BREG8 = 120L;
    public static final long BREG9 = 121L;
    public static final long BREG10 = 122L;
    public static final long BREG11 = 123L;
    public static final long BREG12 = 124L;
    public static final long BREG13 = 125L;
    public static final long BREG14 = 126L;
    public static final long BREG15 = 127L;
    public static final long BREG16 = 128L;
    public static final long BREG17 = 129L;
    public static final long BREG18 = 130L;
    public static final long BREG19 = 131L;
    public static final long BREG20 = 132L;
    public static final long BREG21 = 133L;
    public static final long BREG22 = 134L;
    public static final long BREG23 = 135L;
    public static final long BREG24 = 136L;
    public static final long BREG25 = 137L;
    public static final long BREG26 = 138L;
    public static final long BREG27 = 139L;
    public static final long BREG28 = 140L;
    public static final long BREG29 = 141L;
    public static final long BREG30 = 142L;
    public static final long BREG31 = 143L;
    public static final long REGX = 144L;
    public static final long FBREG = 145L;
    public static final long BREGX = 146L;
    public static final long PIECE = 147L;
    public static final long DEREF_SIZE = 148L;
    public static final long XDEREF_SIZE = 149L;
    public static final long NOP = 150L;
    public static final long PUSH_OBJECT_ADDRESS = 151L;
    public static final long CALL2 = 152L;
    public static final long CALL4 = 153L;
    public static final long CALL_REF = 154L;
    public static final long FORM_TLS_ADDRESS = 155L;
    public static final long CALL_FRAME_CFA = 156L;
    public static final long BIT_PIECE = 157L;
    public static final long IMPLICIT_VALUE = 158L;
    public static final long STACK_VALUE = 159L;
    public static final long IMPLICIT_POlongER = 160L;
    public static final long ADDRX = 161L;
    public static final long CONSTX = 162L;
    public static final long ENTRY_VALUE = 163L;
    public static final long CONST_TYPE = 164L;
    public static final long REGVAL_TYPE = 165L;
    public static final long DEREF_TYPE = 166L;
    public static final long XDEREF_TYPE = 167L;
    public static final long CONVERT = 168L;
    public static final long REINTERPRET = 169L;
    public static final long GNU_PUSH_TLS_ADDRESS = 224L;
    public static final long GNU_ADDR_INDEX = 251L;
    public static final long GNU_CONST_INDEX = 252L;
    public static final long LLVM_FRAGMENT = 4096L;

    public static int numElements(long op) {
        if (op == 35L || op == 34L || op == 28L || op >= 8L && op <= 17L) {
            return 2;
        }
        if (op == 4096L || op == 157L) {
            return 3;
        }
        return 1;
    }

    public static boolean hasOp(MDExpression expression, long operand) {
        long op;
        int elementCount = expression.getElementCount();
        for (int i = 0; i < elementCount; i += DwarfOpcode.numElements(op)) {
            op = expression.getOperand(i);
            if (op != operand) continue;
            return true;
        }
        return false;
    }

    public static boolean isDeref(MDExpression expression) {
        return DwarfOpcode.hasOp(expression, 6L);
    }

    public static BigInteger toIntegerSymbol(MDExpression exp) {
        ArrayDeque<BigInteger> dwStack = new ArrayDeque<BigInteger>(4);
        int i = 0;
        while (i < exp.getElementCount()) {
            long op;
            if ((op = exp.getOperand(i++)) >= 48L && op <= 79L) {
                dwStack.push(BigInteger.valueOf(op - 48L));
                continue;
            }
            if (op >= 8L && op <= 17L) {
                BigInteger res;
                if (i >= exp.getElementCount()) {
                    return null;
                }
                long arg = exp.getOperand(i++);
                switch ((int)op) {
                    case 9: {
                        res = BigInteger.valueOf((byte)arg);
                        break;
                    }
                    case 8: {
                        res = BigInteger.valueOf(arg & 0xFFL);
                        break;
                    }
                    case 11: {
                        res = BigInteger.valueOf((short)arg);
                        break;
                    }
                    case 10: {
                        res = BigInteger.valueOf(arg & 0xFFFFL);
                        break;
                    }
                    case 13: {
                        res = BigInteger.valueOf((int)arg);
                        break;
                    }
                    case 12: {
                        res = BigInteger.valueOf(arg & 0xFFFFFFFFL);
                        break;
                    }
                    case 15: {
                        res = BigInteger.valueOf(arg);
                        break;
                    }
                    case 14: {
                        res = new BigInteger(Long.toUnsignedString(arg));
                        break;
                    }
                    case 16: 
                    case 17: {
                        res = BigInteger.valueOf(arg);
                        break;
                    }
                    default: {
                        return null;
                    }
                }
                dwStack.push(res);
                continue;
            }
            if (op == 159L) {
                return !dwStack.isEmpty() ? (BigInteger)dwStack.getFirst() : null;
            }
            return null;
        }
        return null;
    }

    private DwarfOpcode() {
    }
}

