/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.vars;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.FrameSlotKind;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.llvm.runtime.LLVMIVarBit;
import com.oracle.truffle.llvm.runtime.floating.LLVM128BitFloat;
import com.oracle.truffle.llvm.runtime.floating.LLVM80BitFloat;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStatementNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.vector.LLVMVector;

@NodeChild(value="valueNode", type=LLVMExpressionNode.class)
public abstract class LLVMWriteNode
extends LLVMStatementNode {
    protected final int slot;

    protected LLVMWriteNode(int slot) {
        assert (slot >= 0);
        this.slot = slot;
    }

    public abstract void executeWithTarget(VirtualFrame var1, Object var2);

    @Override
    public String toString() {
        return this.getShortString("slot");
    }

    public static abstract class LLVMWriteVectorNode
    extends LLVMWriteNode {
        protected LLVMWriteVectorNode(int slot) {
            super(slot);
        }

        @Specialization
        protected void writeVector(VirtualFrame frame, LLVMVector value) {
            frame.setObject(this.slot, (Object)value);
        }
    }

    public static abstract class LLVMWritePointerNode
    extends LLVMWriteNode {
        protected LLVMWritePointerNode(int slot) {
            super(slot);
        }

        @Specialization
        protected void writeLong(VirtualFrame frame, long value) {
            frame.setObject(this.slot, (Object)LLVMNativePointer.create(value));
        }

        @Fallback
        protected void writeObject(VirtualFrame frame, Object value) {
            frame.setObject(this.slot, value);
        }
    }

    public static abstract class LLVMWrite128BitFloatingNode
    extends LLVMWriteNode {
        protected LLVMWrite128BitFloatingNode(int slot) {
            super(slot);
        }

        @Specialization
        protected void write128BitFloat(VirtualFrame frame, LLVM128BitFloat value) {
            frame.setObject(this.slot, (Object)value);
        }
    }

    public static abstract class LLVMWrite80BitFloatingNode
    extends LLVMWriteNode {
        protected LLVMWrite80BitFloatingNode(int slot) {
            super(slot);
        }

        @Specialization
        protected void write80BitFloat(VirtualFrame frame, LLVM80BitFloat value) {
            frame.setObject(this.slot, (Object)value);
        }
    }

    public static abstract class LLVMWriteDoubleNode
    extends LLVMWriteNode {
        protected LLVMWriteDoubleNode(int slot) {
            super(slot);
        }

        @Specialization
        protected void writeDouble(VirtualFrame frame, double value) {
            frame.setDouble(this.slot, value);
        }
    }

    public static abstract class LLVMWriteFloatNode
    extends LLVMWriteNode {
        protected LLVMWriteFloatNode(int slot) {
            super(slot);
        }

        @Specialization
        protected void writeFloat(VirtualFrame frame, float value) {
            frame.setFloat(this.slot, value);
        }
    }

    public static abstract class LLVMWriteIVarBitNode
    extends LLVMWriteNode {
        protected LLVMWriteIVarBitNode(int slot) {
            super(slot);
        }

        @Specialization
        protected void writeIVarBit(VirtualFrame frame, LLVMIVarBit value) {
            frame.setObject(this.slot, (Object)value);
        }
    }

    public static abstract class LLVMWriteI64Node
    extends LLVMWriteNode {
        protected LLVMWriteI64Node(int slot) {
            super(slot);
        }

        @Specialization
        protected void writeI64(VirtualFrame frame, long value) {
            if (frame.getFrameDescriptor().getSlotKind(this.slot) == FrameSlotKind.Long) {
                frame.setLong(this.slot, value);
            } else {
                frame.setObject(this.slot, (Object)value);
            }
        }

        @Specialization(replaces={"writeI64"})
        @GenerateAOT.Exclude
        protected void writePointer(VirtualFrame frame, Object value) {
            if (frame.getFrameDescriptor().getSlotKind(this.slot) == FrameSlotKind.Long) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                frame.getFrameDescriptor().setSlotKind(this.slot, FrameSlotKind.Object);
            }
            frame.setObject(this.slot, value);
        }
    }

    public static abstract class LLVMWriteI32Node
    extends LLVMWriteNode {
        protected LLVMWriteI32Node(int slot) {
            super(slot);
        }

        @Specialization
        protected void writeI32(VirtualFrame frame, int value) {
            frame.setInt(this.slot, value);
        }
    }

    public static abstract class LLVMWriteI16Node
    extends LLVMWriteNode {
        protected LLVMWriteI16Node(int slot) {
            super(slot);
        }

        @Specialization
        protected void writeI16(VirtualFrame frame, short value) {
            frame.setInt(this.slot, (int)value);
        }
    }

    public static abstract class LLVMWriteI8Node
    extends LLVMWriteNode {
        protected LLVMWriteI8Node(int slot) {
            super(slot);
        }

        @Specialization
        protected void writeI8(VirtualFrame frame, byte value) {
            frame.setByte(this.slot, value);
        }
    }

    public static abstract class LLVMWriteI1Node
    extends LLVMWriteNode {
        protected LLVMWriteI1Node(int slot) {
            super(slot);
        }

        @Specialization
        protected void writeI1(VirtualFrame frame, boolean value) {
            frame.setBoolean(this.slot, value);
        }
    }
}

