/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.x86;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.LLVMVarArgCompoundValue;
import com.oracle.truffle.llvm.runtime.debug.value.LLVMSourceTypeFactory;
import com.oracle.truffle.llvm.runtime.except.LLVMMemoryException;
import com.oracle.truffle.llvm.runtime.floating.LLVM80BitFloat;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedReadLibrary;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedWriteLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.va.LLVMVaListLibrary;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.va.LLVMVaListStorage;
import com.oracle.truffle.llvm.runtime.nodes.memory.NativeProfiledMemMoveToNative;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI32LoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI64LoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMPointerLoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVM80BitFloatStoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI32StoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI64StoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMPointerStoreNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.types.ArrayType;
import com.oracle.truffle.llvm.runtime.types.PointerType;
import com.oracle.truffle.llvm.runtime.types.PrimitiveType;
import com.oracle.truffle.llvm.runtime.types.StructureType;
import com.oracle.truffle.llvm.runtime.types.Type;
import com.oracle.truffle.llvm.spi.NativeTypeLibrary;
import java.util.ArrayList;
import java.util.Arrays;

@ExportLibrary.Repeat(value={@ExportLibrary(value=LLVMManagedReadLibrary.class, useForAOT=true, useForAOTPriority=3), @ExportLibrary(value=LLVMManagedWriteLibrary.class, useForAOT=true, useForAOTPriority=2), @ExportLibrary(value=LLVMVaListLibrary.class, useForAOT=true, useForAOTPriority=1), @ExportLibrary(value=NativeTypeLibrary.class, useForAOT=true, useForAOTPriority=0), @ExportLibrary(value=InteropLibrary.class)})
public final class LLVMX86_64VaListStorage
extends LLVMVaListStorage {
    public static final ArrayType VA_LIST_TYPE = new ArrayType(StructureType.createNamedFromList("struct.__va_list_tag", false, new ArrayList<Type>(Arrays.asList(PrimitiveType.I32, PrimitiveType.I32, PointerType.I8, PointerType.I8))), 1L);
    private final Type vaListType;
    private int initGPOffset;
    private int gpOffset;
    private int initFPOffset;
    private int fpOffset;
    private RegSaveArea regSaveArea;
    private LLVMPointer regSaveAreaPtr;
    private OverflowArgArea overflowArgArea;
    private LLVMPointer overflowArgAreaBaseNativePtr;
    private LLVMPointer regSaveAreaNativePtr;

    public LLVMX86_64VaListStorage(LLVMPointer vaListStackPtr, Type vaListType) {
        super(vaListStackPtr);
        this.vaListType = vaListType;
    }

    @ExportMessage
    boolean hasNativeType() {
        return true;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Object getNativeType() {
        return LLVMLanguage.get(null).getInteropType(LLVMSourceTypeFactory.resolveType(this.vaListType, LLVMX86_64VaListStorage.findDataLayoutFromCurrentFrame()));
    }

    @ExportMessage.Repeat(value={@ExportMessage(name="isReadable"), @ExportMessage(name="isWritable")})
    boolean isAccessible() {
        return true;
    }

    @ExportMessage
    byte readI8(long offset) {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @ExportMessage
    short readI16(long offset) {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @ExportMessage
    void writeI8(long offset, byte value) {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @ExportMessage
    void writeI16(long offset, short value) {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @ExportMessage
    void writeGenericI64(long offset, Object value) {
        throw CompilerDirectives.shouldNotReachHere();
    }

    private static int calculateUsedFpArea(Object[] realArguments, int numberOfExplicitArguments) {
        assert (numberOfExplicitArguments <= realArguments.length);
        int usedFpArea = 0;
        int fpAreaLimit = 128;
        for (int i = 0; i < numberOfExplicitArguments && usedFpArea < 128; ++i) {
            if (LLVMX86_64VaListStorage.getVarArgArea(realArguments[i]) != LLVMVaListStorage.VarArgArea.FP_AREA) continue;
            usedFpArea += 16;
        }
        return usedFpArea;
    }

    private static int calculateUsedGpArea(Object[] realArguments, int numberOfExplicitArguments) {
        assert (numberOfExplicitArguments <= realArguments.length);
        int usedGpArea = 0;
        for (int i = 0; i < numberOfExplicitArguments && usedGpArea < 48; ++i) {
            if (LLVMX86_64VaListStorage.getVarArgArea(realArguments[i]) != LLVMVaListStorage.VarArgArea.GP_AREA) continue;
            usedGpArea += 8;
        }
        return usedGpArea;
    }

    @ExportMessage
    void cleanup(Frame frame) {
    }

    private static long getArgPtrFromNativePtr(LLVMX86_64VaListStorage srcVaList, LLVMManagedReadLibrary readLib) {
        LLVMPointer overflowAreaPtr = readLib.readPointer(srcVaList, 8L);
        long curAddr = LLVMNativePointer.isInstance(overflowAreaPtr) ? LLVMNativePointer.cast(overflowAreaPtr).asNative() : LLVMManagedPointer.cast(overflowAreaPtr).getOffset();
        long baseAddr = LLVMNativePointer.isInstance(srcVaList.overflowArgAreaBaseNativePtr) ? LLVMNativePointer.cast(srcVaList.overflowArgAreaBaseNativePtr).asNative() : LLVMManagedPointer.cast(srcVaList.overflowArgAreaBaseNativePtr).getOffset();
        return curAddr - baseAddr;
    }

    @ExportMessage
    Object shift(Type type, Frame frame, @CachedLibrary(limit="1") LLVMManagedReadLibrary readLib, @CachedLibrary(limit="1") LLVMManagedWriteLibrary writeLib, @Cached BranchProfile regAreaProfile, @Cached LLVMVaListStorage.LoadFromAreaNode loadFromArea, @Cached ConditionProfile isNativizedProfile) {
        int regSaveOffs = 0;
        int regSaveStep = 0;
        int regSaveLimit = 0;
        boolean lookIntoRegSaveArea = true;
        LLVMVaListStorage.VarArgArea varArgArea = LLVMX86_64VaListStorage.getVarArgArea(type);
        switch (varArgArea) {
            case GP_AREA: {
                regSaveOffs = 0;
                regSaveStep = 8;
                regSaveLimit = 48;
                break;
            }
            case FP_AREA: {
                regSaveOffs = 4;
                regSaveStep = 16;
                regSaveLimit = 176;
                break;
            }
            case OVERFLOW_AREA: {
                lookIntoRegSaveArea = false;
            }
        }
        if (lookIntoRegSaveArea) {
            regAreaProfile.enter();
            int offs = readLib.readI32(this, regSaveOffs);
            if (offs < regSaveLimit) {
                writeLib.writeI32(this, regSaveOffs, offs + regSaveStep);
                if (this.regSaveArea != null) {
                    long n = this.regSaveArea.offsetToIndex(offs);
                    int i = (int)(n << 32 >> 32);
                    return this.regSaveArea.args[i];
                }
                return loadFromArea.execute(this.vaListStackPtr, 16, offs, 0, type);
            }
        }
        if (isNativizedProfile.profile(this.isNativized())) {
            return loadFromArea.execute(this.vaListStackPtr, 8, 0, 8, type);
        }
        Object currentArg = this.overflowArgArea.getCurrentArg();
        this.overflowArgArea.shift(1);
        return currentArg;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    void toNative(@Cached LLVMI32StoreNode.LLVMI32OffsetStoreNode gpOffsetStore, @Cached LLVMI32StoreNode.LLVMI32OffsetStoreNode fpOffsetStore, @Cached LLVMPointerStoreNode.LLVMPointerOffsetStoreNode overflowArgAreaStore, @Cached LLVMPointerStoreNode.LLVMPointerOffsetStoreNode regSaveAreaStore, @Cached LLVMI64StoreNode.LLVMI64OffsetStoreNode i64RegSaveAreaStore, @Cached LLVMI32StoreNode.LLVMI32OffsetStoreNode i32RegSaveAreaStore, @Cached LLVM80BitFloatStoreNode.LLVM80BitFloatOffsetStoreNode fp80bitRegSaveAreaStore, @Cached LLVMPointerStoreNode.LLVMPointerOffsetStoreNode pointerRegSaveAreaStore, @Cached LLVMI64StoreNode.LLVMI64OffsetStoreNode i64OverflowArgAreaStore, @Cached LLVMI32StoreNode.LLVMI32OffsetStoreNode i32OverflowArgAreaStore, @Cached LLVM80BitFloatStoreNode.LLVM80BitFloatOffsetStoreNode fp80bitOverflowArgAreaStore, @Cached LLVMPointerStoreNode.LLVMPointerOffsetStoreNode pointerOverflowArgAreaStore, @Cached NativeProfiledMemMoveToNative memMove, @Cached BranchProfile nativizedProfile) {
        if (this.isNativized()) {
            nativizedProfile.enter();
            return;
        }
        this.nativized = true;
        if (this.overflowArgArea == null) {
            return;
        }
        if (!LLVMNativePointer.isInstance(this.regSaveAreaNativePtr) || !LLVMNativePointer.isInstance(this.overflowArgAreaBaseNativePtr)) {
            this.nativized = false;
            return;
        }
        LLVMX86_64VaListStorage.initNativeVAList(gpOffsetStore, fpOffsetStore, overflowArgAreaStore, regSaveAreaStore, this.vaListStackPtr, this.gpOffset, this.fpOffset, this.overflowArgAreaBaseNativePtr.increment(this.overflowArgArea.getOffset()), this.regSaveAreaNativePtr);
        LLVMX86_64VaListStorage.initNativeAreas(this.realArguments, this.numberOfExplicitArguments, this.initGPOffset, this.initFPOffset, LLVMNativePointer.cast(this.regSaveAreaNativePtr), LLVMNativePointer.cast(this.overflowArgAreaBaseNativePtr), i64RegSaveAreaStore, i32RegSaveAreaStore, fp80bitRegSaveAreaStore, pointerRegSaveAreaStore, i64OverflowArgAreaStore, i32OverflowArgAreaStore, fp80bitOverflowArgAreaStore, pointerOverflowArgAreaStore, memMove);
    }

    private void allocateNativeAreas(LLVMVaListStorage.StackAllocationNode stackAllocationNode, Frame frame) {
        this.regSaveAreaNativePtr = stackAllocationNode.executeWithTarget(176L, frame);
        this.overflowArgAreaBaseNativePtr = this.overflowArgArea == null ? null : stackAllocationNode.executeWithTarget(this.overflowArgArea.overflowAreaSize, frame);
    }

    private static void initNativeVAList(LLVMI32StoreNode.LLVMI32OffsetStoreNode gpOffsetStore, LLVMI32StoreNode.LLVMI32OffsetStoreNode fpOffsetStore, LLVMPointerStoreNode.LLVMPointerOffsetStoreNode overflowArgAreaStore, LLVMPointerStoreNode.LLVMPointerOffsetStoreNode regSaveAreaStore, LLVMPointer vaListStackPtr, int gpOffset, int fpOffset, LLVMPointer overflowArgAreaNativePtr, LLVMPointer regSaveAreaNativePtr) {
        gpOffsetStore.executeWithTarget(vaListStackPtr, 0L, gpOffset);
        fpOffsetStore.executeWithTarget(vaListStackPtr, 4L, fpOffset);
        overflowArgAreaStore.executeWithTarget(vaListStackPtr, 8L, overflowArgAreaNativePtr);
        regSaveAreaStore.executeWithTarget(vaListStackPtr, 16L, regSaveAreaNativePtr);
    }

    private static void initNativeAreas(Object[] realArguments, int numberOfExplicitArguments, int initGPOffset, int initFPOffset, LLVMNativePointer regSaveAreaNativePtr, LLVMNativePointer overflowArgAreaBaseNativePtr, LLVMI64StoreNode.LLVMI64OffsetStoreNode i64RegSaveAreaStore, LLVMI32StoreNode.LLVMI32OffsetStoreNode i32RegSaveAreaStore, LLVM80BitFloatStoreNode.LLVM80BitFloatOffsetStoreNode fp80bitRegSaveAreaStore, LLVMPointerStoreNode.LLVMPointerOffsetStoreNode pointerRegSaveAreaStore, LLVMI64StoreNode.LLVMI64OffsetStoreNode i64OverflowArgAreaStore, LLVMI32StoreNode.LLVMI32OffsetStoreNode i32OverflowArgAreaStore, LLVM80BitFloatStoreNode.LLVM80BitFloatOffsetStoreNode fp80bitOverflowArgAreaStore, LLVMPointerStoreNode.LLVMPointerOffsetStoreNode pointerOverflowArgAreaStore, NativeProfiledMemMoveToNative memMove) {
        int gp = initGPOffset;
        int fp = initFPOffset;
        int vaLength = realArguments.length - numberOfExplicitArguments;
        if (vaLength > 0) {
            long overflowOffset = 0L;
            for (int i = 0; i < vaLength; ++i) {
                Object object = realArguments[numberOfExplicitArguments + i];
                LLVMVaListStorage.VarArgArea area = LLVMX86_64VaListStorage.getVarArgArea(object);
                if (area == LLVMVaListStorage.VarArgArea.GP_AREA && gp < 48) {
                    LLVMX86_64VaListStorage.storeArgument(regSaveAreaNativePtr, gp, memMove, i64RegSaveAreaStore, i32RegSaveAreaStore, fp80bitRegSaveAreaStore, pointerRegSaveAreaStore, object, 8);
                    gp += 8;
                    continue;
                }
                if (area == LLVMVaListStorage.VarArgArea.FP_AREA && fp < 176) {
                    LLVMX86_64VaListStorage.storeArgument(regSaveAreaNativePtr, fp, memMove, i64RegSaveAreaStore, i32RegSaveAreaStore, fp80bitRegSaveAreaStore, pointerRegSaveAreaStore, object, 8);
                    fp += 16;
                    continue;
                }
                overflowOffset += LLVMX86_64VaListStorage.storeArgument(overflowArgAreaBaseNativePtr, overflowOffset, memMove, i64OverflowArgAreaStore, i32OverflowArgAreaStore, fp80bitOverflowArgAreaStore, pointerOverflowArgAreaStore, object, 8);
            }
        }
    }

    @ExportLibrary(value=NativeTypeLibrary.class, useForAOT=true, useForAOTPriority=1)
    public static final class RegSaveArea
    extends LLVMVaListStorage.ArgsArea {
        private final int[] gpIdx;
        private final int[] fpIdx;
        private final int numOfExpArgs;
        private int curArg;

        RegSaveArea(Object[] args, int[] gpIdx, int[] fpIdx, int numOfExpArgs) {
            super(args);
            this.gpIdx = gpIdx;
            this.fpIdx = fpIdx;
            this.numOfExpArgs = numOfExpArgs;
        }

        @Override
        protected long offsetToIndex(long offset) {
            if (offset < 0L) {
                return -1L;
            }
            if (offset < 48L) {
                long i = offset / 8L;
                long j = offset % 8L;
                return i >= (long)this.gpIdx.length ? -1L : (long)this.gpIdx[(int)i] + (j << 32);
            }
            assert (offset < 176L);
            long i = (offset - 48L) / 16L;
            long j = (offset - 48L) % 16L;
            return i >= (long)this.fpIdx.length ? -1L : (long)this.fpIdx[(int)i] + (j << 32);
        }

        void shift() {
            ++this.curArg;
        }

        @ExportMessage
        public boolean hasNativeType() {
            return true;
        }

        @ExportMessage
        public Object getNativeType() {
            if (this.curArg < this.numOfExpArgs) {
                this.curArg = this.numOfExpArgs;
            }
            Object arg = this.curArg < this.args.length ? this.args[this.curArg] : null;
            return RegSaveArea.getVarArgType(arg);
        }
    }

    @ExportLibrary(value=NativeTypeLibrary.class, useForAOT=true, useForAOTPriority=1)
    public static final class OverflowArgArea
    extends LLVMVaListStorage.AbstractOverflowArgArea {
        OverflowArgArea(Object[] args, long[] offsets, long overflowAreaSize) {
            super(args, offsets, overflowAreaSize);
        }

        public OverflowArgArea clone() {
            OverflowArgArea cloned = new OverflowArgArea(this.args, this.offsets, this.overflowAreaSize);
            cloned.currentOffset = this.currentOffset;
            return cloned;
        }

        @ExportMessage
        public boolean hasNativeType() {
            return true;
        }

        @ExportMessage
        public Object getNativeType() {
            return OverflowArgArea.getVarArgType(this.getCurrentArg());
        }
    }

    @ExportLibrary(value=LLVMVaListLibrary.class, useForAOT=true, useForAOTPriority=0)
    @ImportStatic(value={LLVMX86_64VaListStorage.class})
    public static final class NativeVAListWrapper {
        final LLVMPointer nativeVAListPtr;

        public NativeVAListWrapper(LLVMPointer nativeVAListPtr) {
            this.nativeVAListPtr = nativeVAListPtr;
        }

        @ExportMessage
        public void initialize(Object[] arguments, int numberOfExplicitArguments, Frame frame, @Cached.Exclusive @Cached LLVMVaListStorage.StackAllocationNode stackAllocationNode, @Cached.Shared(value="gpOffsetStore") @Cached LLVMI32StoreNode.LLVMI32OffsetStoreNode gpOffsetStore, @Cached.Shared(value="fpOffsetStore") @Cached LLVMI32StoreNode.LLVMI32OffsetStoreNode fpOffsetStore, @Cached.Exclusive @Cached LLVMI64StoreNode.LLVMI64OffsetStoreNode i64RegSaveAreaStore, @Cached.Exclusive @Cached LLVMI32StoreNode.LLVMI32OffsetStoreNode i32RegSaveAreaStore, @Cached.Exclusive @Cached LLVM80BitFloatStoreNode.LLVM80BitFloatOffsetStoreNode fp80bitRegSaveAreaStore, @Cached.Exclusive @Cached LLVMPointerStoreNode.LLVMPointerOffsetStoreNode pointerRegSaveAreaStore, @Cached.Exclusive @Cached LLVMI64StoreNode.LLVMI64OffsetStoreNode i64OverflowArgAreaStore, @Cached.Exclusive @Cached LLVMI32StoreNode.LLVMI32OffsetStoreNode i32OverflowArgAreaStore, @Cached.Exclusive @Cached LLVM80BitFloatStoreNode.LLVM80BitFloatOffsetStoreNode fp80bitOverflowArgAreaStore, @Cached.Exclusive @Cached LLVMPointerStoreNode.LLVMPointerOffsetStoreNode pointerOverflowArgAreaStore, @Cached.Shared(value="overflowAreaStore") @Cached LLVMPointerStoreNode.LLVMPointerOffsetStoreNode overflowArgAreaStore, @Cached.Shared(value="regSaveAreaStore") @Cached LLVMPointerStoreNode.LLVMPointerOffsetStoreNode regSaveAreaStore, @Cached NativeProfiledMemMoveToNative memMove) {
            int fp;
            int gp;
            int initGPOffset = gp = LLVMX86_64VaListStorage.calculateUsedGpArea(arguments, numberOfExplicitArguments);
            int initFPOffset = fp = 48 + LLVMX86_64VaListStorage.calculateUsedFpArea(arguments, numberOfExplicitArguments);
            long overflowArea = 0L;
            for (int i = numberOfExplicitArguments; i < arguments.length; ++i) {
                Object arg = arguments[i];
                LLVMVaListStorage.VarArgArea area = LLVMVaListStorage.getVarArgArea(arg);
                if (area == LLVMVaListStorage.VarArgArea.GP_AREA && gp < 48) {
                    gp += 8;
                    continue;
                }
                if (area == LLVMVaListStorage.VarArgArea.FP_AREA && fp < 176) {
                    fp += 16;
                    continue;
                }
                if (area != LLVMVaListStorage.VarArgArea.OVERFLOW_AREA) {
                    overflowArea += 8L;
                    continue;
                }
                if (arg instanceof LLVM80BitFloat) {
                    overflowArea += 16L;
                    continue;
                }
                if (arg instanceof LLVMVarArgCompoundValue) {
                    LLVMVarArgCompoundValue obj = (LLVMVarArgCompoundValue)arg;
                    overflowArea += obj.getSize();
                    continue;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw CompilerDirectives.shouldNotReachHere((String)String.valueOf(arg));
            }
            LLVMNativePointer regSaveAreaNativePtr = LLVMNativePointer.cast(stackAllocationNode.executeWithTarget(176L, frame));
            LLVMNativePointer overflowArgAreaBaseNativePtr = LLVMNativePointer.cast(stackAllocationNode.executeWithTarget(overflowArea, frame));
            LLVMX86_64VaListStorage.initNativeVAList(gpOffsetStore, fpOffsetStore, overflowArgAreaStore, regSaveAreaStore, this.nativeVAListPtr, initGPOffset, initFPOffset, overflowArgAreaBaseNativePtr, regSaveAreaNativePtr);
            LLVMX86_64VaListStorage.initNativeAreas(arguments, numberOfExplicitArguments, initGPOffset, initFPOffset, regSaveAreaNativePtr, overflowArgAreaBaseNativePtr, i64RegSaveAreaStore, i32RegSaveAreaStore, fp80bitRegSaveAreaStore, pointerRegSaveAreaStore, i64OverflowArgAreaStore, i32OverflowArgAreaStore, fp80bitOverflowArgAreaStore, pointerOverflowArgAreaStore, memMove);
        }

        @ExportMessage
        public void cleanup(Frame frame) {
        }

        @ExportMessage
        public Object shift(Type type, Frame frame) {
            throw CompilerDirectives.shouldNotReachHere((String)"TODO");
        }

        @ExportMessage
        @ImportStatic(value={LLVMTypes.class, LLVMX86_64VaListStorage.class})
        static class Copy {
            Copy() {
            }

            @Specialization
            @GenerateAOT.Exclude
            static void copyToManaged(NativeVAListWrapper source, LLVMX86_64VaListStorage dest, Frame frame, @CachedLibrary(limit="1") LLVMVaListLibrary vaListLibrary) {
                vaListLibrary.copy(source, new NativeVAListWrapper(dest.vaListStackPtr), frame);
                dest.nativized = true;
            }

            @Specialization
            static void copyToNative(NativeVAListWrapper source, NativeVAListWrapper dest, Frame frame, @Cached.Shared(value="gpOffsetStore") @Cached LLVMI32StoreNode.LLVMI32OffsetStoreNode gpOffsetStore, @Cached.Shared(value="fpOffsetStore") @Cached LLVMI32StoreNode.LLVMI32OffsetStoreNode fpOffsetStore, @Cached.Shared(value="regSaveAreaStore") @Cached LLVMPointerStoreNode.LLVMPointerOffsetStoreNode regSaveAreaStore, @Cached.Shared(value="overflowAreaStore") @Cached LLVMPointerStoreNode.LLVMPointerOffsetStoreNode overflowAreaStore, @Cached LLVMI32LoadNode.LLVMI32OffsetLoadNode gpOffsetLoad, @Cached LLVMI32LoadNode.LLVMI32OffsetLoadNode fpOffsetLoad, @Cached LLVMPointerLoadNode.LLVMPointerOffsetLoadNode regSaveAreaLoad, @Cached LLVMPointerLoadNode.LLVMPointerOffsetLoadNode overflowAreaLoad) {
                int gp = gpOffsetLoad.executeWithTarget(source.nativeVAListPtr, 0L);
                int fp = fpOffsetLoad.executeWithTarget(source.nativeVAListPtr, 4L);
                LLVMPointer regSaveAreaPtr = regSaveAreaLoad.executeWithTarget(source.nativeVAListPtr, 16L);
                LLVMPointer overflowSaveAreaPtr = overflowAreaLoad.executeWithTarget(source.nativeVAListPtr, 8L);
                LLVMX86_64VaListStorage.initNativeVAList(gpOffsetStore, fpOffsetStore, regSaveAreaStore, overflowAreaStore, dest.nativeVAListPtr, gp, fp, overflowSaveAreaPtr, regSaveAreaPtr);
            }
        }
    }

    @GenerateUncached
    public static abstract class X86_64VAListPointerWrapperFactory
    extends LLVMVaListStorage.VAListPointerWrapperFactory {
        public abstract Object execute(Object var1);

        @Specialization
        protected Object createNativeWrapper(LLVMNativePointer p) {
            return new NativeVAListWrapper(p);
        }

        @Specialization(guards={"!isManagedVAList(p.getObject())"})
        protected Object createManagedWrapper(LLVMManagedPointer p) {
            return new NativeVAListWrapper(p);
        }

        @Specialization(guards={"isManagedVAList(p.getObject())"})
        protected Object createManagedVAListWrapper(LLVMManagedPointer p) {
            return p.getObject();
        }

        static boolean isManagedVAList(Object o) {
            return o instanceof LLVMX86_64VaListStorage;
        }
    }

    @ExportMessage
    static class Copy {
        Copy() {
        }

        @Specialization(guards={"!source.isNativized()"})
        static void copyManaged(LLVMX86_64VaListStorage source, LLVMX86_64VaListStorage dest, Frame frame, @Cached.Shared(value="stackAllocationNode") @Cached LLVMVaListStorage.StackAllocationNode stackAllocationNode) {
            dest.realArguments = source.realArguments;
            dest.numberOfExplicitArguments = source.numberOfExplicitArguments;
            dest.initFPOffset = source.initFPOffset;
            dest.initGPOffset = source.initGPOffset;
            dest.fpOffset = source.fpOffset;
            dest.gpOffset = source.gpOffset;
            dest.regSaveArea = source.regSaveArea;
            dest.regSaveAreaPtr = source.regSaveAreaPtr;
            dest.overflowArgArea = source.overflowArgArea == null ? null : source.overflowArgArea.clone();
            dest.allocateNativeAreas(stackAllocationNode, frame);
        }

        @Specialization(guards={"source.isNativized()"})
        static void copyManagedNativized(LLVMX86_64VaListStorage source, LLVMX86_64VaListStorage dest, Frame frame, @CachedLibrary(limit="1") LLVMManagedReadLibrary srcReadLib, @CachedLibrary(limit="1") LLVMManagedWriteLibrary writeLib, @Cached.Shared(value="stackAllocationNode") @Cached LLVMVaListStorage.StackAllocationNode stackAllocationNode) {
            Copy.copyManaged(source, dest, frame, stackAllocationNode);
            dest.fpOffset = srcReadLib.readI32(source, 4L);
            dest.gpOffset = srcReadLib.readI32(source, 0L);
            LLVMPointer overflowArgArea = srcReadLib.readPointer(source, 8L);
            LLVMPointer regSaveArea = srcReadLib.readPointer(source, 16L);
            dest.nativized = true;
            writeLib.writeI32(dest, 4L, dest.fpOffset);
            writeLib.writeI32(dest, 0L, dest.gpOffset);
            writeLib.writePointer(dest, 8L, overflowArgArea);
            writeLib.writePointer(dest, 16L, regSaveArea);
            if (dest.overflowArgArea != null) {
                dest.overflowArgArea.setOffset(LLVMX86_64VaListStorage.getArgPtrFromNativePtr(source, srcReadLib));
            }
        }

        @Specialization
        @GenerateAOT.Exclude
        static void copyManagedToNative(LLVMX86_64VaListStorage source, NativeVAListWrapper dest, Frame frame, @CachedLibrary(limit="1") LLVMVaListLibrary vaListLibrary) {
            LLVMX86_64VaListStorage dummyClone = new LLVMX86_64VaListStorage(dest.nativeVAListPtr, source.vaListType);
            dummyClone.nativized = true;
            vaListLibrary.initialize(dummyClone, source.realArguments, source.numberOfExplicitArguments, frame);
        }
    }

    @ExportMessage
    static class Initialize {
        Initialize() {
        }

        @Specialization(guards={"!vaList.isNativized()"})
        static void initializeManaged(LLVMX86_64VaListStorage vaList, Object[] realArgs, int numOfExpArgs, Frame frame, @Cached.Shared(value="stackAllocationNode") @Cached LLVMVaListStorage.StackAllocationNode stackAllocationNode) {
            int fp;
            int gp;
            vaList.realArguments = realArgs;
            vaList.numberOfExplicitArguments = numOfExpArgs;
            assert (numOfExpArgs <= realArgs.length);
            vaList.gpOffset = vaList.initGPOffset = (gp = LLVMX86_64VaListStorage.calculateUsedGpArea(realArgs, numOfExpArgs));
            vaList.fpOffset = vaList.initFPOffset = (fp = 48 + LLVMX86_64VaListStorage.calculateUsedFpArea(realArgs, numOfExpArgs));
            int[] gpIdx = new int[realArgs.length];
            Arrays.fill(gpIdx, -1);
            int[] fpIdx = new int[realArgs.length];
            Arrays.fill(fpIdx, -1);
            Object[] overflowArgs = new Object[realArgs.length];
            long[] overflowAreaArgOffsets = new long[realArgs.length];
            Arrays.fill(overflowAreaArgOffsets, -1L);
            int oi = 0;
            long overflowArea = 0L;
            for (int i = numOfExpArgs; i < realArgs.length; ++i) {
                Object arg = realArgs[i];
                LLVMVaListStorage.VarArgArea area = LLVMVaListStorage.getVarArgArea(arg);
                if (area == LLVMVaListStorage.VarArgArea.GP_AREA && gp < 48) {
                    gpIdx[gp / 8] = i;
                    gp += 8;
                    continue;
                }
                if (area == LLVMVaListStorage.VarArgArea.FP_AREA && fp < 176) {
                    fpIdx[(fp - 48) / 16] = i;
                    fp += 16;
                    continue;
                }
                if (area != LLVMVaListStorage.VarArgArea.OVERFLOW_AREA) {
                    overflowAreaArgOffsets[oi] = overflowArea;
                    overflowArea += 8L;
                    overflowArgs[oi++] = arg;
                    continue;
                }
                if (arg instanceof LLVM80BitFloat) {
                    overflowAreaArgOffsets[oi] = overflowArea;
                    overflowArea += 16L;
                    overflowArgs[oi++] = arg;
                    continue;
                }
                if (arg instanceof LLVMVarArgCompoundValue) {
                    overflowAreaArgOffsets[oi] = overflowArea;
                    LLVMVarArgCompoundValue obj = (LLVMVarArgCompoundValue)arg;
                    overflowArea += obj.getSize();
                    overflowArgs[oi++] = arg;
                    continue;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw CompilerDirectives.shouldNotReachHere((String)String.valueOf(arg));
            }
            vaList.regSaveArea = new RegSaveArea(realArgs, gpIdx, fpIdx, numOfExpArgs);
            vaList.regSaveAreaPtr = LLVMManagedPointer.create(vaList.regSaveArea);
            vaList.overflowArgArea = new OverflowArgArea(overflowArgs, overflowAreaArgOffsets, overflowArea);
            vaList.allocateNativeAreas(stackAllocationNode, frame);
        }

        @Specialization(guards={"vaList.isNativized()"})
        static void initializeNativized(LLVMX86_64VaListStorage vaList, Object[] realArgs, int numOfExpArgs, Frame frame, @Cached.Exclusive @Cached LLVMI64StoreNode.LLVMI64OffsetStoreNode i64RegSaveAreaStore, @Cached.Exclusive @Cached LLVMI32StoreNode.LLVMI32OffsetStoreNode i32RegSaveAreaStore, @Cached.Exclusive @Cached LLVM80BitFloatStoreNode.LLVM80BitFloatOffsetStoreNode fp80bitRegSaveAreaStore, @Cached.Exclusive @Cached LLVMPointerStoreNode.LLVMPointerOffsetStoreNode pointerRegSaveAreaStore, @Cached.Exclusive @Cached LLVMI64StoreNode.LLVMI64OffsetStoreNode i64OverflowArgAreaStore, @Cached.Exclusive @Cached LLVMI32StoreNode.LLVMI32OffsetStoreNode i32OverflowArgAreaStore, @Cached.Exclusive @Cached LLVM80BitFloatStoreNode.LLVM80BitFloatOffsetStoreNode fp80bitOverflowArgAreaStore, @Cached.Exclusive @Cached LLVMPointerStoreNode.LLVMPointerOffsetStoreNode pointerOverflowArgAreaStore, @Cached LLVMI32StoreNode.LLVMI32OffsetStoreNode gpOffsetStore, @Cached LLVMI32StoreNode.LLVMI32OffsetStoreNode fpOffsetStore, @Cached LLVMPointerStoreNode.LLVMPointerOffsetStoreNode overflowArgAreaStore, @Cached.Exclusive @Cached LLVMPointerStoreNode.LLVMPointerOffsetStoreNode regSaveAreaStore, @Cached NativeProfiledMemMoveToNative memMove, @Cached.Shared(value="stackAllocationNode") @Cached LLVMVaListStorage.StackAllocationNode stackAllocationNode) {
            Initialize.initializeManaged(vaList, realArgs, numOfExpArgs, frame, stackAllocationNode);
            if (!LLVMNativePointer.isInstance(vaList.regSaveAreaNativePtr) || !LLVMNativePointer.isInstance(vaList.overflowArgAreaBaseNativePtr)) {
                vaList.nativized = false;
                return;
            }
            LLVMX86_64VaListStorage.initNativeVAList(gpOffsetStore, fpOffsetStore, overflowArgAreaStore, regSaveAreaStore, vaList.vaListStackPtr, vaList.gpOffset, vaList.fpOffset, vaList.overflowArgAreaBaseNativePtr.increment(vaList.overflowArgArea.getOffset()), vaList.regSaveAreaNativePtr);
            LLVMX86_64VaListStorage.initNativeAreas(vaList.realArguments, vaList.numberOfExplicitArguments, vaList.initGPOffset, vaList.initFPOffset, LLVMNativePointer.cast(vaList.regSaveAreaNativePtr), LLVMNativePointer.cast(vaList.overflowArgAreaBaseNativePtr), i64RegSaveAreaStore, i32RegSaveAreaStore, fp80bitRegSaveAreaStore, pointerRegSaveAreaStore, i64OverflowArgAreaStore, i32OverflowArgAreaStore, fp80bitOverflowArgAreaStore, pointerOverflowArgAreaStore, memMove);
            vaList.nativized = true;
        }
    }

    @ExportMessage
    static class WritePointer {
        WritePointer() {
        }

        @Specialization(guards={"!vaList.isNativized()"})
        static void writeManaged(LLVMX86_64VaListStorage vaList, long offset, LLVMPointer value, @Cached BranchProfile exception, @CachedLibrary(value="vaList") LLVMManagedWriteLibrary self) {
            switch ((int)offset) {
                case 8: {
                    if (!LLVMManagedPointer.isInstance(value) || LLVMManagedPointer.cast(value).getObject() != vaList.overflowArgArea) {
                        exception.enter();
                        throw new LLVMMemoryException((Node)self, "updates to VA_LIST overflowArea pointer can only shift the current argument");
                    }
                    vaList.overflowArgArea.setOffset(LLVMManagedPointer.cast(value).getOffset());
                    break;
                }
                default: {
                    throw CompilerDirectives.shouldNotReachHere();
                }
            }
        }

        @Specialization(guards={"vaList.isNativized()"})
        @GenerateAOT.Exclude
        static void writeNative(LLVMX86_64VaListStorage vaList, long offset, LLVMPointer value, @Cached LLVMPointerStoreNode.LLVMPointerOffsetStoreNode offsetStore) {
            offsetStore.executeWithTarget(vaList.vaListStackPtr, offset, value);
        }
    }

    @ExportMessage
    static class WriteI32 {
        WriteI32() {
        }

        @Specialization(guards={"!vaList.isNativized()"})
        static void writeManaged(LLVMX86_64VaListStorage vaList, long offset, int value) {
            switch ((int)offset) {
                case 0: {
                    vaList.gpOffset = value;
                    vaList.regSaveArea.shift();
                    break;
                }
                case 4: {
                    vaList.fpOffset = value;
                    vaList.regSaveArea.shift();
                    break;
                }
                default: {
                    throw CompilerDirectives.shouldNotReachHere();
                }
            }
        }

        @Specialization(guards={"vaList.isNativized()"})
        @GenerateAOT.Exclude
        static void writeNative(LLVMX86_64VaListStorage vaList, long offset, int value, @Cached LLVMI32StoreNode.LLVMI32OffsetStoreNode offsetStore) {
            offsetStore.executeWithTarget(vaList.vaListStackPtr, offset, value);
        }
    }

    @ExportMessage
    static class ReadGenericI64 {
        ReadGenericI64() {
        }

        @Specialization(guards={"!vaList.isNativized()"})
        static LLVMPointer readManaged(LLVMX86_64VaListStorage vaList, long offset) {
            switch ((int)offset) {
                case 8: {
                    return vaList.overflowArgArea.getCurrentArgPtr();
                }
                case 16: {
                    return vaList.regSaveAreaPtr;
                }
            }
            throw CompilerDirectives.shouldNotReachHere();
        }

        @Specialization(guards={"vaList.isNativized()"}, rewriteOn={UnexpectedResultException.class})
        @GenerateAOT.Exclude
        static long readNative(LLVMX86_64VaListStorage vaList, long offset, @Cached LLVMI64LoadNode.LLVMI64OffsetLoadNode offsetLoad) throws UnexpectedResultException {
            return offsetLoad.executeWithTarget(vaList.vaListStackPtr, offset);
        }

        @Specialization(guards={"vaList.isNativized()"}, replaces={"readNative"})
        @GenerateAOT.Exclude
        static Object readNativePointer(LLVMX86_64VaListStorage vaList, long offset, @Cached.Shared(value="read") @Cached LLVMPointerLoadNode.LLVMPointerOffsetLoadNode offsetLoad) {
            return offsetLoad.executeWithTarget(vaList.vaListStackPtr, offset);
        }
    }

    @ExportMessage
    static class ReadPointer {
        ReadPointer() {
        }

        @Specialization(guards={"!vaList.isNativized()"})
        static LLVMPointer readManagedPointer(LLVMX86_64VaListStorage vaList, long offset) {
            switch ((int)offset) {
                case 8: {
                    return vaList.overflowArgArea.getCurrentArgPtr();
                }
                case 16: {
                    return vaList.regSaveAreaPtr;
                }
            }
            throw CompilerDirectives.shouldNotReachHere();
        }

        @Specialization(guards={"vaList.isNativized()"})
        @GenerateAOT.Exclude
        static LLVMPointer readNativePointer(LLVMX86_64VaListStorage vaList, long offset, @Cached.Shared(value="read") @Cached LLVMPointerLoadNode.LLVMPointerOffsetLoadNode offsetLoad) {
            return offsetLoad.executeWithTarget(vaList.vaListStackPtr, offset);
        }
    }

    @ExportMessage
    static class ReadI32 {
        ReadI32() {
        }

        @Specialization(guards={"!vaList.isNativized()"})
        static int readManagedI32(LLVMX86_64VaListStorage vaList, long offset) {
            switch ((int)offset) {
                case 0: {
                    return vaList.gpOffset;
                }
                case 4: {
                    return vaList.fpOffset;
                }
            }
            throw CompilerDirectives.shouldNotReachHere();
        }

        @Specialization(guards={"vaList.isNativized()"})
        @GenerateAOT.Exclude
        static int readNativeI32(LLVMX86_64VaListStorage vaList, long offset, @Cached LLVMI32LoadNode.LLVMI32OffsetLoadNode offsetLoad) {
            return offsetLoad.executeWithTarget(vaList.vaListStackPtr, offset);
        }
    }
}

