/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.arith;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.DSLSupport;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypesGen;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.arith.LLVMArithmetic;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI16StoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI32StoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI64StoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI8StoreNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.lang.invoke.VarHandle;
import java.util.concurrent.locks.ReentrantLock;

@GeneratedBy(value=LLVMArithmetic.class)
public final class LLVMArithmeticFactory {

    @GeneratedBy(value=LLVMArithmetic.LLVMArithmeticWithOverflowAndCarry.class)
    public static final class LLVMArithmeticWithOverflowAndCarryNodeGen
    extends LLVMArithmetic.LLVMArithmeticWithOverflowAndCarry
    implements GenerateAOT.Provider {
        @Node.Child
        private LLVMExpressionNode left_;
        @Node.Child
        private LLVMExpressionNode right_;
        @Node.Child
        private LLVMExpressionNode cin_;
        @Node.Child
        private LLVMExpressionNode cout_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;
        @Node.Child
        private Intrinsic0Data intrinsic0_cache;
        @Node.Child
        private Intrinsic1Data intrinsic1_cache;
        @Node.Child
        private Intrinsic2Data intrinsic2_cache;
        @Node.Child
        private Intrinsic3Data intrinsic3_cache;

        private LLVMArithmeticWithOverflowAndCarryNodeGen(LLVMArithmetic.CarryArithmetic arithmetic, LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode cin, LLVMExpressionNode cout) {
            super(arithmetic);
            this.left_ = left;
            this.right_ = right;
            this.cin_ = cin;
            this.cout_ = cout;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0x1C) == 0 && (state_0 & 0x1E) != 0) {
                return this.executeGeneric_byte_byte_byte0(state_0, frameValue);
            }
            if ((state_0 & 0x1A) == 0 && (state_0 & 0x1E) != 0) {
                return this.executeGeneric_short_short_short1(state_0, frameValue);
            }
            if ((state_0 & 0x16) == 0 && (state_0 & 0x1E) != 0) {
                return this.executeGeneric_int_int_int2(state_0, frameValue);
            }
            if ((state_0 & 0xE) == 0 && (state_0 & 0x1E) != 0) {
                return this.executeGeneric_long_long_long3(state_0, frameValue);
            }
            return this.executeGeneric_generic4(state_0, frameValue);
        }

        private Object executeGeneric_byte_byte_byte0(int state_0__, VirtualFrame frameValue) {
            byte cinValue_;
            byte rightValue_;
            byte leftValue_;
            int state_0 = state_0__;
            try {
                leftValue_ = this.left_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightValue = this.right_.executeGeneric(frameValue);
                Object cinValue = this.cin_.executeGeneric(frameValue);
                Object coutValue = this.cout_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), rightValue, cinValue, coutValue);
            }
            try {
                rightValue_ = this.right_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object cinValue = this.cin_.executeGeneric(frameValue);
                Object coutValue = this.cout_.executeGeneric(frameValue);
                return this.executeAndSpecialize(leftValue_, ex.getResult(), cinValue, coutValue);
            }
            try {
                cinValue_ = this.cin_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object coutValue = this.cout_.executeGeneric(frameValue);
                return this.executeAndSpecialize(leftValue_, rightValue_, ex.getResult(), coutValue);
            }
            Object coutValue_ = this.cout_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(leftValue_, rightValue_, cinValue_, coutValue_);
            }
            assert ((state_0 & 2) != 0);
            if (LLVMTypes.isPointer(coutValue_)) {
                LLVMPointer coutValue__ = LLVMTypes.asPointer(coutValue_);
                Intrinsic0Data s0_ = this.intrinsic0_cache;
                if (s0_ != null) {
                    return this.doIntrinsic(leftValue_, rightValue_, cinValue_, coutValue__, s0_.store_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftValue_, rightValue_, cinValue_, coutValue_);
        }

        private Object executeGeneric_short_short_short1(int state_0__, VirtualFrame frameValue) {
            short cinValue_;
            short rightValue_;
            short leftValue_;
            int state_0 = state_0__;
            try {
                leftValue_ = this.left_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightValue = this.right_.executeGeneric(frameValue);
                Object cinValue = this.cin_.executeGeneric(frameValue);
                Object coutValue = this.cout_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), rightValue, cinValue, coutValue);
            }
            try {
                rightValue_ = this.right_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object cinValue = this.cin_.executeGeneric(frameValue);
                Object coutValue = this.cout_.executeGeneric(frameValue);
                return this.executeAndSpecialize(leftValue_, ex.getResult(), cinValue, coutValue);
            }
            try {
                cinValue_ = this.cin_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object coutValue = this.cout_.executeGeneric(frameValue);
                return this.executeAndSpecialize(leftValue_, rightValue_, ex.getResult(), coutValue);
            }
            Object coutValue_ = this.cout_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(leftValue_, rightValue_, cinValue_, coutValue_);
            }
            assert ((state_0 & 4) != 0);
            if (LLVMTypes.isPointer(coutValue_)) {
                LLVMPointer coutValue__ = LLVMTypes.asPointer(coutValue_);
                Intrinsic1Data s1_ = this.intrinsic1_cache;
                if (s1_ != null) {
                    return this.doIntrinsic(leftValue_, rightValue_, cinValue_, coutValue__, s1_.store_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftValue_, rightValue_, cinValue_, coutValue_);
        }

        private Object executeGeneric_int_int_int2(int state_0__, VirtualFrame frameValue) {
            int cinValue_;
            int rightValue_;
            int leftValue_;
            int state_0 = state_0__;
            try {
                leftValue_ = this.left_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightValue = this.right_.executeGeneric(frameValue);
                Object cinValue = this.cin_.executeGeneric(frameValue);
                Object coutValue = this.cout_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), rightValue, cinValue, coutValue);
            }
            try {
                rightValue_ = this.right_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object cinValue = this.cin_.executeGeneric(frameValue);
                Object coutValue = this.cout_.executeGeneric(frameValue);
                return this.executeAndSpecialize(leftValue_, ex.getResult(), cinValue, coutValue);
            }
            try {
                cinValue_ = this.cin_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object coutValue = this.cout_.executeGeneric(frameValue);
                return this.executeAndSpecialize(leftValue_, rightValue_, ex.getResult(), coutValue);
            }
            Object coutValue_ = this.cout_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(leftValue_, rightValue_, cinValue_, coutValue_);
            }
            assert ((state_0 & 8) != 0);
            if (LLVMTypes.isPointer(coutValue_)) {
                LLVMPointer coutValue__ = LLVMTypes.asPointer(coutValue_);
                Intrinsic2Data s2_ = this.intrinsic2_cache;
                if (s2_ != null) {
                    return this.doIntrinsic(leftValue_, rightValue_, cinValue_, coutValue__, s2_.store_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftValue_, rightValue_, cinValue_, coutValue_);
        }

        private Object executeGeneric_long_long_long3(int state_0__, VirtualFrame frameValue) {
            long cinValue_;
            long rightValue_;
            long leftValue_;
            int state_0 = state_0__;
            try {
                leftValue_ = this.left_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightValue = this.right_.executeGeneric(frameValue);
                Object cinValue = this.cin_.executeGeneric(frameValue);
                Object coutValue = this.cout_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), rightValue, cinValue, coutValue);
            }
            try {
                rightValue_ = this.right_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object cinValue = this.cin_.executeGeneric(frameValue);
                Object coutValue = this.cout_.executeGeneric(frameValue);
                return this.executeAndSpecialize(leftValue_, ex.getResult(), cinValue, coutValue);
            }
            try {
                cinValue_ = this.cin_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object coutValue = this.cout_.executeGeneric(frameValue);
                return this.executeAndSpecialize(leftValue_, rightValue_, ex.getResult(), coutValue);
            }
            Object coutValue_ = this.cout_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(leftValue_, rightValue_, cinValue_, coutValue_);
            }
            assert ((state_0 & 0x10) != 0);
            if (LLVMTypes.isPointer(coutValue_)) {
                LLVMPointer coutValue__ = LLVMTypes.asPointer(coutValue_);
                Intrinsic3Data s3_ = this.intrinsic3_cache;
                if (s3_ != null) {
                    return this.doIntrinsic(leftValue_, rightValue_, cinValue_, coutValue__, s3_.store_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftValue_, rightValue_, cinValue_, coutValue_);
        }

        private Object executeGeneric_generic4(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object leftValue_ = this.left_.executeGeneric(frameValue);
            Object rightValue_ = this.right_.executeGeneric(frameValue);
            Object cinValue_ = this.cin_.executeGeneric(frameValue);
            Object coutValue_ = this.cout_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(leftValue_, rightValue_, cinValue_, coutValue_);
            }
            if ((state_0 & 0x1E) != 0 && LLVMTypes.isPointer(coutValue_)) {
                LLVMPointer coutValue__ = LLVMTypes.asPointer(coutValue_);
                if ((state_0 & 2) != 0 && leftValue_ instanceof Byte) {
                    byte by = (Byte)leftValue_;
                    if (rightValue_ instanceof Byte) {
                        byte by2 = (Byte)rightValue_;
                        if (cinValue_ instanceof Byte) {
                            byte by3 = (Byte)cinValue_;
                            Intrinsic0Data s0_ = this.intrinsic0_cache;
                            if (s0_ != null) {
                                return this.doIntrinsic(by, by2, by3, coutValue__, s0_.store_);
                            }
                        }
                    }
                }
                if ((state_0 & 4) != 0 && leftValue_ instanceof Short) {
                    short s = (Short)leftValue_;
                    if (rightValue_ instanceof Short) {
                        short s2 = (Short)rightValue_;
                        if (cinValue_ instanceof Short) {
                            short s3 = (Short)cinValue_;
                            Intrinsic1Data s1_ = this.intrinsic1_cache;
                            if (s1_ != null) {
                                return this.doIntrinsic(s, s2, s3, coutValue__, s1_.store_);
                            }
                        }
                    }
                }
                if ((state_0 & 8) != 0 && leftValue_ instanceof Integer) {
                    int n = (Integer)leftValue_;
                    if (rightValue_ instanceof Integer) {
                        int n2 = (Integer)rightValue_;
                        if (cinValue_ instanceof Integer) {
                            int n3 = (Integer)cinValue_;
                            Intrinsic2Data s2_ = this.intrinsic2_cache;
                            if (s2_ != null) {
                                return this.doIntrinsic(n, n2, n3, coutValue__, s2_.store_);
                            }
                        }
                    }
                }
                if ((state_0 & 0x10) != 0 && leftValue_ instanceof Long) {
                    long l = (Long)leftValue_;
                    if (rightValue_ instanceof Long) {
                        long l2 = (Long)rightValue_;
                        if (cinValue_ instanceof Long) {
                            long cinValue__2 = (Long)cinValue_;
                            Intrinsic3Data s3_ = this.intrinsic3_cache;
                            if (s3_ != null) {
                                return this.doIntrinsic(l, l2, cinValue__2, coutValue__, s3_.store_);
                            }
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftValue_, rightValue_, cinValue_, coutValue_);
        }

        @Override
        public byte executeI8(VirtualFrame frameValue) throws UnexpectedResultException {
            byte cinValue_;
            byte rightValue_;
            byte leftValue_;
            int state_0 = this.state_0_;
            try {
                leftValue_ = this.left_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightValue = this.right_.executeGeneric(frameValue);
                Object cinValue = this.cin_.executeGeneric(frameValue);
                Object coutValue = this.cout_.executeGeneric(frameValue);
                return LLVMTypesGen.expectByte(this.executeAndSpecialize(ex.getResult(), rightValue, cinValue, coutValue));
            }
            try {
                rightValue_ = this.right_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object cinValue = this.cin_.executeGeneric(frameValue);
                Object coutValue = this.cout_.executeGeneric(frameValue);
                return LLVMTypesGen.expectByte(this.executeAndSpecialize(leftValue_, ex.getResult(), cinValue, coutValue));
            }
            try {
                cinValue_ = this.cin_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object coutValue = this.cout_.executeGeneric(frameValue);
                return LLVMTypesGen.expectByte(this.executeAndSpecialize(leftValue_, rightValue_, ex.getResult(), coutValue));
            }
            Object coutValue_ = this.cout_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return LLVMTypesGen.expectByte(this.executeAndSpecialize(leftValue_, rightValue_, cinValue_, coutValue_));
            }
            if ((state_0 & 2) != 0 && LLVMTypes.isPointer(coutValue_)) {
                LLVMPointer coutValue__ = LLVMTypes.asPointer(coutValue_);
                Intrinsic0Data s0_ = this.intrinsic0_cache;
                if (s0_ != null) {
                    return this.doIntrinsic(leftValue_, rightValue_, cinValue_, coutValue__, s0_.store_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectByte(this.executeAndSpecialize(leftValue_, rightValue_, cinValue_, coutValue_));
        }

        @Override
        public int executeI32(VirtualFrame frameValue) throws UnexpectedResultException {
            int cinValue_;
            int rightValue_;
            int leftValue_;
            int state_0 = this.state_0_;
            try {
                leftValue_ = this.left_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightValue = this.right_.executeGeneric(frameValue);
                Object cinValue = this.cin_.executeGeneric(frameValue);
                Object coutValue = this.cout_.executeGeneric(frameValue);
                return LLVMTypesGen.expectInteger(this.executeAndSpecialize(ex.getResult(), rightValue, cinValue, coutValue));
            }
            try {
                rightValue_ = this.right_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object cinValue = this.cin_.executeGeneric(frameValue);
                Object coutValue = this.cout_.executeGeneric(frameValue);
                return LLVMTypesGen.expectInteger(this.executeAndSpecialize(leftValue_, ex.getResult(), cinValue, coutValue));
            }
            try {
                cinValue_ = this.cin_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object coutValue = this.cout_.executeGeneric(frameValue);
                return LLVMTypesGen.expectInteger(this.executeAndSpecialize(leftValue_, rightValue_, ex.getResult(), coutValue));
            }
            Object coutValue_ = this.cout_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return LLVMTypesGen.expectInteger(this.executeAndSpecialize(leftValue_, rightValue_, cinValue_, coutValue_));
            }
            if ((state_0 & 8) != 0 && LLVMTypes.isPointer(coutValue_)) {
                LLVMPointer coutValue__ = LLVMTypes.asPointer(coutValue_);
                Intrinsic2Data s2_ = this.intrinsic2_cache;
                if (s2_ != null) {
                    return this.doIntrinsic(leftValue_, rightValue_, cinValue_, coutValue__, s2_.store_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectInteger(this.executeAndSpecialize(leftValue_, rightValue_, cinValue_, coutValue_));
        }

        @Override
        public long executeI64(VirtualFrame frameValue) throws UnexpectedResultException {
            long cinValue_;
            long rightValue_;
            long leftValue_;
            int state_0 = this.state_0_;
            try {
                leftValue_ = this.left_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightValue = this.right_.executeGeneric(frameValue);
                Object cinValue = this.cin_.executeGeneric(frameValue);
                Object coutValue = this.cout_.executeGeneric(frameValue);
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(ex.getResult(), rightValue, cinValue, coutValue));
            }
            try {
                rightValue_ = this.right_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object cinValue = this.cin_.executeGeneric(frameValue);
                Object coutValue = this.cout_.executeGeneric(frameValue);
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(leftValue_, ex.getResult(), cinValue, coutValue));
            }
            try {
                cinValue_ = this.cin_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object coutValue = this.cout_.executeGeneric(frameValue);
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(leftValue_, rightValue_, ex.getResult(), coutValue));
            }
            Object coutValue_ = this.cout_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(leftValue_, rightValue_, cinValue_, coutValue_));
            }
            if ((state_0 & 0x10) != 0 && LLVMTypes.isPointer(coutValue_)) {
                LLVMPointer coutValue__ = LLVMTypes.asPointer(coutValue_);
                Intrinsic3Data s3_ = this.intrinsic3_cache;
                if (s3_ != null) {
                    return this.doIntrinsic(leftValue_, rightValue_, cinValue_, coutValue__, s3_.store_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectLong(this.executeAndSpecialize(leftValue_, rightValue_, cinValue_, coutValue_));
        }

        @Override
        public short executeI16(VirtualFrame frameValue) throws UnexpectedResultException {
            short cinValue_;
            short rightValue_;
            short leftValue_;
            int state_0 = this.state_0_;
            try {
                leftValue_ = this.left_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightValue = this.right_.executeGeneric(frameValue);
                Object cinValue = this.cin_.executeGeneric(frameValue);
                Object coutValue = this.cout_.executeGeneric(frameValue);
                return LLVMTypesGen.expectShort(this.executeAndSpecialize(ex.getResult(), rightValue, cinValue, coutValue));
            }
            try {
                rightValue_ = this.right_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object cinValue = this.cin_.executeGeneric(frameValue);
                Object coutValue = this.cout_.executeGeneric(frameValue);
                return LLVMTypesGen.expectShort(this.executeAndSpecialize(leftValue_, ex.getResult(), cinValue, coutValue));
            }
            try {
                cinValue_ = this.cin_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object coutValue = this.cout_.executeGeneric(frameValue);
                return LLVMTypesGen.expectShort(this.executeAndSpecialize(leftValue_, rightValue_, ex.getResult(), coutValue));
            }
            Object coutValue_ = this.cout_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return LLVMTypesGen.expectShort(this.executeAndSpecialize(leftValue_, rightValue_, cinValue_, coutValue_));
            }
            if ((state_0 & 4) != 0 && LLVMTypes.isPointer(coutValue_)) {
                LLVMPointer coutValue__ = LLVMTypes.asPointer(coutValue_);
                Intrinsic1Data s1_ = this.intrinsic1_cache;
                if (s1_ != null) {
                    return this.doIntrinsic(leftValue_, rightValue_, cinValue_, coutValue__, s1_.store_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectShort(this.executeAndSpecialize(leftValue_, rightValue_, cinValue_, coutValue_));
        }

        private Object executeAndSpecialize(Object leftValue, Object rightValue, Object cinValue, Object coutValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (LLVMTypes.isPointer(coutValue)) {
                LLVMPointer coutValue_ = LLVMTypes.asPointer(coutValue);
                if (leftValue instanceof Byte) {
                    byte by = (Byte)leftValue;
                    if (rightValue instanceof Byte) {
                        byte by2 = (Byte)rightValue;
                        if (cinValue instanceof Byte) {
                            byte cinValue_ = (Byte)cinValue;
                            Intrinsic0Data s0_ = (Intrinsic0Data)this.insert(new Intrinsic0Data());
                            s0_.store_ = (LLVMI8StoreNode)s0_.insert(LLVMI8StoreNode.create());
                            VarHandle.storeStoreFence();
                            this.intrinsic0_cache = s0_;
                            this.state_0_ = state_0 |= 2;
                            return this.doIntrinsic(by, by2, cinValue_, coutValue_, s0_.store_);
                        }
                    }
                }
                if (leftValue instanceof Short) {
                    short s = (Short)leftValue;
                    if (rightValue instanceof Short) {
                        short s2 = (Short)rightValue;
                        if (cinValue instanceof Short) {
                            short cinValue_ = (Short)cinValue;
                            Intrinsic1Data s1_ = (Intrinsic1Data)this.insert(new Intrinsic1Data());
                            s1_.store_ = (LLVMI16StoreNode)s1_.insert(LLVMI16StoreNode.create());
                            VarHandle.storeStoreFence();
                            this.intrinsic1_cache = s1_;
                            this.state_0_ = state_0 |= 4;
                            return this.doIntrinsic(s, s2, cinValue_, coutValue_, s1_.store_);
                        }
                    }
                }
                if (leftValue instanceof Integer) {
                    int n = (Integer)leftValue;
                    if (rightValue instanceof Integer) {
                        int n2 = (Integer)rightValue;
                        if (cinValue instanceof Integer) {
                            int cinValue_ = (Integer)cinValue;
                            Intrinsic2Data s2_ = (Intrinsic2Data)this.insert(new Intrinsic2Data());
                            s2_.store_ = (LLVMI32StoreNode)s2_.insert(LLVMI32StoreNode.create());
                            VarHandle.storeStoreFence();
                            this.intrinsic2_cache = s2_;
                            this.state_0_ = state_0 |= 8;
                            return this.doIntrinsic(n, n2, cinValue_, coutValue_, s2_.store_);
                        }
                    }
                }
                if (leftValue instanceof Long) {
                    long l = (Long)leftValue;
                    if (rightValue instanceof Long) {
                        long rightValue_2 = (Long)rightValue;
                        if (cinValue instanceof Long) {
                            long cinValue_ = (Long)cinValue;
                            Intrinsic3Data s3_ = (Intrinsic3Data)this.insert(new Intrinsic3Data());
                            s3_.store_ = (LLVMI64StoreNode)s3_.insert(LLVMI64StoreNode.create());
                            VarHandle.storeStoreFence();
                            this.intrinsic3_cache = s3_;
                            this.state_0_ = state_0 |= 0x10;
                            return this.doIntrinsic(l, rightValue_2, cinValue_, coutValue_, s3_.store_);
                        }
                    }
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.left_, this.right_, this.cin_, this.cout_}, new Object[]{leftValue, rightValue, cinValue, coutValue});
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            Intrinsic0Data s0_ = (Intrinsic0Data)this.insert(new Intrinsic0Data());
            s0_.store_ = (LLVMI8StoreNode)s0_.insert(LLVMI8StoreNode.create());
            VarHandle.storeStoreFence();
            this.intrinsic0_cache = s0_;
            assert (NodeUtil.assertRecursion((Node)s0_.store_, (int)1));
            ((GenerateAOT.Provider)s0_.store_).prepareForAOT(language, root);
            this.state_0_ |= 2;
            Intrinsic1Data s1_ = (Intrinsic1Data)this.insert(new Intrinsic1Data());
            s1_.store_ = (LLVMI16StoreNode)s1_.insert(LLVMI16StoreNode.create());
            VarHandle.storeStoreFence();
            this.intrinsic1_cache = s1_;
            assert (NodeUtil.assertRecursion((Node)s1_.store_, (int)1));
            ((GenerateAOT.Provider)s1_.store_).prepareForAOT(language, root);
            this.state_0_ |= 4;
            Intrinsic2Data s2_ = (Intrinsic2Data)this.insert(new Intrinsic2Data());
            s2_.store_ = (LLVMI32StoreNode)s2_.insert(LLVMI32StoreNode.create());
            VarHandle.storeStoreFence();
            this.intrinsic2_cache = s2_;
            assert (NodeUtil.assertRecursion((Node)s2_.store_, (int)1));
            ((GenerateAOT.Provider)s2_.store_).prepareForAOT(language, root);
            this.state_0_ |= 8;
            Intrinsic3Data s3_ = (Intrinsic3Data)this.insert(new Intrinsic3Data());
            s3_.store_ = (LLVMI64StoreNode)s3_.insert(LLVMI64StoreNode.create());
            VarHandle.storeStoreFence();
            this.intrinsic3_cache = s3_;
            assert (NodeUtil.assertRecursion((Node)s3_.store_, (int)1));
            ((GenerateAOT.Provider)s3_.store_).prepareForAOT(language, root);
            this.state_0_ |= 0x10;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
            this.intrinsic0_cache = null;
            this.intrinsic1_cache = null;
            this.intrinsic2_cache = null;
            this.intrinsic3_cache = null;
        }

        @NeverDefault
        public static LLVMArithmetic.LLVMArithmeticWithOverflowAndCarry create(LLVMArithmetic.CarryArithmetic arithmetic, LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode cin, LLVMExpressionNode cout) {
            return new LLVMArithmeticWithOverflowAndCarryNodeGen(arithmetic, left, right, cin, cout);
        }

        @GeneratedBy(value=LLVMArithmetic.LLVMArithmeticWithOverflowAndCarry.class)
        @DenyReplace
        private static final class Intrinsic0Data
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @Node.Child
            LLVMI8StoreNode store_;

            Intrinsic0Data() {
            }
        }

        @GeneratedBy(value=LLVMArithmetic.LLVMArithmeticWithOverflowAndCarry.class)
        @DenyReplace
        private static final class Intrinsic1Data
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @Node.Child
            LLVMI16StoreNode store_;

            Intrinsic1Data() {
            }
        }

        @GeneratedBy(value=LLVMArithmetic.LLVMArithmeticWithOverflowAndCarry.class)
        @DenyReplace
        private static final class Intrinsic2Data
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @Node.Child
            LLVMI32StoreNode store_;

            Intrinsic2Data() {
            }
        }

        @GeneratedBy(value=LLVMArithmetic.LLVMArithmeticWithOverflowAndCarry.class)
        @DenyReplace
        private static final class Intrinsic3Data
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @Node.Child
            LLVMI64StoreNode store_;

            Intrinsic3Data() {
            }
        }
    }

    @GeneratedBy(value=LLVMArithmetic.LLVMArithmeticWithOverflow.class)
    public static final class LLVMArithmeticWithOverflowNodeGen
    extends LLVMArithmetic.LLVMArithmeticWithOverflow
    implements GenerateAOT.Provider {
        @Node.Child
        private LLVMExpressionNode left_;
        @Node.Child
        private LLVMExpressionNode right_;
        @Node.Child
        private LLVMExpressionNode target_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;
        @Node.Child
        private Intrinsic0Data intrinsic0_cache;
        @Node.Child
        private Intrinsic1Data intrinsic1_cache;
        @Node.Child
        private Intrinsic2Data intrinsic2_cache;
        @Node.Child
        private Intrinsic3Data intrinsic3_cache;

        private LLVMArithmeticWithOverflowNodeGen(LLVMArithmetic.Arithmetic arithmetic, long secondValueOffset, LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode target) {
            super(arithmetic, secondValueOffset);
            this.left_ = left;
            this.right_ = right;
            this.target_ = target;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0x1C) == 0 && (state_0 & 0x1E) != 0) {
                return this.executeGeneric_byte_byte0(state_0, frameValue);
            }
            if ((state_0 & 0x1A) == 0 && (state_0 & 0x1E) != 0) {
                return this.executeGeneric_short_short1(state_0, frameValue);
            }
            if ((state_0 & 0x16) == 0 && (state_0 & 0x1E) != 0) {
                return this.executeGeneric_int_int2(state_0, frameValue);
            }
            if ((state_0 & 0xE) == 0 && (state_0 & 0x1E) != 0) {
                return this.executeGeneric_long_long3(state_0, frameValue);
            }
            return this.executeGeneric_generic4(state_0, frameValue);
        }

        private Object executeGeneric_byte_byte0(int state_0__, VirtualFrame frameValue) {
            byte rightValue_;
            byte leftValue_;
            int state_0 = state_0__;
            try {
                leftValue_ = this.left_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightValue = this.right_.executeGeneric(frameValue);
                Object targetValue = this.target_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), rightValue, targetValue);
            }
            try {
                rightValue_ = this.right_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object targetValue = this.target_.executeGeneric(frameValue);
                return this.executeAndSpecialize(leftValue_, ex.getResult(), targetValue);
            }
            Object targetValue_ = this.target_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(leftValue_, rightValue_, targetValue_);
            }
            assert ((state_0 & 2) != 0);
            if (LLVMTypes.isPointer(targetValue_)) {
                LLVMPointer targetValue__ = LLVMTypes.asPointer(targetValue_);
                Intrinsic0Data s0_ = this.intrinsic0_cache;
                if (s0_ != null) {
                    return this.doIntrinsic(leftValue_, rightValue_, targetValue__, s0_.store_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftValue_, rightValue_, targetValue_);
        }

        private Object executeGeneric_short_short1(int state_0__, VirtualFrame frameValue) {
            short rightValue_;
            short leftValue_;
            int state_0 = state_0__;
            try {
                leftValue_ = this.left_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightValue = this.right_.executeGeneric(frameValue);
                Object targetValue = this.target_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), rightValue, targetValue);
            }
            try {
                rightValue_ = this.right_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object targetValue = this.target_.executeGeneric(frameValue);
                return this.executeAndSpecialize(leftValue_, ex.getResult(), targetValue);
            }
            Object targetValue_ = this.target_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(leftValue_, rightValue_, targetValue_);
            }
            assert ((state_0 & 4) != 0);
            if (LLVMTypes.isPointer(targetValue_)) {
                LLVMPointer targetValue__ = LLVMTypes.asPointer(targetValue_);
                Intrinsic1Data s1_ = this.intrinsic1_cache;
                if (s1_ != null) {
                    return this.doIntrinsic(leftValue_, rightValue_, targetValue__, s1_.store_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftValue_, rightValue_, targetValue_);
        }

        private Object executeGeneric_int_int2(int state_0__, VirtualFrame frameValue) {
            int rightValue_;
            int leftValue_;
            int state_0 = state_0__;
            try {
                leftValue_ = this.left_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightValue = this.right_.executeGeneric(frameValue);
                Object targetValue = this.target_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), rightValue, targetValue);
            }
            try {
                rightValue_ = this.right_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object targetValue = this.target_.executeGeneric(frameValue);
                return this.executeAndSpecialize(leftValue_, ex.getResult(), targetValue);
            }
            Object targetValue_ = this.target_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(leftValue_, rightValue_, targetValue_);
            }
            assert ((state_0 & 8) != 0);
            if (LLVMTypes.isPointer(targetValue_)) {
                LLVMPointer targetValue__ = LLVMTypes.asPointer(targetValue_);
                Intrinsic2Data s2_ = this.intrinsic2_cache;
                if (s2_ != null) {
                    return this.doIntrinsic(leftValue_, rightValue_, targetValue__, s2_.store_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftValue_, rightValue_, targetValue_);
        }

        private Object executeGeneric_long_long3(int state_0__, VirtualFrame frameValue) {
            long rightValue_;
            long leftValue_;
            int state_0 = state_0__;
            try {
                leftValue_ = this.left_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightValue = this.right_.executeGeneric(frameValue);
                Object targetValue = this.target_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), rightValue, targetValue);
            }
            try {
                rightValue_ = this.right_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object targetValue = this.target_.executeGeneric(frameValue);
                return this.executeAndSpecialize(leftValue_, ex.getResult(), targetValue);
            }
            Object targetValue_ = this.target_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(leftValue_, rightValue_, targetValue_);
            }
            assert ((state_0 & 0x10) != 0);
            if (LLVMTypes.isPointer(targetValue_)) {
                LLVMPointer targetValue__ = LLVMTypes.asPointer(targetValue_);
                Intrinsic3Data s3_ = this.intrinsic3_cache;
                if (s3_ != null) {
                    return this.doIntrinsic(leftValue_, rightValue_, targetValue__, s3_.store_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftValue_, rightValue_, targetValue_);
        }

        private Object executeGeneric_generic4(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object leftValue_ = this.left_.executeGeneric(frameValue);
            Object rightValue_ = this.right_.executeGeneric(frameValue);
            Object targetValue_ = this.target_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(leftValue_, rightValue_, targetValue_);
            }
            if ((state_0 & 0x1E) != 0 && LLVMTypes.isPointer(targetValue_)) {
                LLVMPointer targetValue__ = LLVMTypes.asPointer(targetValue_);
                if ((state_0 & 2) != 0 && leftValue_ instanceof Byte) {
                    byte by = (Byte)leftValue_;
                    if (rightValue_ instanceof Byte) {
                        byte by2 = (Byte)rightValue_;
                        Intrinsic0Data s0_ = this.intrinsic0_cache;
                        if (s0_ != null) {
                            return this.doIntrinsic(by, by2, targetValue__, s0_.store_);
                        }
                    }
                }
                if ((state_0 & 4) != 0 && leftValue_ instanceof Short) {
                    short s = (Short)leftValue_;
                    if (rightValue_ instanceof Short) {
                        short s2 = (Short)rightValue_;
                        Intrinsic1Data s1_ = this.intrinsic1_cache;
                        if (s1_ != null) {
                            return this.doIntrinsic(s, s2, targetValue__, s1_.store_);
                        }
                    }
                }
                if ((state_0 & 8) != 0 && leftValue_ instanceof Integer) {
                    int n = (Integer)leftValue_;
                    if (rightValue_ instanceof Integer) {
                        int n2 = (Integer)rightValue_;
                        Intrinsic2Data s2_ = this.intrinsic2_cache;
                        if (s2_ != null) {
                            return this.doIntrinsic(n, n2, targetValue__, s2_.store_);
                        }
                    }
                }
                if ((state_0 & 0x10) != 0 && leftValue_ instanceof Long) {
                    long l = (Long)leftValue_;
                    if (rightValue_ instanceof Long) {
                        long rightValue__2 = (Long)rightValue_;
                        Intrinsic3Data s3_ = this.intrinsic3_cache;
                        if (s3_ != null) {
                            return this.doIntrinsic(l, rightValue__2, targetValue__, s3_.store_);
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftValue_, rightValue_, targetValue_);
        }

        private Object executeAndSpecialize(Object leftValue, Object rightValue, Object targetValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (LLVMTypes.isPointer(targetValue)) {
                LLVMPointer targetValue_ = LLVMTypes.asPointer(targetValue);
                if (leftValue instanceof Byte) {
                    byte by = (Byte)leftValue;
                    if (rightValue instanceof Byte) {
                        byte rightValue_ = (Byte)rightValue;
                        Intrinsic0Data s0_ = (Intrinsic0Data)this.insert(new Intrinsic0Data());
                        s0_.store_ = (LLVMI8StoreNode)s0_.insert(LLVMI8StoreNode.create());
                        VarHandle.storeStoreFence();
                        this.intrinsic0_cache = s0_;
                        this.state_0_ = state_0 |= 2;
                        return this.doIntrinsic(by, rightValue_, targetValue_, s0_.store_);
                    }
                }
                if (leftValue instanceof Short) {
                    short s = (Short)leftValue;
                    if (rightValue instanceof Short) {
                        short rightValue_ = (Short)rightValue;
                        Intrinsic1Data s1_ = (Intrinsic1Data)this.insert(new Intrinsic1Data());
                        s1_.store_ = (LLVMI16StoreNode)s1_.insert(LLVMI16StoreNode.create());
                        VarHandle.storeStoreFence();
                        this.intrinsic1_cache = s1_;
                        this.state_0_ = state_0 |= 4;
                        return this.doIntrinsic(s, rightValue_, targetValue_, s1_.store_);
                    }
                }
                if (leftValue instanceof Integer) {
                    int n = (Integer)leftValue;
                    if (rightValue instanceof Integer) {
                        int rightValue_ = (Integer)rightValue;
                        Intrinsic2Data s2_ = (Intrinsic2Data)this.insert(new Intrinsic2Data());
                        s2_.store_ = (LLVMI32StoreNode)s2_.insert(LLVMI32StoreNode.create());
                        VarHandle.storeStoreFence();
                        this.intrinsic2_cache = s2_;
                        this.state_0_ = state_0 |= 8;
                        return this.doIntrinsic(n, rightValue_, targetValue_, s2_.store_);
                    }
                }
                if (leftValue instanceof Long) {
                    long l = (Long)leftValue;
                    if (rightValue instanceof Long) {
                        long rightValue_ = (Long)rightValue;
                        Intrinsic3Data s3_ = (Intrinsic3Data)this.insert(new Intrinsic3Data());
                        s3_.store_ = (LLVMI64StoreNode)s3_.insert(LLVMI64StoreNode.create());
                        VarHandle.storeStoreFence();
                        this.intrinsic3_cache = s3_;
                        this.state_0_ = state_0 |= 0x10;
                        return this.doIntrinsic(l, rightValue_, targetValue_, s3_.store_);
                    }
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.left_, this.right_, this.target_}, new Object[]{leftValue, rightValue, targetValue});
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            Intrinsic0Data s0_ = (Intrinsic0Data)this.insert(new Intrinsic0Data());
            s0_.store_ = (LLVMI8StoreNode)s0_.insert(LLVMI8StoreNode.create());
            VarHandle.storeStoreFence();
            this.intrinsic0_cache = s0_;
            assert (NodeUtil.assertRecursion((Node)s0_.store_, (int)1));
            ((GenerateAOT.Provider)s0_.store_).prepareForAOT(language, root);
            this.state_0_ |= 2;
            Intrinsic1Data s1_ = (Intrinsic1Data)this.insert(new Intrinsic1Data());
            s1_.store_ = (LLVMI16StoreNode)s1_.insert(LLVMI16StoreNode.create());
            VarHandle.storeStoreFence();
            this.intrinsic1_cache = s1_;
            assert (NodeUtil.assertRecursion((Node)s1_.store_, (int)1));
            ((GenerateAOT.Provider)s1_.store_).prepareForAOT(language, root);
            this.state_0_ |= 4;
            Intrinsic2Data s2_ = (Intrinsic2Data)this.insert(new Intrinsic2Data());
            s2_.store_ = (LLVMI32StoreNode)s2_.insert(LLVMI32StoreNode.create());
            VarHandle.storeStoreFence();
            this.intrinsic2_cache = s2_;
            assert (NodeUtil.assertRecursion((Node)s2_.store_, (int)1));
            ((GenerateAOT.Provider)s2_.store_).prepareForAOT(language, root);
            this.state_0_ |= 8;
            Intrinsic3Data s3_ = (Intrinsic3Data)this.insert(new Intrinsic3Data());
            s3_.store_ = (LLVMI64StoreNode)s3_.insert(LLVMI64StoreNode.create());
            VarHandle.storeStoreFence();
            this.intrinsic3_cache = s3_;
            assert (NodeUtil.assertRecursion((Node)s3_.store_, (int)1));
            ((GenerateAOT.Provider)s3_.store_).prepareForAOT(language, root);
            this.state_0_ |= 0x10;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
            this.intrinsic0_cache = null;
            this.intrinsic1_cache = null;
            this.intrinsic2_cache = null;
            this.intrinsic3_cache = null;
        }

        @NeverDefault
        public static LLVMArithmetic.LLVMArithmeticWithOverflow create(LLVMArithmetic.Arithmetic arithmetic, long secondValueOffset, LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode target) {
            return new LLVMArithmeticWithOverflowNodeGen(arithmetic, secondValueOffset, left, right, target);
        }

        @GeneratedBy(value=LLVMArithmetic.LLVMArithmeticWithOverflow.class)
        @DenyReplace
        private static final class Intrinsic0Data
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @Node.Child
            LLVMI8StoreNode store_;

            Intrinsic0Data() {
            }
        }

        @GeneratedBy(value=LLVMArithmetic.LLVMArithmeticWithOverflow.class)
        @DenyReplace
        private static final class Intrinsic1Data
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @Node.Child
            LLVMI16StoreNode store_;

            Intrinsic1Data() {
            }
        }

        @GeneratedBy(value=LLVMArithmetic.LLVMArithmeticWithOverflow.class)
        @DenyReplace
        private static final class Intrinsic2Data
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @Node.Child
            LLVMI32StoreNode store_;

            Intrinsic2Data() {
            }
        }

        @GeneratedBy(value=LLVMArithmetic.LLVMArithmeticWithOverflow.class)
        @DenyReplace
        private static final class Intrinsic3Data
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @Node.Child
            LLVMI64StoreNode store_;

            Intrinsic3Data() {
            }
        }
    }

    @GeneratedBy(value=LLVMArithmetic.LLVMSimpleArithmeticPrimitive.class)
    public static final class LLVMSimpleArithmeticPrimitiveNodeGen
    extends LLVMArithmetic.LLVMSimpleArithmeticPrimitive
    implements GenerateAOT.Provider {
        @Node.Child
        private LLVMExpressionNode left_;
        @Node.Child
        private LLVMExpressionNode right_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private LLVMSimpleArithmeticPrimitiveNodeGen(LLVMArithmetic.SaturatingArithmetic arithmetic, LLVMExpressionNode left, LLVMExpressionNode right) {
            super(arithmetic);
            this.left_ = left;
            this.right_ = right;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0x1C) == 0 && (state_0 & 0x1E) != 0) {
                return this.executeGeneric_byte_byte0(state_0, frameValue);
            }
            if ((state_0 & 0x1A) == 0 && (state_0 & 0x1E) != 0) {
                return this.executeGeneric_short_short1(state_0, frameValue);
            }
            if ((state_0 & 0x16) == 0 && (state_0 & 0x1E) != 0) {
                return this.executeGeneric_int_int2(state_0, frameValue);
            }
            if ((state_0 & 0xE) == 0 && (state_0 & 0x1E) != 0) {
                return this.executeGeneric_long_long3(state_0, frameValue);
            }
            return this.executeGeneric_generic4(state_0, frameValue);
        }

        private Object executeGeneric_byte_byte0(int state_0__, VirtualFrame frameValue) {
            byte rightValue_;
            byte leftValue_;
            int state_0 = state_0__;
            try {
                leftValue_ = this.left_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightValue = this.right_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), rightValue);
            }
            try {
                rightValue_ = this.right_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(leftValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(leftValue_, rightValue_);
            }
            assert ((state_0 & 2) != 0);
            return this.doIntrinsic(leftValue_, rightValue_);
        }

        private Object executeGeneric_short_short1(int state_0__, VirtualFrame frameValue) {
            short rightValue_;
            short leftValue_;
            int state_0 = state_0__;
            try {
                leftValue_ = this.left_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightValue = this.right_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), rightValue);
            }
            try {
                rightValue_ = this.right_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(leftValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(leftValue_, rightValue_);
            }
            assert ((state_0 & 4) != 0);
            return this.doIntrinsic(leftValue_, rightValue_);
        }

        private Object executeGeneric_int_int2(int state_0__, VirtualFrame frameValue) {
            int rightValue_;
            int leftValue_;
            int state_0 = state_0__;
            try {
                leftValue_ = this.left_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightValue = this.right_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), rightValue);
            }
            try {
                rightValue_ = this.right_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(leftValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(leftValue_, rightValue_);
            }
            assert ((state_0 & 8) != 0);
            return this.doIntrinsic(leftValue_, rightValue_);
        }

        private Object executeGeneric_long_long3(int state_0__, VirtualFrame frameValue) {
            long rightValue_;
            long leftValue_;
            int state_0 = state_0__;
            try {
                leftValue_ = this.left_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightValue = this.right_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), rightValue);
            }
            try {
                rightValue_ = this.right_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(leftValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(leftValue_, rightValue_);
            }
            assert ((state_0 & 0x10) != 0);
            return this.doIntrinsic(leftValue_, rightValue_);
        }

        private Object executeGeneric_generic4(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object leftValue_ = this.left_.executeGeneric(frameValue);
            Object rightValue_ = this.right_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(leftValue_, rightValue_);
            }
            if ((state_0 & 0x1E) != 0) {
                if ((state_0 & 2) != 0 && leftValue_ instanceof Byte) {
                    byte by = (Byte)leftValue_;
                    if (rightValue_ instanceof Byte) {
                        byte rightValue__ = (Byte)rightValue_;
                        return this.doIntrinsic(by, rightValue__);
                    }
                }
                if ((state_0 & 4) != 0 && leftValue_ instanceof Short) {
                    short s = (Short)leftValue_;
                    if (rightValue_ instanceof Short) {
                        short rightValue__ = (Short)rightValue_;
                        return this.doIntrinsic(s, rightValue__);
                    }
                }
                if ((state_0 & 8) != 0 && leftValue_ instanceof Integer) {
                    int n = (Integer)leftValue_;
                    if (rightValue_ instanceof Integer) {
                        int rightValue__ = (Integer)rightValue_;
                        return this.doIntrinsic(n, rightValue__);
                    }
                }
                if ((state_0 & 0x10) != 0 && leftValue_ instanceof Long) {
                    long l = (Long)leftValue_;
                    if (rightValue_ instanceof Long) {
                        long rightValue__ = (Long)rightValue_;
                        return this.doIntrinsic(l, rightValue__);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftValue_, rightValue_);
        }

        @Override
        public byte executeI8(VirtualFrame frameValue) throws UnexpectedResultException {
            byte rightValue_;
            byte leftValue_;
            int state_0 = this.state_0_;
            try {
                leftValue_ = this.left_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightValue = this.right_.executeGeneric(frameValue);
                return LLVMTypesGen.expectByte(this.executeAndSpecialize(ex.getResult(), rightValue));
            }
            try {
                rightValue_ = this.right_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return LLVMTypesGen.expectByte(this.executeAndSpecialize(leftValue_, ex.getResult()));
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return LLVMTypesGen.expectByte(this.executeAndSpecialize(leftValue_, rightValue_));
            }
            if ((state_0 & 2) != 0) {
                return this.doIntrinsic(leftValue_, rightValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectByte(this.executeAndSpecialize(leftValue_, rightValue_));
        }

        @Override
        public int executeI32(VirtualFrame frameValue) throws UnexpectedResultException {
            int rightValue_;
            int leftValue_;
            int state_0 = this.state_0_;
            try {
                leftValue_ = this.left_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightValue = this.right_.executeGeneric(frameValue);
                return LLVMTypesGen.expectInteger(this.executeAndSpecialize(ex.getResult(), rightValue));
            }
            try {
                rightValue_ = this.right_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return LLVMTypesGen.expectInteger(this.executeAndSpecialize(leftValue_, ex.getResult()));
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return LLVMTypesGen.expectInteger(this.executeAndSpecialize(leftValue_, rightValue_));
            }
            if ((state_0 & 8) != 0) {
                return this.doIntrinsic(leftValue_, rightValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectInteger(this.executeAndSpecialize(leftValue_, rightValue_));
        }

        @Override
        public long executeI64(VirtualFrame frameValue) throws UnexpectedResultException {
            long rightValue_;
            long leftValue_;
            int state_0 = this.state_0_;
            try {
                leftValue_ = this.left_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightValue = this.right_.executeGeneric(frameValue);
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(ex.getResult(), rightValue));
            }
            try {
                rightValue_ = this.right_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(leftValue_, ex.getResult()));
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(leftValue_, rightValue_));
            }
            if ((state_0 & 0x10) != 0) {
                return this.doIntrinsic(leftValue_, rightValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectLong(this.executeAndSpecialize(leftValue_, rightValue_));
        }

        @Override
        public short executeI16(VirtualFrame frameValue) throws UnexpectedResultException {
            short rightValue_;
            short leftValue_;
            int state_0 = this.state_0_;
            try {
                leftValue_ = this.left_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightValue = this.right_.executeGeneric(frameValue);
                return LLVMTypesGen.expectShort(this.executeAndSpecialize(ex.getResult(), rightValue));
            }
            try {
                rightValue_ = this.right_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return LLVMTypesGen.expectShort(this.executeAndSpecialize(leftValue_, ex.getResult()));
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return LLVMTypesGen.expectShort(this.executeAndSpecialize(leftValue_, rightValue_));
            }
            if ((state_0 & 4) != 0) {
                return this.doIntrinsic(leftValue_, rightValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectShort(this.executeAndSpecialize(leftValue_, rightValue_));
        }

        private Object executeAndSpecialize(Object leftValue, Object rightValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (leftValue instanceof Byte) {
                byte by = (Byte)leftValue;
                if (rightValue instanceof Byte) {
                    byte rightValue_ = (Byte)rightValue;
                    this.state_0_ = state_0 |= 2;
                    return this.doIntrinsic(by, rightValue_);
                }
            }
            if (leftValue instanceof Short) {
                short s = (Short)leftValue;
                if (rightValue instanceof Short) {
                    short rightValue_ = (Short)rightValue;
                    this.state_0_ = state_0 |= 4;
                    return this.doIntrinsic(s, rightValue_);
                }
            }
            if (leftValue instanceof Integer) {
                int n = (Integer)leftValue;
                if (rightValue instanceof Integer) {
                    int rightValue_ = (Integer)rightValue;
                    this.state_0_ = state_0 |= 8;
                    return this.doIntrinsic(n, rightValue_);
                }
            }
            if (leftValue instanceof Long) {
                long l = (Long)leftValue;
                if (rightValue instanceof Long) {
                    long rightValue_ = (Long)rightValue;
                    this.state_0_ = state_0 |= 0x10;
                    return this.doIntrinsic(l, rightValue_);
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.left_, this.right_}, new Object[]{leftValue, rightValue});
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            this.state_0_ |= 4;
            this.state_0_ |= 8;
            this.state_0_ |= 0x10;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMArithmetic.LLVMSimpleArithmeticPrimitive create(LLVMArithmetic.SaturatingArithmetic arithmetic, LLVMExpressionNode left, LLVMExpressionNode right) {
            return new LLVMSimpleArithmeticPrimitiveNodeGen(arithmetic, left, right);
        }
    }

    @GeneratedBy(value=LLVMArithmetic.GCCArithmetic.class)
    public static final class GCCArithmeticNodeGen
    extends LLVMArithmetic.GCCArithmetic
    implements GenerateAOT.Provider {
        @Node.Child
        private LLVMExpressionNode left_;
        @Node.Child
        private LLVMExpressionNode right_;
        @Node.Child
        private LLVMExpressionNode target_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;
        @Node.Child
        private Intrinsic0Data intrinsic0_cache;
        @Node.Child
        private Intrinsic1Data intrinsic1_cache;
        @Node.Child
        private Intrinsic2Data intrinsic2_cache;
        @Node.Child
        private Intrinsic3Data intrinsic3_cache;

        private GCCArithmeticNodeGen(LLVMArithmetic.Arithmetic arithmetic, LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode target) {
            super(arithmetic);
            this.left_ = left;
            this.right_ = right;
            this.target_ = target;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0x1C) == 0 && (state_0 & 0x1E) != 0) {
                return this.executeGeneric_byte_byte0(state_0, frameValue);
            }
            if ((state_0 & 0x1A) == 0 && (state_0 & 0x1E) != 0) {
                return this.executeGeneric_short_short1(state_0, frameValue);
            }
            if ((state_0 & 0x16) == 0 && (state_0 & 0x1E) != 0) {
                return this.executeGeneric_int_int2(state_0, frameValue);
            }
            if ((state_0 & 0xE) == 0 && (state_0 & 0x1E) != 0) {
                return this.executeGeneric_long_long3(state_0, frameValue);
            }
            return this.executeGeneric_generic4(state_0, frameValue);
        }

        private Object executeGeneric_byte_byte0(int state_0__, VirtualFrame frameValue) {
            byte rightValue_;
            byte leftValue_;
            int state_0 = state_0__;
            try {
                leftValue_ = this.left_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightValue = this.right_.executeGeneric(frameValue);
                Object targetValue = this.target_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), rightValue, targetValue);
            }
            try {
                rightValue_ = this.right_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object targetValue = this.target_.executeGeneric(frameValue);
                return this.executeAndSpecialize(leftValue_, ex.getResult(), targetValue);
            }
            Object targetValue_ = this.target_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(leftValue_, rightValue_, targetValue_);
            }
            assert ((state_0 & 2) != 0);
            if (LLVMTypes.isPointer(targetValue_)) {
                LLVMPointer targetValue__ = LLVMTypes.asPointer(targetValue_);
                Intrinsic0Data s0_ = this.intrinsic0_cache;
                if (s0_ != null) {
                    return this.doIntrinsic(leftValue_, rightValue_, targetValue__, s0_.store_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftValue_, rightValue_, targetValue_);
        }

        private Object executeGeneric_short_short1(int state_0__, VirtualFrame frameValue) {
            short rightValue_;
            short leftValue_;
            int state_0 = state_0__;
            try {
                leftValue_ = this.left_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightValue = this.right_.executeGeneric(frameValue);
                Object targetValue = this.target_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), rightValue, targetValue);
            }
            try {
                rightValue_ = this.right_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object targetValue = this.target_.executeGeneric(frameValue);
                return this.executeAndSpecialize(leftValue_, ex.getResult(), targetValue);
            }
            Object targetValue_ = this.target_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(leftValue_, rightValue_, targetValue_);
            }
            assert ((state_0 & 4) != 0);
            if (LLVMTypes.isPointer(targetValue_)) {
                LLVMPointer targetValue__ = LLVMTypes.asPointer(targetValue_);
                Intrinsic1Data s1_ = this.intrinsic1_cache;
                if (s1_ != null) {
                    return this.doIntrinsic(leftValue_, rightValue_, targetValue__, s1_.store_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftValue_, rightValue_, targetValue_);
        }

        private Object executeGeneric_int_int2(int state_0__, VirtualFrame frameValue) {
            int rightValue_;
            int leftValue_;
            int state_0 = state_0__;
            try {
                leftValue_ = this.left_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightValue = this.right_.executeGeneric(frameValue);
                Object targetValue = this.target_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), rightValue, targetValue);
            }
            try {
                rightValue_ = this.right_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object targetValue = this.target_.executeGeneric(frameValue);
                return this.executeAndSpecialize(leftValue_, ex.getResult(), targetValue);
            }
            Object targetValue_ = this.target_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(leftValue_, rightValue_, targetValue_);
            }
            assert ((state_0 & 8) != 0);
            if (LLVMTypes.isPointer(targetValue_)) {
                LLVMPointer targetValue__ = LLVMTypes.asPointer(targetValue_);
                Intrinsic2Data s2_ = this.intrinsic2_cache;
                if (s2_ != null) {
                    return this.doIntrinsic(leftValue_, rightValue_, targetValue__, s2_.store_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftValue_, rightValue_, targetValue_);
        }

        private Object executeGeneric_long_long3(int state_0__, VirtualFrame frameValue) {
            long rightValue_;
            long leftValue_;
            int state_0 = state_0__;
            try {
                leftValue_ = this.left_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightValue = this.right_.executeGeneric(frameValue);
                Object targetValue = this.target_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), rightValue, targetValue);
            }
            try {
                rightValue_ = this.right_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object targetValue = this.target_.executeGeneric(frameValue);
                return this.executeAndSpecialize(leftValue_, ex.getResult(), targetValue);
            }
            Object targetValue_ = this.target_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(leftValue_, rightValue_, targetValue_);
            }
            assert ((state_0 & 0x10) != 0);
            if (LLVMTypes.isPointer(targetValue_)) {
                LLVMPointer targetValue__ = LLVMTypes.asPointer(targetValue_);
                Intrinsic3Data s3_ = this.intrinsic3_cache;
                if (s3_ != null) {
                    return this.doIntrinsic(leftValue_, rightValue_, targetValue__, s3_.store_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftValue_, rightValue_, targetValue_);
        }

        private Object executeGeneric_generic4(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object leftValue_ = this.left_.executeGeneric(frameValue);
            Object rightValue_ = this.right_.executeGeneric(frameValue);
            Object targetValue_ = this.target_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(leftValue_, rightValue_, targetValue_);
            }
            if ((state_0 & 0x1E) != 0 && LLVMTypes.isPointer(targetValue_)) {
                LLVMPointer targetValue__ = LLVMTypes.asPointer(targetValue_);
                if ((state_0 & 2) != 0 && leftValue_ instanceof Byte) {
                    byte by = (Byte)leftValue_;
                    if (rightValue_ instanceof Byte) {
                        byte by2 = (Byte)rightValue_;
                        Intrinsic0Data s0_ = this.intrinsic0_cache;
                        if (s0_ != null) {
                            return this.doIntrinsic(by, by2, targetValue__, s0_.store_);
                        }
                    }
                }
                if ((state_0 & 4) != 0 && leftValue_ instanceof Short) {
                    short s = (Short)leftValue_;
                    if (rightValue_ instanceof Short) {
                        short s2 = (Short)rightValue_;
                        Intrinsic1Data s1_ = this.intrinsic1_cache;
                        if (s1_ != null) {
                            return this.doIntrinsic(s, s2, targetValue__, s1_.store_);
                        }
                    }
                }
                if ((state_0 & 8) != 0 && leftValue_ instanceof Integer) {
                    int n = (Integer)leftValue_;
                    if (rightValue_ instanceof Integer) {
                        int n2 = (Integer)rightValue_;
                        Intrinsic2Data s2_ = this.intrinsic2_cache;
                        if (s2_ != null) {
                            return this.doIntrinsic(n, n2, targetValue__, s2_.store_);
                        }
                    }
                }
                if ((state_0 & 0x10) != 0 && leftValue_ instanceof Long) {
                    long l = (Long)leftValue_;
                    if (rightValue_ instanceof Long) {
                        long rightValue__2 = (Long)rightValue_;
                        Intrinsic3Data s3_ = this.intrinsic3_cache;
                        if (s3_ != null) {
                            return this.doIntrinsic(l, rightValue__2, targetValue__, s3_.store_);
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftValue_, rightValue_, targetValue_);
        }

        @Override
        public byte executeI8(VirtualFrame frameValue) throws UnexpectedResultException {
            byte rightValue_;
            byte leftValue_;
            int state_0 = this.state_0_;
            try {
                leftValue_ = this.left_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightValue = this.right_.executeGeneric(frameValue);
                Object targetValue = this.target_.executeGeneric(frameValue);
                return LLVMTypesGen.expectByte(this.executeAndSpecialize(ex.getResult(), rightValue, targetValue));
            }
            try {
                rightValue_ = this.right_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object targetValue = this.target_.executeGeneric(frameValue);
                return LLVMTypesGen.expectByte(this.executeAndSpecialize(leftValue_, ex.getResult(), targetValue));
            }
            Object targetValue_ = this.target_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return LLVMTypesGen.expectByte(this.executeAndSpecialize(leftValue_, rightValue_, targetValue_));
            }
            if ((state_0 & 2) != 0 && LLVMTypes.isPointer(targetValue_)) {
                LLVMPointer targetValue__ = LLVMTypes.asPointer(targetValue_);
                Intrinsic0Data s0_ = this.intrinsic0_cache;
                if (s0_ != null) {
                    return this.doIntrinsic(leftValue_, rightValue_, targetValue__, s0_.store_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectByte(this.executeAndSpecialize(leftValue_, rightValue_, targetValue_));
        }

        @Override
        public int executeI32(VirtualFrame frameValue) throws UnexpectedResultException {
            int rightValue_;
            int leftValue_;
            int state_0 = this.state_0_;
            try {
                leftValue_ = this.left_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightValue = this.right_.executeGeneric(frameValue);
                Object targetValue = this.target_.executeGeneric(frameValue);
                return LLVMTypesGen.expectInteger(this.executeAndSpecialize(ex.getResult(), rightValue, targetValue));
            }
            try {
                rightValue_ = this.right_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object targetValue = this.target_.executeGeneric(frameValue);
                return LLVMTypesGen.expectInteger(this.executeAndSpecialize(leftValue_, ex.getResult(), targetValue));
            }
            Object targetValue_ = this.target_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return LLVMTypesGen.expectInteger(this.executeAndSpecialize(leftValue_, rightValue_, targetValue_));
            }
            if ((state_0 & 8) != 0 && LLVMTypes.isPointer(targetValue_)) {
                LLVMPointer targetValue__ = LLVMTypes.asPointer(targetValue_);
                Intrinsic2Data s2_ = this.intrinsic2_cache;
                if (s2_ != null) {
                    return this.doIntrinsic(leftValue_, rightValue_, targetValue__, s2_.store_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectInteger(this.executeAndSpecialize(leftValue_, rightValue_, targetValue_));
        }

        @Override
        public long executeI64(VirtualFrame frameValue) throws UnexpectedResultException {
            long rightValue_;
            long leftValue_;
            int state_0 = this.state_0_;
            try {
                leftValue_ = this.left_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightValue = this.right_.executeGeneric(frameValue);
                Object targetValue = this.target_.executeGeneric(frameValue);
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(ex.getResult(), rightValue, targetValue));
            }
            try {
                rightValue_ = this.right_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object targetValue = this.target_.executeGeneric(frameValue);
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(leftValue_, ex.getResult(), targetValue));
            }
            Object targetValue_ = this.target_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(leftValue_, rightValue_, targetValue_));
            }
            if ((state_0 & 0x10) != 0 && LLVMTypes.isPointer(targetValue_)) {
                LLVMPointer targetValue__ = LLVMTypes.asPointer(targetValue_);
                Intrinsic3Data s3_ = this.intrinsic3_cache;
                if (s3_ != null) {
                    return this.doIntrinsic(leftValue_, rightValue_, targetValue__, s3_.store_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectLong(this.executeAndSpecialize(leftValue_, rightValue_, targetValue_));
        }

        @Override
        public short executeI16(VirtualFrame frameValue) throws UnexpectedResultException {
            short rightValue_;
            short leftValue_;
            int state_0 = this.state_0_;
            try {
                leftValue_ = this.left_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightValue = this.right_.executeGeneric(frameValue);
                Object targetValue = this.target_.executeGeneric(frameValue);
                return LLVMTypesGen.expectShort(this.executeAndSpecialize(ex.getResult(), rightValue, targetValue));
            }
            try {
                rightValue_ = this.right_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object targetValue = this.target_.executeGeneric(frameValue);
                return LLVMTypesGen.expectShort(this.executeAndSpecialize(leftValue_, ex.getResult(), targetValue));
            }
            Object targetValue_ = this.target_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return LLVMTypesGen.expectShort(this.executeAndSpecialize(leftValue_, rightValue_, targetValue_));
            }
            if ((state_0 & 4) != 0 && LLVMTypes.isPointer(targetValue_)) {
                LLVMPointer targetValue__ = LLVMTypes.asPointer(targetValue_);
                Intrinsic1Data s1_ = this.intrinsic1_cache;
                if (s1_ != null) {
                    return this.doIntrinsic(leftValue_, rightValue_, targetValue__, s1_.store_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectShort(this.executeAndSpecialize(leftValue_, rightValue_, targetValue_));
        }

        private Object executeAndSpecialize(Object leftValue, Object rightValue, Object targetValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (LLVMTypes.isPointer(targetValue)) {
                LLVMPointer targetValue_ = LLVMTypes.asPointer(targetValue);
                if (leftValue instanceof Byte) {
                    byte by = (Byte)leftValue;
                    if (rightValue instanceof Byte) {
                        byte rightValue_ = (Byte)rightValue;
                        Intrinsic0Data s0_ = (Intrinsic0Data)this.insert(new Intrinsic0Data());
                        s0_.store_ = (LLVMI8StoreNode)s0_.insert(LLVMI8StoreNode.create());
                        VarHandle.storeStoreFence();
                        this.intrinsic0_cache = s0_;
                        this.state_0_ = state_0 |= 2;
                        return this.doIntrinsic(by, rightValue_, targetValue_, s0_.store_);
                    }
                }
                if (leftValue instanceof Short) {
                    short s = (Short)leftValue;
                    if (rightValue instanceof Short) {
                        short rightValue_ = (Short)rightValue;
                        Intrinsic1Data s1_ = (Intrinsic1Data)this.insert(new Intrinsic1Data());
                        s1_.store_ = (LLVMI16StoreNode)s1_.insert(LLVMI16StoreNode.create());
                        VarHandle.storeStoreFence();
                        this.intrinsic1_cache = s1_;
                        this.state_0_ = state_0 |= 4;
                        return this.doIntrinsic(s, rightValue_, targetValue_, s1_.store_);
                    }
                }
                if (leftValue instanceof Integer) {
                    int n = (Integer)leftValue;
                    if (rightValue instanceof Integer) {
                        int rightValue_ = (Integer)rightValue;
                        Intrinsic2Data s2_ = (Intrinsic2Data)this.insert(new Intrinsic2Data());
                        s2_.store_ = (LLVMI32StoreNode)s2_.insert(LLVMI32StoreNode.create());
                        VarHandle.storeStoreFence();
                        this.intrinsic2_cache = s2_;
                        this.state_0_ = state_0 |= 8;
                        return this.doIntrinsic(n, rightValue_, targetValue_, s2_.store_);
                    }
                }
                if (leftValue instanceof Long) {
                    long l = (Long)leftValue;
                    if (rightValue instanceof Long) {
                        long rightValue_ = (Long)rightValue;
                        Intrinsic3Data s3_ = (Intrinsic3Data)this.insert(new Intrinsic3Data());
                        s3_.store_ = (LLVMI64StoreNode)s3_.insert(LLVMI64StoreNode.create());
                        VarHandle.storeStoreFence();
                        this.intrinsic3_cache = s3_;
                        this.state_0_ = state_0 |= 0x10;
                        return this.doIntrinsic(l, rightValue_, targetValue_, s3_.store_);
                    }
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.left_, this.right_, this.target_}, new Object[]{leftValue, rightValue, targetValue});
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            Intrinsic0Data s0_ = (Intrinsic0Data)this.insert(new Intrinsic0Data());
            s0_.store_ = (LLVMI8StoreNode)s0_.insert(LLVMI8StoreNode.create());
            VarHandle.storeStoreFence();
            this.intrinsic0_cache = s0_;
            assert (NodeUtil.assertRecursion((Node)s0_.store_, (int)1));
            ((GenerateAOT.Provider)s0_.store_).prepareForAOT(language, root);
            this.state_0_ |= 2;
            Intrinsic1Data s1_ = (Intrinsic1Data)this.insert(new Intrinsic1Data());
            s1_.store_ = (LLVMI16StoreNode)s1_.insert(LLVMI16StoreNode.create());
            VarHandle.storeStoreFence();
            this.intrinsic1_cache = s1_;
            assert (NodeUtil.assertRecursion((Node)s1_.store_, (int)1));
            ((GenerateAOT.Provider)s1_.store_).prepareForAOT(language, root);
            this.state_0_ |= 4;
            Intrinsic2Data s2_ = (Intrinsic2Data)this.insert(new Intrinsic2Data());
            s2_.store_ = (LLVMI32StoreNode)s2_.insert(LLVMI32StoreNode.create());
            VarHandle.storeStoreFence();
            this.intrinsic2_cache = s2_;
            assert (NodeUtil.assertRecursion((Node)s2_.store_, (int)1));
            ((GenerateAOT.Provider)s2_.store_).prepareForAOT(language, root);
            this.state_0_ |= 8;
            Intrinsic3Data s3_ = (Intrinsic3Data)this.insert(new Intrinsic3Data());
            s3_.store_ = (LLVMI64StoreNode)s3_.insert(LLVMI64StoreNode.create());
            VarHandle.storeStoreFence();
            this.intrinsic3_cache = s3_;
            assert (NodeUtil.assertRecursion((Node)s3_.store_, (int)1));
            ((GenerateAOT.Provider)s3_.store_).prepareForAOT(language, root);
            this.state_0_ |= 0x10;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
            this.intrinsic0_cache = null;
            this.intrinsic1_cache = null;
            this.intrinsic2_cache = null;
            this.intrinsic3_cache = null;
        }

        @NeverDefault
        public static LLVMArithmetic.GCCArithmetic create(LLVMArithmetic.Arithmetic arithmetic, LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode target) {
            return new GCCArithmeticNodeGen(arithmetic, left, right, target);
        }

        @GeneratedBy(value=LLVMArithmetic.GCCArithmetic.class)
        @DenyReplace
        private static final class Intrinsic0Data
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @Node.Child
            LLVMI8StoreNode store_;

            Intrinsic0Data() {
            }
        }

        @GeneratedBy(value=LLVMArithmetic.GCCArithmetic.class)
        @DenyReplace
        private static final class Intrinsic1Data
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @Node.Child
            LLVMI16StoreNode store_;

            Intrinsic1Data() {
            }
        }

        @GeneratedBy(value=LLVMArithmetic.GCCArithmetic.class)
        @DenyReplace
        private static final class Intrinsic2Data
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @Node.Child
            LLVMI32StoreNode store_;

            Intrinsic2Data() {
            }
        }

        @GeneratedBy(value=LLVMArithmetic.GCCArithmetic.class)
        @DenyReplace
        private static final class Intrinsic3Data
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @Node.Child
            LLVMI64StoreNode store_;

            Intrinsic3Data() {
            }
        }
    }
}

