/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.asm.support;

import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.support.LLVMAMD64Target;
import com.oracle.truffle.llvm.runtime.nodes.asm.support.LLVMAMD64WriteNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

public abstract class LLVMAMD64WriteValueNode
extends LLVMNode {
    @Node.Child
    protected LLVMExpressionNode data;
    @Node.Child
    protected LLVMAMD64WriteNode write;

    public LLVMAMD64WriteValueNode(LLVMAMD64Target dst) {
        this.data = dst.createInput();
        this.write = dst.createTarget();
    }

    public abstract void execute(VirtualFrame var1, Object var2);

    @Specialization
    protected void doI8(VirtualFrame frame, byte value) {
        Object info = this.data.executeGeneric(frame);
        this.write.execute(frame, info, value);
    }

    @Specialization
    protected void doI16(VirtualFrame frame, short value) {
        Object info = this.data.executeGeneric(frame);
        this.write.execute(frame, info, value);
    }

    @Specialization
    protected void doI32(VirtualFrame frame, int value) {
        Object info = this.data.executeGeneric(frame);
        this.write.execute(frame, info, value);
    }

    @Specialization
    protected void doI64(VirtualFrame frame, long value) {
        Object info = this.data.executeGeneric(frame);
        this.write.execute(frame, info, value);
    }

    @Specialization
    protected void doAddress(VirtualFrame frame, LLVMPointer value) {
        Object info = this.data.executeGeneric(frame);
        this.write.execute(frame, info, value);
    }
}

