/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.asm.support;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.DSLSupport;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.asm.support.LLVMAMD64WriteNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI16StoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI32StoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI64StoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI8StoreNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.lang.invoke.VarHandle;
import java.util.concurrent.locks.ReentrantLock;

@GeneratedBy(value=LLVMAMD64WriteNode.class)
public final class LLVMAMD64WriteNodeGen
extends LLVMAMD64WriteNode
implements GenerateAOT.Provider {
    @CompilerDirectives.CompilationFinal
    private int state_0_;
    @Node.Child
    private MemoryWriteData memoryWrite_cache;

    private LLVMAMD64WriteNodeGen() {
    }

    private LLVMAMD64WriteNodeGen(int shift) {
        super(shift);
    }

    @Override
    public void execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
        int state_0 = this.state_0_;
        if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
            this.executeAndSpecialize(frameValue, arg0Value, arg1Value);
            return;
        }
        if ((state_0 & 0x7E) != 0) {
            if ((state_0 & 0x3E) != 0 && arg0Value instanceof Integer) {
                int arg0Value_ = (Integer)arg0Value;
                if ((state_0 & 2) != 0 && arg1Value instanceof Byte) {
                    byte arg1Value_ = (Byte)arg1Value;
                    this.doI8(frameValue, arg0Value_, arg1Value_);
                    return;
                }
                if ((state_0 & 4) != 0 && arg1Value instanceof Short) {
                    short arg1Value_ = (Short)arg1Value;
                    this.doI16(frameValue, arg0Value_, arg1Value_);
                    return;
                }
                if ((state_0 & 8) != 0 && arg1Value instanceof Integer) {
                    int arg1Value_ = (Integer)arg1Value;
                    this.doI32(frameValue, arg0Value_, arg1Value_);
                    return;
                }
                if ((state_0 & 0x10) != 0 && arg1Value instanceof Long) {
                    long arg1Value_ = (Long)arg1Value;
                    this.doI64(frameValue, arg0Value_, arg1Value_);
                    return;
                }
                if ((state_0 & 0x20) != 0 && LLVMTypes.isNativePointer(arg1Value)) {
                    LLVMNativePointer arg1Value_ = LLVMTypes.asNativePointer(arg1Value);
                    this.doNativePointer(frameValue, arg0Value_, arg1Value_);
                    return;
                }
            }
            if ((state_0 & 0x40) != 0 && LLVMTypes.isPointer(arg0Value)) {
                LLVMPointer arg0Value_ = LLVMTypes.asPointer(arg0Value);
                MemoryWriteData s5_ = this.memoryWrite_cache;
                if (s5_ != null) {
                    this.doMemoryWrite(arg0Value_, arg1Value, s5_.writeNode_);
                    return;
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        this.executeAndSpecialize(frameValue, arg0Value, arg1Value);
    }

    private void executeAndSpecialize(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
        int state_0 = this.state_0_;
        if ((state_0 & 1) != 0) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (arg0Value instanceof Integer) {
            int arg0Value_ = (Integer)arg0Value;
            if (arg1Value instanceof Byte) {
                byte arg1Value_ = (Byte)arg1Value;
                this.state_0_ = state_0 |= 2;
                this.doI8(frameValue, arg0Value_, arg1Value_);
                return;
            }
            if (arg1Value instanceof Short) {
                short arg1Value_ = (Short)arg1Value;
                this.state_0_ = state_0 |= 4;
                this.doI16(frameValue, arg0Value_, arg1Value_);
                return;
            }
            if (arg1Value instanceof Integer) {
                int arg1Value_ = (Integer)arg1Value;
                this.state_0_ = state_0 |= 8;
                this.doI32(frameValue, arg0Value_, arg1Value_);
                return;
            }
            if (arg1Value instanceof Long) {
                long arg1Value_ = (Long)arg1Value;
                this.state_0_ = state_0 |= 0x10;
                this.doI64(frameValue, arg0Value_, arg1Value_);
                return;
            }
            if (LLVMTypes.isNativePointer(arg1Value)) {
                LLVMNativePointer arg1Value_ = LLVMTypes.asNativePointer(arg1Value);
                this.state_0_ = state_0 |= 0x20;
                this.doNativePointer(frameValue, arg0Value_, arg1Value_);
                return;
            }
        }
        if (LLVMTypes.isPointer(arg0Value)) {
            LLVMPointer arg0Value_ = LLVMTypes.asPointer(arg0Value);
            MemoryWriteData s5_ = (MemoryWriteData)this.insert(new MemoryWriteData());
            s5_.writeNode_ = (LLVMAMD64WriteNode.LLVMAMD64MemWriteNode)s5_.insert(LLVMAMD64WriteNode.createMemoryWriteNode());
            VarHandle.storeStoreFence();
            this.memoryWrite_cache = s5_;
            this.state_0_ = state_0 |= 0x40;
            this.doMemoryWrite(arg0Value_, arg1Value, s5_.writeNode_);
            return;
        }
        throw new UnsupportedSpecializationException((Node)this, null, new Object[]{arg0Value, arg1Value});
    }

    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
        if ((this.state_0_ & 1) != 0) {
            return;
        }
        this.state_0_ |= 2;
        this.state_0_ |= 4;
        this.state_0_ |= 8;
        this.state_0_ |= 0x10;
        this.state_0_ |= 0x20;
        MemoryWriteData s5_ = (MemoryWriteData)this.insert(new MemoryWriteData());
        s5_.writeNode_ = (LLVMAMD64WriteNode.LLVMAMD64MemWriteNode)s5_.insert(LLVMAMD64WriteNode.createMemoryWriteNode());
        VarHandle.storeStoreFence();
        this.memoryWrite_cache = s5_;
        assert (NodeUtil.assertRecursion((Node)s5_.writeNode_, (int)1));
        ((GenerateAOT.Provider)s5_.writeNode_).prepareForAOT(language, root);
        this.state_0_ |= 0x40;
        int state_0 = this.state_0_;
        this.state_0_ = state_0 |= 1;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if ((state_0 & 1) == 0) {
            return;
        }
        this.state_0_ = 0;
        this.memoryWrite_cache = null;
    }

    @NeverDefault
    public static LLVMAMD64WriteNode create() {
        return new LLVMAMD64WriteNodeGen();
    }

    @NeverDefault
    public static LLVMAMD64WriteNode create(int shift) {
        return new LLVMAMD64WriteNodeGen(shift);
    }

    @GeneratedBy(value=LLVMAMD64WriteNode.class)
    @DenyReplace
    private static final class MemoryWriteData
    extends Node
    implements DSLSupport.SpecializationDataNode {
        @Node.Child
        LLVMAMD64WriteNode.LLVMAMD64MemWriteNode writeNode_;

        MemoryWriteData() {
        }
    }

    @GeneratedBy(value=LLVMAMD64WriteNode.LLVMAMD64MemWriteNode.class)
    static final class LLVMAMD64MemWriteNodeGen
    extends LLVMAMD64WriteNode.LLVMAMD64MemWriteNode
    implements GenerateAOT.Provider {
        @CompilerDirectives.CompilationFinal
        private int state_0_;
        @Node.Child
        private I8Data i8_cache;
        @Node.Child
        private I16Data i16_cache;
        @Node.Child
        private I32Data i32_cache;
        @Node.Child
        private I64Data i64_cache;

        private LLVMAMD64MemWriteNodeGen() {
        }

        private boolean fallbackGuard_(int state_0, LLVMPointer arg0Value, Object arg1Value) {
            if ((state_0 & 2) == 0 && arg1Value instanceof Byte) {
                return false;
            }
            if ((state_0 & 4) == 0 && arg1Value instanceof Short) {
                return false;
            }
            if ((state_0 & 8) == 0 && arg1Value instanceof Integer) {
                return false;
            }
            return (state_0 & 0x10) != 0 || !(arg1Value instanceof Long);
        }

        @Override
        public void executeWithTarget(LLVMPointer arg0Value, Object arg1Value) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                this.executeAndSpecialize(arg0Value, arg1Value);
                return;
            }
            if ((state_0 & 0x3E) != 0) {
                if ((state_0 & 2) != 0 && arg1Value instanceof Byte) {
                    byte by = (Byte)arg1Value;
                    I8Data s0_ = this.i8_cache;
                    if (s0_ != null) {
                        this.doI8(arg0Value, by, s0_.store_);
                        return;
                    }
                }
                if ((state_0 & 4) != 0 && arg1Value instanceof Short) {
                    short s = (Short)arg1Value;
                    I16Data s1_ = this.i16_cache;
                    if (s1_ != null) {
                        this.doI16(arg0Value, s, s1_.store_);
                        return;
                    }
                }
                if ((state_0 & 8) != 0 && arg1Value instanceof Integer) {
                    int n = (Integer)arg1Value;
                    I32Data s2_ = this.i32_cache;
                    if (s2_ != null) {
                        this.doI32(arg0Value, n, s2_.store_);
                        return;
                    }
                }
                if ((state_0 & 0x10) != 0 && arg1Value instanceof Long) {
                    long l = (Long)arg1Value;
                    I64Data s3_ = this.i64_cache;
                    if (s3_ != null) {
                        this.doI64(arg0Value, l, s3_.store_);
                        return;
                    }
                }
                if ((state_0 & 0x20) != 0 && this.fallbackGuard_(state_0, arg0Value, arg1Value)) {
                    this.doObject(arg0Value, arg1Value);
                    return;
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(arg0Value, arg1Value);
        }

        private void executeAndSpecialize(LLVMPointer arg0Value, Object arg1Value) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (arg1Value instanceof Byte) {
                byte arg1Value_ = (Byte)arg1Value;
                I8Data s0_ = (I8Data)this.insert(new I8Data());
                s0_.store_ = (LLVMI8StoreNode)s0_.insert(LLVMI8StoreNode.create());
                VarHandle.storeStoreFence();
                this.i8_cache = s0_;
                this.state_0_ = state_0 |= 2;
                this.doI8(arg0Value, arg1Value_, s0_.store_);
                return;
            }
            if (arg1Value instanceof Short) {
                short arg1Value_ = (Short)arg1Value;
                I16Data s1_ = (I16Data)this.insert(new I16Data());
                s1_.store_ = (LLVMI16StoreNode)s1_.insert(LLVMI16StoreNode.create());
                VarHandle.storeStoreFence();
                this.i16_cache = s1_;
                this.state_0_ = state_0 |= 4;
                this.doI16(arg0Value, arg1Value_, s1_.store_);
                return;
            }
            if (arg1Value instanceof Integer) {
                int arg1Value_ = (Integer)arg1Value;
                I32Data s2_ = (I32Data)this.insert(new I32Data());
                s2_.store_ = (LLVMI32StoreNode)s2_.insert(LLVMI32StoreNode.create());
                VarHandle.storeStoreFence();
                this.i32_cache = s2_;
                this.state_0_ = state_0 |= 8;
                this.doI32(arg0Value, arg1Value_, s2_.store_);
                return;
            }
            if (arg1Value instanceof Long) {
                long arg1Value_ = (Long)arg1Value;
                I64Data s3_ = (I64Data)this.insert(new I64Data());
                s3_.store_ = (LLVMI64StoreNode)s3_.insert(LLVMI64StoreNode.create());
                VarHandle.storeStoreFence();
                this.i64_cache = s3_;
                this.state_0_ = state_0 |= 0x10;
                this.doI64(arg0Value, arg1Value_, s3_.store_);
                return;
            }
            this.state_0_ = state_0 |= 0x20;
            this.doObject(arg0Value, arg1Value);
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            I8Data s0_ = (I8Data)this.insert(new I8Data());
            s0_.store_ = (LLVMI8StoreNode)s0_.insert(LLVMI8StoreNode.create());
            VarHandle.storeStoreFence();
            this.i8_cache = s0_;
            assert (NodeUtil.assertRecursion((Node)s0_.store_, (int)1));
            ((GenerateAOT.Provider)s0_.store_).prepareForAOT(language, root);
            this.state_0_ |= 2;
            I16Data s1_ = (I16Data)this.insert(new I16Data());
            s1_.store_ = (LLVMI16StoreNode)s1_.insert(LLVMI16StoreNode.create());
            VarHandle.storeStoreFence();
            this.i16_cache = s1_;
            assert (NodeUtil.assertRecursion((Node)s1_.store_, (int)1));
            ((GenerateAOT.Provider)s1_.store_).prepareForAOT(language, root);
            this.state_0_ |= 4;
            I32Data s2_ = (I32Data)this.insert(new I32Data());
            s2_.store_ = (LLVMI32StoreNode)s2_.insert(LLVMI32StoreNode.create());
            VarHandle.storeStoreFence();
            this.i32_cache = s2_;
            assert (NodeUtil.assertRecursion((Node)s2_.store_, (int)1));
            ((GenerateAOT.Provider)s2_.store_).prepareForAOT(language, root);
            this.state_0_ |= 8;
            I64Data s3_ = (I64Data)this.insert(new I64Data());
            s3_.store_ = (LLVMI64StoreNode)s3_.insert(LLVMI64StoreNode.create());
            VarHandle.storeStoreFence();
            this.i64_cache = s3_;
            assert (NodeUtil.assertRecursion((Node)s3_.store_, (int)1));
            ((GenerateAOT.Provider)s3_.store_).prepareForAOT(language, root);
            this.state_0_ |= 0x10;
            this.state_0_ |= 0x20;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
            this.i8_cache = null;
            this.i16_cache = null;
            this.i32_cache = null;
            this.i64_cache = null;
        }

        @NeverDefault
        public static LLVMAMD64WriteNode.LLVMAMD64MemWriteNode create() {
            return new LLVMAMD64MemWriteNodeGen();
        }

        @GeneratedBy(value=LLVMAMD64WriteNode.LLVMAMD64MemWriteNode.class)
        @DenyReplace
        private static final class I8Data
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @Node.Child
            LLVMI8StoreNode store_;

            I8Data() {
            }
        }

        @GeneratedBy(value=LLVMAMD64WriteNode.LLVMAMD64MemWriteNode.class)
        @DenyReplace
        private static final class I16Data
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @Node.Child
            LLVMI16StoreNode store_;

            I16Data() {
            }
        }

        @GeneratedBy(value=LLVMAMD64WriteNode.LLVMAMD64MemWriteNode.class)
        @DenyReplace
        private static final class I32Data
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @Node.Child
            LLVMI32StoreNode store_;

            I32Data() {
            }
        }

        @GeneratedBy(value=LLVMAMD64WriteNode.LLVMAMD64MemWriteNode.class)
        @DenyReplace
        private static final class I64Data
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @Node.Child
            LLVMI64StoreNode store_;

            I64Data() {
            }
        }
    }
}

