/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.asm.support;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.support.LLVMAMD64RegisterToLongNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.support.LLVMAMD64RegisterToLongNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.asm.support.LLVMAMD64WriteNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI16StoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI32StoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI64StoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI8StoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMPointerStoreNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

public abstract class LLVMAMD64WriteNode
extends LLVMNode {
    public static final long MASK_16 = -65536L;
    public static final long MASK_32 = -4294967296L;
    @Node.Child
    private LLVMAMD64RegisterToLongNode readRegister;
    private final int shift;
    private final long mask;

    public abstract void execute(VirtualFrame var1, Object var2, Object var3);

    public LLVMAMD64WriteNode() {
        this(0);
    }

    public LLVMAMD64WriteNode(int shift) {
        this.shift = shift;
        this.mask = 255L << shift ^ 0xFFFFFFFFFFFFFFFFL;
        this.readRegister = LLVMAMD64RegisterToLongNodeGen.create();
    }

    @Specialization
    protected void doI8(VirtualFrame frame, int slot, byte value) {
        long reg = this.readRegister.execute(frame, slot);
        long val = reg & this.mask | Byte.toUnsignedLong(value) << this.shift;
        frame.setLong(slot, val);
    }

    @Specialization
    protected void doI16(VirtualFrame frame, int slot, short value) {
        long reg = this.readRegister.execute(frame, slot);
        long val = reg & 0xFFFFFFFFFFFF0000L | Short.toUnsignedLong(value);
        frame.setLong(slot, val);
    }

    @Specialization
    protected void doI32(VirtualFrame frame, int slot, int value) {
        long val = Integer.toUnsignedLong(value);
        frame.setLong(slot, val);
    }

    @Specialization
    protected void doI64(VirtualFrame frame, int slot, long value) {
        frame.setLong(slot, value);
    }

    @Specialization
    protected void doNativePointer(VirtualFrame frame, int slot, LLVMNativePointer value) {
        frame.setLong(slot, value.asNative());
    }

    @Specialization
    protected void doMemoryWrite(LLVMPointer addr, Object value, @Cached(value="createMemoryWriteNode()") LLVMAMD64MemWriteNode writeNode) {
        writeNode.executeWithTarget(addr, value);
    }

    protected static LLVMAMD64MemWriteNode createMemoryWriteNode() {
        return LLVMAMD64WriteNodeGen.LLVMAMD64MemWriteNodeGen.create();
    }

    static abstract class LLVMAMD64MemWriteNode
    extends LLVMNode {
        @Node.Child
        private LLVMPointerStoreNode storePointer;

        LLVMAMD64MemWriteNode() {
        }

        public abstract void executeWithTarget(LLVMPointer var1, Object var2);

        @Specialization
        protected void doI8(LLVMPointer addr, byte value, @Cached LLVMI8StoreNode store) {
            store.executeWithTarget(addr, value);
        }

        @Specialization
        protected void doI16(LLVMPointer addr, short value, @Cached LLVMI16StoreNode store) {
            store.executeWithTarget(addr, value);
        }

        @Specialization
        protected void doI32(LLVMPointer addr, int value, @Cached LLVMI32StoreNode store) {
            store.executeWithTarget(addr, value);
        }

        @Specialization
        protected void doI64(LLVMPointer addr, long value, @Cached LLVMI64StoreNode store) {
            store.executeWithTarget(addr, value);
        }

        @Fallback
        protected void doObject(LLVMPointer addr, Object value) {
            if (this.storePointer == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.storePointer = (LLVMPointerStoreNode)this.insert(LLVMPointerStoreNode.create());
            }
            this.storePointer.executeWithTarget(addr, value);
        }
    }
}

