/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.inlineasm;

import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.llvm.runtime.IDGenerater;
import com.oracle.truffle.llvm.runtime.LLVMFunction;
import com.oracle.truffle.llvm.runtime.LLVMFunctionCode;
import com.oracle.truffle.llvm.runtime.LLVMFunctionDescriptor;
import com.oracle.truffle.llvm.runtime.LLVMUnsupportedException;
import com.oracle.truffle.llvm.runtime.NodeFactory;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMCallNode;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMInlineAssemblyRootNode;
import com.oracle.truffle.llvm.runtime.nodes.literals.LLVMSimpleLiteralNode;
import com.oracle.truffle.llvm.runtime.nodes.others.LLVMUnsupportedInstructionNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.types.FunctionType;
import com.oracle.truffle.llvm.runtime.types.MetaType;
import com.oracle.truffle.llvm.runtime.types.Type;
import java.util.Collections;

public abstract class InlineAssemblyParserBase {
    public abstract LLVMExpressionNode getInlineAssemblerExpression(NodeFactory var1, String var2, String var3, LLVMExpressionNode[] var4, Type.TypeArrayBuilder var5, Type var6);

    protected static LLVMInlineAssemblyRootNode getLazyUnsupportedInlineRootNode(NodeFactory factory, String message) {
        FrameDescriptor.Builder builder = FrameDescriptor.newBuilder();
        factory.addStackSlots(builder);
        LLVMInlineAssemblyRootNode assemblyRoot = new LLVMInlineAssemblyRootNode(factory.getLanguage(), builder.build(), factory.createStackAccess(), Collections.singletonList(LLVMUnsupportedInstructionNode.create(LLVMUnsupportedException.UnsupportedReason.INLINE_ASSEMBLER, message)), Collections.emptyList(), null);
        return assemblyRoot;
    }

    protected static LLVMExpressionNode getCallNodeFromAssemblyRoot(LLVMInlineAssemblyRootNode assemblyRoot, LLVMExpressionNode[] args, Type.TypeArrayBuilder argTypes) {
        LLVMFunctionCode.LLVMIRFunction function = new LLVMFunctionCode.LLVMIRFunction(assemblyRoot.getCallTarget(), null);
        LLVMFunction functionDetail = LLVMFunction.create("<asm>", function, new FunctionType((Type)MetaType.UNKNOWN, 0, -1), IDGenerater.INVALID_ID, -1, false, assemblyRoot.getName(), false);
        LLVMFunctionDescriptor asm = new LLVMFunctionDescriptor(functionDetail, new LLVMFunctionCode(functionDetail));
        LLVMSimpleLiteralNode.LLVMManagedPointerLiteralNode asmFunction = LLVMSimpleLiteralNode.LLVMManagedPointerLiteralNode.create(LLVMManagedPointer.create(asm));
        return LLVMCallNode.create(new FunctionType((Type)MetaType.UNKNOWN, argTypes, -1), asmFunction, args, false, false);
    }
}

