/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.llvm.runtime.IDGenerater;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMFunction;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.LLVMScope;
import com.oracle.truffle.llvm.runtime.LLVMSymbol;
import com.oracle.truffle.llvm.runtime.except.LLVMIllegalSymbolIndexException;
import com.oracle.truffle.llvm.runtime.except.LLVMLinkerException;
import com.oracle.truffle.llvm.runtime.interop.LLVMDataEscapeNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

@ExportLibrary(value=InteropLibrary.class)
public class LLVMScopeChain
implements TruffleObject {
    private LLVMScopeChain next;
    private LLVMScopeChain prev;
    private final IDGenerater.BitcodeID id;
    private final LLVMScope scope;

    public LLVMScopeChain() {
        this.id = IDGenerater.INVALID_ID;
        this.scope = null;
    }

    public LLVMScopeChain(IDGenerater.BitcodeID id, LLVMScope scope) {
        this.id = id;
        this.scope = scope;
    }

    public LLVMScopeChain getNext() {
        return this.next;
    }

    public void setNext(LLVMScopeChain next) {
        this.next = next;
    }

    public void setPrev(LLVMScopeChain prev) {
        this.prev = prev;
    }

    public LLVMScopeChain getPrev() {
        return this.prev;
    }

    public IDGenerater.BitcodeID getId() {
        return this.id;
    }

    public LLVMScope getScope() {
        return this.scope;
    }

    @CompilerDirectives.TruffleBoundary
    public LLVMSymbol get(String name) {
        assert (this.scope != null);
        LLVMSymbol symbol = this.scope.get(name);
        if (symbol == null && this.next != null) {
            symbol = this.next.get(name);
        }
        return symbol;
    }

    @CompilerDirectives.TruffleBoundary
    public boolean contains(String name) {
        assert (this.scope != null);
        boolean contain = this.scope.contains(name);
        if (!contain && this.next != null) {
            contain = this.next.contains(name);
        }
        return contain;
    }

    @CompilerDirectives.TruffleBoundary
    public LLVMFunction getFunction(String name) {
        assert (this.scope != null);
        LLVMFunction function = this.scope.getFunction(name);
        if (function == null && this.next != null) {
            function = this.next.getFunction(name);
        }
        return function;
    }

    @CompilerDirectives.TruffleBoundary
    public synchronized void concatNextChain(LLVMScopeChain scopeChain) {
        assert (scopeChain.getPrev() == null && this.getNext() == null);
        this.setNext(scopeChain);
        scopeChain.setPrev(this);
    }

    @ExportMessage
    final boolean hasLanguage() {
        return true;
    }

    @ExportMessage
    final Class<? extends TruffleLanguage<?>> getLanguage() {
        return LLVMLanguage.class;
    }

    @ExportMessage
    final boolean isScope() {
        return this.scope != null && this.id != IDGenerater.INVALID_ID;
    }

    @ExportMessage
    public Object toDisplayString(boolean allowSideEffects) {
        return "llvm-scopechain";
    }

    @ExportMessage
    boolean hasMembers() {
        return this.isScope();
    }

    @ExportMessage
    Object getMembers(boolean includeInternal) {
        return this.getKeys();
    }

    @ExportMessage
    boolean isMemberReadable(String name) {
        return this.contains(name);
    }

    public Object getKeys() {
        return new ChainKeys(this);
    }

    @ExportMessage
    Object readMember(String symbolName, @Cached BranchProfile exception, @Cached LLVMDataEscapeNode.LLVMPointerDataEscapeNode escape, @CachedLibrary(value="this") InteropLibrary self) throws UnknownIdentifierException {
        LLVMSymbol symbol;
        if (this.contains(symbolName) && (symbol = this.get(symbolName)) != null) {
            try {
                LLVMPointer value = LLVMContext.get((Node)self).getSymbolResolved(symbol, exception);
                if (value != null) {
                    return escape.executeWithTarget(value);
                }
            }
            catch (LLVMIllegalSymbolIndexException | LLVMLinkerException lLVMException) {
                // empty catch block
            }
            exception.enter();
            throw UnknownIdentifierException.create((String)symbolName);
        }
        exception.enter();
        throw UnknownIdentifierException.create((String)symbolName);
    }

    @ExportLibrary(value=InteropLibrary.class)
    static final class ChainKeys
    implements TruffleObject {
        private LLVMScopeChain firstChain;

        private ChainKeys(LLVMScopeChain firstChain) {
            this.firstChain = firstChain;
        }

        @ExportMessage
        boolean hasArrayElements() {
            return true;
        }

        @ExportMessage
        long getArraySize() {
            assert (this.firstChain.getScope() != null);
            long size = 0L;
            for (LLVMScopeChain current = this.firstChain; current != null; current = current.getNext()) {
                size += current.getScope().getFunctionSize();
            }
            return size;
        }

        @ExportMessage
        boolean isArrayElementReadable(long index) {
            return 0L <= index && index < this.getArraySize();
        }

        @ExportMessage
        Object readArrayElement(long index, @Cached BranchProfile exception) throws InvalidArrayIndexException {
            if (this.isArrayElementReadable(index)) {
                long newIndex;
                assert (this.firstChain.getScope() != null);
                LLVMScopeChain current = this.firstChain;
                long currentSize = current.getScope().getFunctionSize();
                for (newIndex = index; currentSize <= newIndex; newIndex -= currentSize) {
                    if ((current = current.getNext()) == null) {
                        exception.enter();
                        throw new IllegalStateException();
                    }
                    currentSize = current.getScope().getFunctionSize();
                }
                return current.getScope().getKey((int)newIndex);
            }
            exception.enter();
            throw InvalidArrayIndexException.create((long)index);
        }
    }
}

