/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.metadata.debuginfo;

import com.oracle.truffle.llvm.parser.metadata.DwarfOpcode;
import com.oracle.truffle.llvm.parser.metadata.MDBaseNode;
import com.oracle.truffle.llvm.parser.metadata.MDCompileUnit;
import com.oracle.truffle.llvm.parser.metadata.MDExpression;
import com.oracle.truffle.llvm.parser.metadata.MDFile;
import com.oracle.truffle.llvm.parser.metadata.MDGlobalVariable;
import com.oracle.truffle.llvm.parser.metadata.MDGlobalVariableExpression;
import com.oracle.truffle.llvm.parser.metadata.MDLocalVariable;
import com.oracle.truffle.llvm.parser.metadata.MDNamedNode;
import com.oracle.truffle.llvm.parser.metadata.MDNode;
import com.oracle.truffle.llvm.parser.metadata.MDVoidNode;
import com.oracle.truffle.llvm.parser.metadata.MetadataValueList;
import com.oracle.truffle.llvm.parser.metadata.MetadataVisitor;
import com.oracle.truffle.llvm.parser.metadata.debuginfo.DebugInfoCache;
import com.oracle.truffle.llvm.parser.metadata.debuginfo.DebugInfoFunctionProcessor;
import com.oracle.truffle.llvm.parser.metadata.debuginfo.ImportsProcessor;
import com.oracle.truffle.llvm.parser.metadata.debuginfo.MDSymbolExtractor;
import com.oracle.truffle.llvm.parser.metadata.debuginfo.MDUpgrade;
import com.oracle.truffle.llvm.parser.model.ModelModule;
import com.oracle.truffle.llvm.parser.model.SymbolImpl;
import com.oracle.truffle.llvm.parser.model.symbols.constants.integer.BigIntegerConstant;
import com.oracle.truffle.llvm.parser.model.symbols.globals.GlobalValueSymbol;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceSymbol;
import com.oracle.truffle.llvm.runtime.debug.type.LLVMSourceStaticMemberType;
import com.oracle.truffle.llvm.runtime.debug.type.LLVMSourceType;
import com.oracle.truffle.llvm.runtime.types.VariableBitWidthType;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;

public final class DebugInfoModuleProcessor {
    private DebugInfoModuleProcessor() {
    }

    public static void processModule(ModelModule irModel, MetadataValueList metadata) {
        MDUpgrade.perform(metadata);
        DebugInfoCache cache = new DebugInfoCache(metadata, irModel.getSourceStaticMembers());
        ImportsProcessor.process(metadata, cache);
        DebugInfoModuleProcessor.processSymbols(irModel.getGlobalVariables(), cache, irModel);
        DebugInfoModuleProcessor.processSymbols(irModel.getAliases(), cache, irModel);
        MetadataProcessor mdParser = new MetadataProcessor(cache, irModel.getSourceGlobals(), irModel.getSourceStaticMembers());
        MDNamedNode cuNode = metadata.getNamedNode("llvm.dbg.cu");
        if (cuNode != null) {
            cuNode.accept(mdParser);
        }
        irModel.setFunctionProcessor(new DebugInfoFunctionProcessor(cache));
        FileProcessor fileProcessor = new FileProcessor(irModel);
        metadata.accept(fileProcessor);
    }

    private static void processSymbols(List<? extends GlobalValueSymbol> list, DebugInfoCache cache, ModelModule irModel) {
        for (GlobalValueSymbol globalValueSymbol : list) {
            LLVMSourceType sourceType;
            MDBaseNode declaration;
            MDBaseNode mdGlobal = DebugInfoCache.getDebugInfo(globalValueSymbol);
            if (mdGlobal == null) continue;
            boolean isGlobal = !(mdGlobal instanceof MDLocalVariable);
            LLVMSourceSymbol symbol = cache.getSourceSymbol(mdGlobal, isGlobal);
            if (symbol != null) {
                irModel.getSourceGlobals().put(symbol, globalValueSymbol);
                globalValueSymbol.setSourceSymbol(symbol);
            }
            if (mdGlobal instanceof MDGlobalVariableExpression) {
                mdGlobal = ((MDGlobalVariableExpression)mdGlobal).getGlobalVariable();
            }
            if (!(mdGlobal instanceof MDGlobalVariable) || (declaration = ((MDGlobalVariable)mdGlobal).getStaticMemberDeclaration()) == MDVoidNode.INSTANCE || !((sourceType = cache.parseType(declaration)) instanceof LLVMSourceStaticMemberType)) continue;
            irModel.getSourceStaticMembers().put((LLVMSourceStaticMemberType)sourceType, globalValueSymbol);
        }
    }

    private static final class MetadataProcessor
    implements MetadataVisitor {
        private final DebugInfoCache cache;
        private final Map<LLVMSourceSymbol, SymbolImpl> sourceGlobals;
        private final Map<LLVMSourceStaticMemberType, SymbolImpl> sourceStaticMembers;

        MetadataProcessor(DebugInfoCache cache, Map<LLVMSourceSymbol, SymbolImpl> sourceGlobals, Map<LLVMSourceStaticMemberType, SymbolImpl> sourceStaticMembers) {
            this.cache = cache;
            this.sourceGlobals = sourceGlobals;
            this.sourceStaticMembers = sourceStaticMembers;
        }

        @Override
        public void visit(MDNamedNode md) {
            for (MDBaseNode node : md) {
                node.accept(this);
            }
        }

        @Override
        public void visit(MDNode md) {
            for (MDBaseNode node : md) {
                node.accept(this);
            }
        }

        @Override
        public void visit(MDCompileUnit md) {
            md.getGlobalVariables().accept(this);
        }

        @Override
        public void visit(MDGlobalVariableExpression md) {
            SymbolImpl value;
            LLVMSourceSymbol symbol = this.cache.getSourceSymbol(md, true);
            MDBaseNode var = md.getExpression();
            if (var instanceof MDExpression && !MDExpression.EMPTY.equals(var) && (value = MetadataProcessor.getSymbol((MDExpression)var, (int)symbol.getType().getSize())) != null) {
                this.sourceGlobals.put(symbol, value);
            }
        }

        @Override
        public void visit(MDGlobalVariable md) {
            LLVMSourceStaticMemberType memberType;
            LLVMSourceType sourceType;
            MDBaseNode declaration;
            LLVMSourceSymbol symbol = this.cache.getSourceSymbol(md, true);
            if (md.getVariable() == MDVoidNode.INSTANCE || this.sourceGlobals.containsKey(symbol)) {
                return;
            }
            SymbolImpl value = MDSymbolExtractor.getSymbol(md.getVariable());
            if (value != null || !this.sourceGlobals.containsKey(symbol)) {
                this.sourceGlobals.put(symbol, value);
            }
            if ((declaration = md.getStaticMemberDeclaration()) != MDVoidNode.INSTANCE && (sourceType = this.cache.parseType(declaration)) instanceof LLVMSourceStaticMemberType && !this.sourceStaticMembers.containsKey(memberType = (LLVMSourceStaticMemberType)sourceType)) {
                this.sourceStaticMembers.put((LLVMSourceStaticMemberType)sourceType, value);
            }
        }

        @Override
        public void visit(MDLocalVariable md) {
            this.cache.getSourceSymbol(md, false);
        }

        private static SymbolImpl getSymbol(MDExpression expr, int typeSize) {
            BigInteger val = DwarfOpcode.toIntegerSymbol(expr);
            if (val != null) {
                return new BigIntegerConstant(new VariableBitWidthType(typeSize), val);
            }
            return null;
        }
    }

    private static final class FileProcessor
    implements MetadataVisitor {
        private final ModelModule module;

        FileProcessor(ModelModule module) {
            this.module = module;
        }

        @Override
        public void visit(MDFile md) {
            this.module.addSourceFileReference(md.toSourceFileReference());
        }
    }
}

