/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.metadata;

import com.oracle.truffle.llvm.parser.listeners.Metadata;
import com.oracle.truffle.llvm.parser.metadata.MDBaseNode;
import com.oracle.truffle.llvm.parser.metadata.MDNamedLocation;
import com.oracle.truffle.llvm.parser.metadata.MetadataValueList;
import com.oracle.truffle.llvm.parser.metadata.MetadataVisitor;
import com.oracle.truffle.llvm.parser.metadata.ParseUtil;

public final class MDNamespace
extends MDNamedLocation
implements MDBaseNode {
    private static final int ARGINDEX_SCOPE = 1;
    private static final int ARGINDEX_38_FILE = 2;
    private static final int ARGINDEX_38_NAME = 3;
    private static final int ARGINDEX_38_LINE = 4;
    private static final int RECORDSIZE_50 = 3;
    private static final int ARGINDEX_50_NAME = 2;
    private static final int ARGINDEX_32_NAME = 2;
    private static final int ARGINDEX_32_FILE = 3;
    private static final int ARGINDEX_32_LINE = 4;

    private MDNamespace(long line) {
        super(line);
    }

    @Override
    public void accept(MetadataVisitor visitor) {
        visitor.visit(this);
    }

    public static MDNamespace create38(long[] args, MetadataValueList md) {
        if (3 != args.length) {
            long line = args[4];
            MDNamespace namespace = new MDNamespace(line);
            namespace.setFile(md.getNullable(args[2], namespace));
            namespace.setScope(md.getNullable(args[1], namespace));
            namespace.setName(md.getNullable(args[3], namespace));
            return namespace;
        }
        long line = -1L;
        MDNamespace namespace = new MDNamespace(-1L);
        namespace.setScope(md.getNullable(args[1], namespace));
        namespace.setName(md.getNullable(args[2], namespace));
        return namespace;
    }

    public static MDNamespace create32(long[] args, Metadata md) {
        long line = ParseUtil.asLong(args, 4, md);
        MDNamespace namespace = new MDNamespace(line);
        namespace.setScope(ParseUtil.resolveReference(args, 1, namespace, md));
        namespace.setFile(ParseUtil.resolveReference(args, 3, namespace, md));
        namespace.setName(ParseUtil.resolveReference(args, 2, namespace, md));
        return namespace;
    }
}

