/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.initialization;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.llvm.parser.LLVMParser;
import com.oracle.truffle.llvm.parser.LLVMParserResult;
import com.oracle.truffle.llvm.parser.model.symbols.globals.GlobalVariable;
import com.oracle.truffle.llvm.runtime.datalayout.DataLayout;
import com.oracle.truffle.llvm.runtime.types.PrimitiveType;
import com.oracle.truffle.llvm.runtime.types.StructureType;
import com.oracle.truffle.llvm.runtime.types.Type;
import java.util.ArrayList;
import java.util.List;

public class DataSectionFactory {
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final int[] globalOffsets;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final int[] threadLocalGlobalOffsets;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final boolean[] globalIsReadOnly;
    private DataSection roSection;
    private DataSection rwSection;
    private DataSection threadLocalSection;
    private int globalContainerIndex = -1;
    private int threadLocalGlobalContainerLength = 0;

    public DataSectionFactory(LLVMParserResult result) throws Type.TypeOverflowException {
        Type type;
        int i;
        DataLayout dataLayout = result.getDataLayout();
        int globalsCount = result.getDefinedGlobals().size();
        int threadLocalGlobalsCount = result.getThreadLocalGlobals().size();
        boolean boxGlobals = result.getRuntime().getNodeFactory().boxGlobals();
        this.globalOffsets = new int[globalsCount];
        this.threadLocalGlobalOffsets = new int[threadLocalGlobalsCount];
        this.globalIsReadOnly = new boolean[globalsCount];
        List<GlobalVariable> definedGlobals = result.getDefinedGlobals();
        List<GlobalVariable> threadLocalGlobals = result.getThreadLocalGlobals();
        this.roSection = new DataSection(dataLayout);
        this.rwSection = new DataSection(dataLayout);
        this.threadLocalSection = new DataSection(dataLayout);
        for (i = 0; i < globalsCount; ++i) {
            GlobalVariable global = definedGlobals.get(i);
            type = global.getType().getPointeeType();
            this.globalIsReadOnly[i] = global.isReadOnly();
            if (boxGlobals && LLVMParser.isSpecialGlobalSlot(type)) {
                this.globalOffsets[i] = -1;
                continue;
            }
            if (type.getSize(dataLayout) == 0L) {
                type = PrimitiveType.getIntegerType(8);
            }
            DataSection dataSection = this.globalIsReadOnly[i] ? this.roSection : this.rwSection;
            long offset = dataSection.add(global, type);
            assert (offset >= 0L);
            if (offset > Integer.MAX_VALUE) {
                throw CompilerDirectives.shouldNotReachHere((String)"globals section >2GB not supported");
            }
            this.globalOffsets[i] = (int)offset;
        }
        for (i = 0; i < threadLocalGlobalsCount; ++i) {
            GlobalVariable tlGlobals = threadLocalGlobals.get(i);
            type = tlGlobals.getType().getPointeeType();
            if (LLVMParser.isSpecialGlobalSlot(type)) {
                ++this.threadLocalGlobalContainerLength;
                this.threadLocalGlobalOffsets[i] = this.globalContainerIndex--;
                continue;
            }
            long offset = this.threadLocalSection.add(tlGlobals, type);
            assert (offset >= 0L);
            if (offset > Integer.MAX_VALUE) {
                throw CompilerDirectives.shouldNotReachHere((String)"globals section >2GB not supported");
            }
            this.threadLocalGlobalOffsets[i] = (int)offset;
        }
    }

    DataSection getRoSection() {
        return this.roSection;
    }

    DataSection getRwSection() {
        return this.rwSection;
    }

    DataSection getThreadLocalSection() {
        return this.threadLocalSection;
    }

    int[] getGlobalOffsets() {
        return this.globalOffsets;
    }

    boolean[] getGlobalIsReadOnly() {
        return this.globalIsReadOnly;
    }

    int[] getThreadLocalGlobalOffsets() {
        return this.threadLocalGlobalOffsets;
    }

    int getThreadLocalGlobalContainerLength() {
        return this.threadLocalGlobalContainerLength;
    }

    private static void addPaddingTypes(ArrayList<Type> result, int padding) {
        int size;
        assert (padding >= 0);
        for (int remaining = padding; remaining > 0; remaining -= size) {
            size = Math.min(8, Integer.highestOneBit(remaining));
            result.add(PrimitiveType.getIntegerType(size * 8));
        }
    }

    private static int getAlignment(DataLayout dataLayout, GlobalVariable global, Type type) {
        return global.getAlign() > 0 ? 1 << global.getAlign() - 1 : type.getAlignment(dataLayout);
    }

    static final class DataSection {
        final DataLayout dataLayout;
        final ArrayList<Type> types = new ArrayList();
        private long offset = 0L;

        DataSection(DataLayout dataLayout) {
            this.dataLayout = dataLayout;
        }

        long add(GlobalVariable global, Type type) throws Type.TypeOverflowException {
            int alignment = DataSectionFactory.getAlignment(this.dataLayout, global, type);
            int padding = Type.getPadding(this.offset, alignment);
            DataSectionFactory.addPaddingTypes(this.types, padding);
            long ret = this.offset = Type.addUnsignedExact(this.offset, padding);
            this.types.add(type);
            this.offset = Type.addUnsignedExact(this.offset, type.getSize(this.dataLayout));
            return ret;
        }

        StructureType getStructureType(String typeName) {
            if (this.offset > 0L) {
                return StructureType.createNamedFromList(typeName, true, this.types);
            }
            return null;
        }
    }
}

