/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.types;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.llvm.runtime.CommonNodeFactory;
import com.oracle.truffle.llvm.runtime.GetStackSpaceFactory;
import com.oracle.truffle.llvm.runtime.NodeFactory;
import com.oracle.truffle.llvm.runtime.datalayout.DataLayout;
import com.oracle.truffle.llvm.runtime.except.LLVMParserException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.types.Type;
import com.oracle.truffle.llvm.runtime.types.visitors.TypeVisitor;
import java.math.BigInteger;

public final class VariableBitWidthType
extends Type {
    public static final int MIN_INT_BITS = 1;
    public static final int MAX_INT_BITS = 0xFFFFFF;
    private final int bitWidth;
    private final Object constant;

    public VariableBitWidthType(int bitWidth) {
        this(bitWidth, null);
    }

    VariableBitWidthType(int bitWidth, Object constant) {
        if (bitWidth < 1 || bitWidth > 0xFFFFFF) {
            throw new LLVMParserException(this.getClass().getSimpleName() + " out of range: " + bitWidth);
        }
        this.bitWidth = bitWidth;
        this.constant = constant;
    }

    public Object getConstant() {
        return this.constant;
    }

    public boolean isConstant() {
        return this.constant != null;
    }

    @Override
    public long getBitSize() {
        return this.bitWidth;
    }

    public int getBitSizeInt() {
        return this.bitWidth;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.bitWidth;
        result = 31 * result + (this.constant == null ? 0 : this.constant.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VariableBitWidthType other = (VariableBitWidthType)obj;
        if (this.bitWidth != other.bitWidth) {
            return false;
        }
        return !(this.constant == null ? other.constant != null : !this.constant.equals(other.constant));
    }

    @Override
    public void accept(TypeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public int getAlignment(DataLayout targetDataLayout) {
        if (targetDataLayout != null) {
            return targetDataLayout.getBitAlignment(this) / 8;
        }
        if (this.bitWidth <= 8) {
            return 1;
        }
        if (this.bitWidth <= 16) {
            return 2;
        }
        if (this.bitWidth <= 32) {
            return 4;
        }
        return 8;
    }

    @Override
    public long getSize(DataLayout targetDataLayout) {
        try {
            return targetDataLayout.getSize(this);
        }
        catch (Type.TypeOverflowException e) {
            throw new AssertionError((Object)e);
        }
    }

    public int getSizeInt(DataLayout targetDataLayout) {
        long size = this.getSize(targetDataLayout);
        assert ((long)((int)size) == size);
        return (int)size;
    }

    @CompilerDirectives.TruffleBoundary
    public String toString() {
        if (this.getConstant() != null) {
            return String.format("i%d %s", this.getBitSize(), this.getConstant());
        }
        return String.format("i%d", this.getBitSize());
    }

    @Override
    public LLVMExpressionNode createNullConstant(NodeFactory nodeFactory, DataLayout dataLayout, GetStackSpaceFactory stackFactory) {
        return CommonNodeFactory.createSimpleConstantNoArray(BigInteger.ZERO, this);
    }
}

