/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.llvm.runtime.except.LLVMPolyglotException;
import com.oracle.truffle.llvm.runtime.interop.LLVMAsForeignNode;
import com.oracle.truffle.llvm.runtime.interop.LLVMDataEscapeNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMLazyException;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMPolyglotWriteFactory;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMReadStringNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMIntrinsic;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.types.Type;

public final class LLVMPolyglotWrite {

    @NodeChildren(value={@NodeChild(type=LLVMExpressionNode.class), @NodeChild(type=LLVMExpressionNode.class), @NodeChild(type=LLVMExpressionNode.class)})
    public static abstract class LLVMPolyglotSetArrayElement
    extends LLVMIntrinsic {
        @Node.Child
        LLVMDataEscapeNode prepareValueForEscape;

        public static LLVMExpressionNode create(Type[] argTypes, LLVMExpressionNode target, LLVMExpressionNode idx, LLVMExpressionNode value) {
            if (argTypes.length != 4) {
                return LLVMLazyException.createExpressionNode((node, ex) -> new LLVMPolyglotException(node, "polyglot_set_array_element must be called with exactly 3 arguments."), null);
            }
            return LLVMPolyglotWriteFactory.LLVMPolyglotSetArrayElementNodeGen.create(argTypes, target, idx, value);
        }

        LLVMPolyglotSetArrayElement(Type[] argTypes) {
            this.prepareValueForEscape = LLVMDataEscapeNode.create(argTypes[3]);
        }

        @Specialization
        @GenerateAOT.Exclude
        protected Object doIntrinsic(LLVMManagedPointer target, int id, Object value, @Cached LLVMAsForeignNode asForeign, @CachedLibrary(limit="3") InteropLibrary foreignWrite, @Cached BranchProfile exception) {
            Object foreign = asForeign.execute(target);
            Object escapedValue = this.prepareValueForEscape.executeWithTarget(value);
            try {
                foreignWrite.writeArrayElement(foreign, (long)id, escapedValue);
            }
            catch (UnsupportedMessageException e) {
                exception.enter();
                throw new LLVMPolyglotException((Node)foreignWrite, "Cannot write to index %d of polyglot value.", id);
            }
            catch (InvalidArrayIndexException e) {
                exception.enter();
                throw new LLVMPolyglotException((Node)foreignWrite, "Index %d does not exist.", id);
            }
            catch (UnsupportedTypeException e) {
                exception.enter();
                throw new LLVMPolyglotException((Node)foreignWrite, "Unsupported type writing index %d.", id);
            }
            return null;
        }

        @CompilerDirectives.TruffleBoundary
        @Fallback
        public Object fallback(Object value, Object id, Object v) {
            throw new LLVMPolyglotException(this, "Invalid argument to polyglot builtin.");
        }
    }

    @NodeChildren(value={@NodeChild(type=LLVMExpressionNode.class), @NodeChild(type=LLVMExpressionNode.class), @NodeChild(type=LLVMExpressionNode.class)})
    public static abstract class LLVMPolyglotPutMember
    extends LLVMIntrinsic {
        @Node.Child
        LLVMDataEscapeNode prepareValueForEscape;

        public static LLVMExpressionNode create(Type[] argTypes, LLVMExpressionNode target, LLVMExpressionNode id, LLVMExpressionNode value) {
            if (argTypes.length != 4) {
                return LLVMLazyException.createExpressionNode((node, ex) -> new LLVMPolyglotException(node, "polyglot_put_member must be called with exactly 3 arguments."), null);
            }
            return LLVMPolyglotWriteFactory.LLVMPolyglotPutMemberNodeGen.create(argTypes, target, id, value);
        }

        LLVMPolyglotPutMember(Type[] argTypes) {
            this.prepareValueForEscape = LLVMDataEscapeNode.create(argTypes[3]);
        }

        @Specialization
        @GenerateAOT.Exclude
        protected void doIntrinsic(LLVMManagedPointer target, Object id, Object value, @Cached LLVMAsForeignNode asForeign, @CachedLibrary(limit="3") InteropLibrary foreignWrite, @Cached(value="createReadString()") LLVMReadStringNode readStr, @Cached BranchProfile exception) {
            Object foreign = asForeign.execute(target);
            String name = readStr.executeWithTarget(id);
            Object escapedValue = this.prepareValueForEscape.executeWithTarget(value);
            try {
                foreignWrite.writeMember(foreign, name, escapedValue);
            }
            catch (UnsupportedMessageException e) {
                exception.enter();
                throw new LLVMPolyglotException((Node)foreignWrite, "Cannot write member '%s' to polyglot value.", name);
            }
            catch (UnknownIdentifierException e) {
                exception.enter();
                throw new LLVMPolyglotException((Node)foreignWrite, "Member '%s' does not exist.", e.getUnknownIdentifier());
            }
            catch (UnsupportedTypeException e) {
                exception.enter();
                throw new LLVMPolyglotException((Node)foreignWrite, "Unsupported type writing member '%s'.", name);
            }
        }

        @CompilerDirectives.TruffleBoundary
        @Fallback
        public Object fallback(Object value, Object id, Object v) {
            throw new LLVMPolyglotException(this, "Invalid argument to polyglot builtin.");
        }
    }
}

