/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop;

import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMAsForeignLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMIntrinsic;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;

@NodeChild(value="object", type=LLVMExpressionNode.class)
public abstract class LLVMPolyglotBoxedPredicate
extends LLVMIntrinsic {
    final Predicate predicate;
    @Node.Child
    InteropLibrary stringInterop = (InteropLibrary)InteropLibrary.getFactory().create((Object)"");

    protected LLVMPolyglotBoxedPredicate(Predicate predicate) {
        this.predicate = predicate;
    }

    @Specialization(guards={"!foreigns.isForeign(pointer)"})
    @GenerateAOT.Exclude
    boolean matchNonForeignManaged(LLVMManagedPointer pointer, @CachedLibrary(limit="3") LLVMAsForeignLibrary foreigns, @CachedLibrary(limit="3") InteropLibrary interop) {
        return this.predicate.match(interop, pointer);
    }

    @Specialization(guards={"foreigns.isForeign(pointer)"})
    @GenerateAOT.Exclude
    boolean matchForeignManaged(LLVMManagedPointer pointer, @CachedLibrary(limit="3") LLVMAsForeignLibrary foreigns, @CachedLibrary(limit="3") InteropLibrary interop) {
        Object foreign = foreigns.asForeign(pointer.getObject());
        assert (foreign != null);
        return this.predicate.match(interop, foreign);
    }

    @Specialization
    @GenerateAOT.Exclude
    boolean matchNative(LLVMNativePointer pointer, @CachedLibrary(limit="3") InteropLibrary interop) {
        return this.predicate.match(interop, pointer);
    }

    @Specialization
    boolean matchString(String str) {
        return this.predicate.match(this.stringInterop, str);
    }

    @Fallback
    public boolean fallback(Object object) {
        return false;
    }

    @FunctionalInterface
    public static interface Predicate {
        public boolean match(InteropLibrary var1, Object var2);
    }
}

