/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.cast;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeField;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.llvm.runtime.LLVMIVarBit;
import com.oracle.truffle.llvm.runtime.LLVMIVarBitLarge;
import com.oracle.truffle.llvm.runtime.LLVMIVarBitSmall;
import com.oracle.truffle.llvm.runtime.floating.LLVM128BitFloat;
import com.oracle.truffle.llvm.runtime.floating.LLVM80BitFloat;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToNativeNode;
import com.oracle.truffle.llvm.runtime.nodes.cast.LLVMToVarINodeGen;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.vector.LLVMI1Vector;

@NodeChild(value="fromNode", type=LLVMExpressionNode.class)
@NodeField(type=int.class, name="bits")
public abstract class LLVMToVarINode
extends LLVMExpressionNode {
    protected final boolean isRecursive;

    protected LLVMToVarINode() {
        this(false);
    }

    protected LLVMToVarINode(boolean isRecursive) {
        this.isRecursive = isRecursive;
    }

    public abstract int getBits();

    protected abstract LLVMIVarBit executeWith(long var1);

    protected LLVMToVarINode createRecursive() {
        throw new IllegalStateException("abstract node LLVMToVarINode used");
    }

    @Specialization(guards={"!isRecursive"})
    protected LLVMIVarBit doPointer(LLVMPointer from, @Cached(value="createToNativeWithTarget()") LLVMToNativeNode toNative, @Cached(value="createRecursive()") LLVMToVarINode recursive) {
        long ptr = toNative.executeWithTarget(from).asNative();
        return recursive.executeWith(ptr);
    }

    public static abstract class LLVMBitcastToIVarNode
    extends LLVMToVarINode {
        public LLVMBitcastToIVarNode() {
        }

        public LLVMBitcastToIVarNode(boolean isRecursive) {
            super(isRecursive);
        }

        @Override
        protected LLVMToVarINode createRecursive() {
            return LLVMToVarINodeGen.LLVMBitcastToIVarNodeGen.create(true, null, this.getBits());
        }

        @Specialization
        protected LLVMIVarBit doBoolean(boolean from) {
            return from ? LLVMIVarBit.fromInt(this.getBits(), 1) : LLVMIVarBit.fromInt(this.getBits(), 0);
        }

        @Specialization
        protected LLVMIVarBit doI8(byte from) {
            return LLVMIVarBit.fromByte(this.getBits(), from);
        }

        @Specialization
        protected LLVMIVarBit doI16(short from) {
            return LLVMIVarBit.fromShort(this.getBits(), from);
        }

        @Specialization
        protected LLVMIVarBit doI32(int from) {
            return LLVMIVarBit.fromInt(this.getBits(), from);
        }

        @Specialization
        protected LLVMIVarBit doI64(long from) {
            return LLVMIVarBit.fromLong(this.getBits(), from);
        }

        @Specialization
        protected LLVMIVarBit doIVarBit(LLVMIVarBit from) {
            return from;
        }

        @Specialization
        protected LLVMIVarBit doFloat(float from) {
            return LLVMIVarBit.fromInt(this.getBits(), Float.floatToIntBits(from));
        }

        @Specialization
        protected LLVMIVarBit doDouble(double from) {
            return LLVMIVarBit.fromLong(this.getBits(), Double.doubleToLongBits(from));
        }

        @Specialization
        protected LLVMIVarBit do80BitFloat(LLVM80BitFloat from) {
            assert (this.getBits() == 80);
            return LLVMIVarBit.create(this.getBits(), from.getBytesBigEndian(), 80, true);
        }

        @Specialization
        protected LLVMIVarBit do128BitFloat(LLVM128BitFloat from) {
            assert (this.getBits() == 128);
            return LLVMIVarBit.create(this.getBits(), from.getBytesBigEndian(), 128, true);
        }

        @Specialization
        @ExplodeLoop
        protected LLVMIVarBit doI1Vector(LLVMI1Vector from) {
            assert (this.getBits() == from.getLength());
            return LLVMIVarBit.fromI1Vector(this.getBits(), from);
        }
    }

    public static abstract class LLVMUnsignedCastToIVarNode
    extends LLVMToVarINode {
        public LLVMUnsignedCastToIVarNode() {
        }

        public LLVMUnsignedCastToIVarNode(boolean isRecursive) {
            super(isRecursive);
        }

        @Override
        protected LLVMToVarINode createRecursive() {
            return LLVMToVarINodeGen.LLVMUnsignedCastToIVarNodeGen.create(true, null, this.getBits());
        }

        @Specialization
        protected LLVMIVarBit doBoolean(boolean from) {
            return from ? LLVMIVarBit.createZeroExt(this.getBits(), 1) : LLVMIVarBit.createZeroExt(this.getBits(), 0);
        }

        @Specialization
        protected LLVMIVarBit doI8(byte from) {
            return LLVMIVarBit.createZeroExt(this.getBits(), from);
        }

        @Specialization
        protected LLVMIVarBit doI16(short from) {
            return LLVMIVarBit.createZeroExt(this.getBits(), from);
        }

        @Specialization
        protected LLVMIVarBit doI32(int from) {
            return LLVMIVarBit.createZeroExt(this.getBits(), from);
        }

        @Specialization
        protected LLVMIVarBit doI64(long from) {
            return LLVMIVarBit.createZeroExt(this.getBits(), from);
        }

        @Specialization
        protected LLVMIVarBit doIVarBit(LLVMIVarBitLarge from) {
            return LLVMIVarBit.create(this.getBits(), from.getBytes(), from.getBitSize(), false);
        }

        @Specialization
        protected LLVMIVarBit doIVarBit(LLVMIVarBitSmall from) {
            return LLVMIVarBit.create(this.getBits(), from.getCleanedValue(false), from.getBitSize(), false);
        }
    }

    public static abstract class LLVMSignedCastToIVarNode
    extends LLVMToVarINode {
        public LLVMSignedCastToIVarNode() {
        }

        public LLVMSignedCastToIVarNode(boolean isRecursive) {
            super(isRecursive);
        }

        @Override
        protected LLVMToVarINode createRecursive() {
            return LLVMToVarINodeGen.LLVMSignedCastToIVarNodeGen.create(true, null, this.getBits());
        }

        @Specialization
        protected LLVMIVarBit doBoolean(boolean from) {
            return from ? LLVMIVarBit.fromInt(this.getBits(), -1) : LLVMIVarBit.fromInt(this.getBits(), 0);
        }

        @Specialization
        protected LLVMIVarBit doI8(byte from) {
            return LLVMIVarBit.fromByte(this.getBits(), from);
        }

        @Specialization
        protected LLVMIVarBit doI16(short from) {
            return LLVMIVarBit.fromShort(this.getBits(), from);
        }

        @Specialization
        protected LLVMIVarBit doI32(int from) {
            return LLVMIVarBit.fromInt(this.getBits(), from);
        }

        @Specialization
        protected LLVMIVarBit doI64(long from) {
            return LLVMIVarBit.fromLong(this.getBits(), from);
        }

        @Specialization
        protected LLVMIVarBit doIVarBit(LLVMIVarBitLarge from) {
            return LLVMIVarBit.create(this.getBits(), from.getSignExtendedBytes(), from.getBitSize(), true);
        }

        @Specialization
        protected LLVMIVarBit doIVarBit(LLVMIVarBitSmall from) {
            return LLVMIVarBit.create(this.getBits(), from.getCleanedValue(true), from.getBitSize(), true);
        }

        @Specialization
        protected LLVMIVarBit do80BitFloat(LLVM80BitFloat from) {
            return LLVMIVarBit.create(this.getBits(), from.getBytesBigEndian(), 80, true);
        }

        @Specialization
        protected LLVMIVarBit do128BitFloat(LLVM128BitFloat from) {
            return LLVMIVarBit.create(this.getBits(), from.getBytesBigEndian(), 128, true);
        }
    }
}

