/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.asm.support;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.asm.support.LLVMAMD64Target;
import com.oracle.truffle.llvm.runtime.nodes.asm.support.LLVMAMD64WriteValueNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.util.concurrent.locks.ReentrantLock;

@GeneratedBy(value=LLVMAMD64WriteValueNode.class)
public final class LLVMAMD64WriteValueNodeGen
extends LLVMAMD64WriteValueNode
implements GenerateAOT.Provider {
    @CompilerDirectives.CompilationFinal
    private int state_0_;

    private LLVMAMD64WriteValueNodeGen(LLVMAMD64Target dst) {
        super(dst);
    }

    @Override
    public void execute(VirtualFrame frameValue, Object arg0Value) {
        int state_0 = this.state_0_;
        if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
            this.executeAndSpecialize(frameValue, arg0Value);
            return;
        }
        if ((state_0 & 0x3E) != 0) {
            if ((state_0 & 2) != 0 && arg0Value instanceof Byte) {
                byte arg0Value_ = (Byte)arg0Value;
                this.doI8(frameValue, arg0Value_);
                return;
            }
            if ((state_0 & 4) != 0 && arg0Value instanceof Short) {
                short arg0Value_ = (Short)arg0Value;
                this.doI16(frameValue, arg0Value_);
                return;
            }
            if ((state_0 & 8) != 0 && arg0Value instanceof Integer) {
                int arg0Value_ = (Integer)arg0Value;
                this.doI32(frameValue, arg0Value_);
                return;
            }
            if ((state_0 & 0x10) != 0 && arg0Value instanceof Long) {
                long arg0Value_ = (Long)arg0Value;
                this.doI64(frameValue, arg0Value_);
                return;
            }
            if ((state_0 & 0x20) != 0 && LLVMTypes.isPointer(arg0Value)) {
                LLVMPointer arg0Value_ = LLVMTypes.asPointer(arg0Value);
                this.doAddress(frameValue, arg0Value_);
                return;
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        this.executeAndSpecialize(frameValue, arg0Value);
    }

    private void executeAndSpecialize(VirtualFrame frameValue, Object arg0Value) {
        int state_0 = this.state_0_;
        if ((state_0 & 1) != 0) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (arg0Value instanceof Byte) {
            byte arg0Value_ = (Byte)arg0Value;
            this.state_0_ = state_0 |= 2;
            this.doI8(frameValue, arg0Value_);
            return;
        }
        if (arg0Value instanceof Short) {
            short arg0Value_ = (Short)arg0Value;
            this.state_0_ = state_0 |= 4;
            this.doI16(frameValue, arg0Value_);
            return;
        }
        if (arg0Value instanceof Integer) {
            int arg0Value_ = (Integer)arg0Value;
            this.state_0_ = state_0 |= 8;
            this.doI32(frameValue, arg0Value_);
            return;
        }
        if (arg0Value instanceof Long) {
            long arg0Value_ = (Long)arg0Value;
            this.state_0_ = state_0 |= 0x10;
            this.doI64(frameValue, arg0Value_);
            return;
        }
        if (LLVMTypes.isPointer(arg0Value)) {
            LLVMPointer arg0Value_ = LLVMTypes.asPointer(arg0Value);
            this.state_0_ = state_0 |= 0x20;
            this.doAddress(frameValue, arg0Value_);
            return;
        }
        throw new UnsupportedSpecializationException((Node)this, null, new Object[]{arg0Value});
    }

    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
        if ((this.state_0_ & 1) != 0) {
            return;
        }
        this.state_0_ |= 2;
        this.state_0_ |= 4;
        this.state_0_ |= 8;
        this.state_0_ |= 0x10;
        this.state_0_ |= 0x20;
        int state_0 = this.state_0_;
        this.state_0_ = state_0 |= 1;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if ((state_0 & 1) == 0) {
            return;
        }
        this.state_0_ = 0;
    }

    @NeverDefault
    public static LLVMAMD64WriteValueNode create(LLVMAMD64Target dst) {
        return new LLVMAMD64WriteValueNodeGen(dst);
    }
}

