/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.asm;

import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStatementNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.support.LLVMAMD64WriteValueNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI16StoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI32StoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI64StoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI8StoreNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

@NodeChildren(value={@NodeChild(value="rax", type=LLVMExpressionNode.class), @NodeChild(value="rdi", type=LLVMExpressionNode.class), @NodeChild(value="df", type=LLVMExpressionNode.class)})
public abstract class LLVMAMD64StosNode
extends LLVMStatementNode {
    @Node.Child
    protected LLVMAMD64WriteValueNode writeRDI;

    public LLVMAMD64StosNode(LLVMAMD64WriteValueNode writeRDI) {
        this.writeRDI = writeRDI;
    }

    public static abstract class LLVMAMD64StosqNode
    extends LLVMAMD64StosNode {
        @Node.Child
        protected LLVMI64StoreNode store = LLVMI64StoreNode.create();

        public LLVMAMD64StosqNode(LLVMAMD64WriteValueNode writeRDI) {
            super(writeRDI);
        }

        @Specialization
        protected void opI8(VirtualFrame frame, long al, long rdi, boolean df) {
            this.store.executeWithTarget(LLVMNativePointer.create(rdi), al);
            this.writeRDI.execute(frame, rdi + (long)(df ? -8 : 8));
        }

        @Specialization
        protected void opI8(VirtualFrame frame, long al, LLVMPointer rdi, boolean df) {
            this.store.executeWithTarget(rdi, al);
            this.writeRDI.execute(frame, rdi.increment(df ? -8L : 8L));
        }
    }

    public static abstract class LLVMAMD64StosdNode
    extends LLVMAMD64StosNode {
        @Node.Child
        protected LLVMI32StoreNode store = LLVMI32StoreNode.create();

        public LLVMAMD64StosdNode(LLVMAMD64WriteValueNode writeRDI) {
            super(writeRDI);
        }

        @Specialization
        protected void opI8(VirtualFrame frame, int al, long rdi, boolean df) {
            this.store.executeWithTarget(LLVMNativePointer.create(rdi), al);
            this.writeRDI.execute(frame, rdi + (long)(df ? -4 : 4));
        }

        @Specialization
        protected void opI8(VirtualFrame frame, int al, LLVMPointer rdi, boolean df) {
            this.store.executeWithTarget(rdi, al);
            this.writeRDI.execute(frame, rdi.increment(df ? -4L : 4L));
        }
    }

    public static abstract class LLVMAMD64StoswNode
    extends LLVMAMD64StosNode {
        @Node.Child
        protected LLVMI16StoreNode store = LLVMI16StoreNode.create();

        public LLVMAMD64StoswNode(LLVMAMD64WriteValueNode writeRDI) {
            super(writeRDI);
        }

        @Specialization
        protected void opI8(VirtualFrame frame, short al, long rdi, boolean df) {
            this.store.executeWithTarget(LLVMNativePointer.create(rdi), al);
            this.writeRDI.execute(frame, rdi + (long)(df ? -2 : 2));
        }

        @Specialization
        protected void opI8(VirtualFrame frame, short al, LLVMPointer rdi, boolean df) {
            this.store.executeWithTarget(rdi, al);
            this.writeRDI.execute(frame, rdi.increment(df ? -2L : 2L));
        }
    }

    public static abstract class LLVMAMD64StosbNode
    extends LLVMAMD64StosNode {
        @Node.Child
        protected LLVMI8StoreNode store = LLVMI8StoreNode.create();

        public LLVMAMD64StosbNode(LLVMAMD64WriteValueNode writeRDI) {
            super(writeRDI);
        }

        @Specialization
        protected void opI8(VirtualFrame frame, byte al, long rdi, boolean df) {
            this.store.executeWithTarget(LLVMNativePointer.create(rdi), al);
            this.writeRDI.execute(frame, rdi + (long)(df ? -1 : 1));
        }

        @Specialization
        protected void opI8(VirtualFrame frame, byte al, LLVMPointer rdi, boolean df) {
            this.store.executeWithTarget(rdi, al);
            this.writeRDI.execute(frame, rdi.increment(df ? -1L : 1L));
        }
    }
}

