/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.asm;

import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.CountingConditionProfile;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.support.LLVMAMD64WriteBooleanNode;

@NodeChildren(value={@NodeChild(value="src"), @NodeChild(value="dst")})
public abstract class LLVMAMD64BsfNode
extends LLVMExpressionNode {
    @Node.Child
    protected LLVMAMD64WriteBooleanNode writeZFNode;
    protected final CountingConditionProfile profile;

    public LLVMAMD64BsfNode(LLVMAMD64WriteBooleanNode writeZFNode) {
        this.writeZFNode = writeZFNode;
        this.profile = CountingConditionProfile.create();
    }

    public static abstract class LLVMAMD64BsfqNode
    extends LLVMAMD64BsfNode {
        public LLVMAMD64BsfqNode(LLVMAMD64WriteBooleanNode writeZFNode) {
            super(writeZFNode);
        }

        @Specialization
        protected long doI64(VirtualFrame frame, long src, long dst) {
            if (this.profile.profile(src == 0L)) {
                this.writeZFNode.execute(frame, true);
                return dst;
            }
            this.writeZFNode.execute(frame, false);
            return Long.numberOfTrailingZeros(src);
        }
    }

    public static abstract class LLVMAMD64BsflNode
    extends LLVMAMD64BsfNode {
        public LLVMAMD64BsflNode(LLVMAMD64WriteBooleanNode writeZFNode) {
            super(writeZFNode);
        }

        @Specialization
        protected int doI32(VirtualFrame frame, int src, int dst) {
            if (this.profile.profile(src == 0)) {
                this.writeZFNode.execute(frame, true);
                return dst;
            }
            this.writeZFNode.execute(frame, false);
            return Integer.numberOfTrailingZeros(src);
        }
    }

    public static abstract class LLVMAMD64BsfwNode
    extends LLVMAMD64BsfNode {
        public LLVMAMD64BsfwNode(LLVMAMD64WriteBooleanNode writeZFNode) {
            super(writeZFNode);
        }

        @Specialization
        protected short doI16(VirtualFrame frame, short src, short dst) {
            if (this.profile.profile(src == 0)) {
                this.writeZFNode.execute(frame, true);
                return dst;
            }
            this.writeZFNode.execute(frame, false);
            int val = Short.toUnsignedInt(src);
            return (short)Integer.numberOfTrailingZeros(val);
        }
    }
}

