/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.model.symbols.instructions;

import com.oracle.truffle.llvm.parser.model.SymbolImpl;
import com.oracle.truffle.llvm.parser.model.SymbolTable;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.ValueInstruction;
import com.oracle.truffle.llvm.parser.model.visitors.SymbolVisitor;
import com.oracle.truffle.llvm.runtime.types.PrimitiveType;
import com.oracle.truffle.llvm.runtime.types.Type;

public final class CleanupPadInstruction
extends ValueInstruction {
    private SymbolImpl value;
    private SymbolImpl[] clauseSymbols;
    private final Type[] argTypes;

    private CleanupPadInstruction(Type[] argTypes) {
        super(PrimitiveType.I64);
        this.argTypes = argTypes;
    }

    public SymbolImpl[] getClauseSymbols() {
        return this.clauseSymbols;
    }

    public Type[] getArgTypes() {
        return this.argTypes;
    }

    @Override
    public void replace(SymbolImpl oldValue, SymbolImpl newValue) {
        if (this.value == oldValue) {
            this.value = newValue;
        }
    }

    @Override
    public void accept(SymbolVisitor visitor) {
        visitor.visit(this);
    }

    public static CleanupPadInstruction generate(SymbolTable table, int index, Type[] argTypes, int[] argValues) {
        CleanupPadInstruction l = new CleanupPadInstruction(argTypes);
        SymbolImpl[] clauseSymbols = new SymbolImpl[argValues.length];
        for (int i = 0; i < argValues.length; ++i) {
            clauseSymbols[i] = table.getForwardReferenced(argValues[i], l);
        }
        l.value = table.getForwardReferencedOrNull(index, l);
        l.clauseSymbols = clauseSymbols;
        return l;
    }
}

