/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.model.symbols.constants;

import com.oracle.truffle.llvm.parser.LLVMParserRuntime;
import com.oracle.truffle.llvm.parser.model.SymbolImpl;
import com.oracle.truffle.llvm.parser.model.SymbolTable;
import com.oracle.truffle.llvm.parser.model.enums.UnaryOperator;
import com.oracle.truffle.llvm.parser.model.symbols.constants.AbstractConstant;
import com.oracle.truffle.llvm.parser.model.symbols.constants.Constant;
import com.oracle.truffle.llvm.parser.model.visitors.SymbolVisitor;
import com.oracle.truffle.llvm.parser.util.LLVMBitcodeTypeHelper;
import com.oracle.truffle.llvm.runtime.GetStackSpaceFactory;
import com.oracle.truffle.llvm.runtime.datalayout.DataLayout;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.types.Type;

public final class UnaryOperationConstant
extends AbstractConstant {
    private final UnaryOperator operator;
    private Constant operand;

    private UnaryOperationConstant(Type type, UnaryOperator operator) {
        super(type);
        this.operator = operator;
        this.operand = null;
    }

    @Override
    public void accept(SymbolVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void replace(SymbolImpl original, SymbolImpl replacement) {
        if (this.operand == original) {
            this.operand = (Constant)replacement;
        }
    }

    public static UnaryOperationConstant fromSymbols(SymbolTable symbols, Type type, int opcode, int operand) {
        UnaryOperator operator = UnaryOperator.decode(opcode);
        UnaryOperationConstant constant = new UnaryOperationConstant(type, operator);
        constant.operand = symbols.getForwardReferenced(operand, constant);
        return constant;
    }

    @Override
    public LLVMExpressionNode createNode(LLVMParserRuntime runtime, DataLayout dataLayout, GetStackSpaceFactory stackFactory) {
        return LLVMBitcodeTypeHelper.createUnaryInstruction(this.operand.createNode(runtime, dataLayout, stackFactory), this.operator, this.getType(), runtime.getNodeFactory());
    }
}

