/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser;

import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.llvm.parser.LLVMParserResult;
import com.oracle.truffle.llvm.parser.LLVMParserRuntime;
import com.oracle.truffle.llvm.parser.LazyToTruffleConverterImpl;
import com.oracle.truffle.llvm.parser.model.ModelModule;
import com.oracle.truffle.llvm.parser.model.SymbolImpl;
import com.oracle.truffle.llvm.parser.model.functions.FunctionDeclaration;
import com.oracle.truffle.llvm.parser.model.functions.FunctionDefinition;
import com.oracle.truffle.llvm.parser.model.functions.FunctionSymbol;
import com.oracle.truffle.llvm.parser.model.symbols.constants.CastConstant;
import com.oracle.truffle.llvm.parser.model.symbols.constants.GetElementPointerConstant;
import com.oracle.truffle.llvm.parser.model.symbols.globals.GlobalAlias;
import com.oracle.truffle.llvm.parser.model.symbols.globals.GlobalVariable;
import com.oracle.truffle.llvm.parser.model.target.TargetTriple;
import com.oracle.truffle.llvm.runtime.GetStackSpaceFactory;
import com.oracle.truffle.llvm.runtime.LLVMAlias;
import com.oracle.truffle.llvm.runtime.LLVMElemPtrSymbol;
import com.oracle.truffle.llvm.runtime.LLVMFunction;
import com.oracle.truffle.llvm.runtime.LLVMFunctionCode;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.LLVMSymbol;
import com.oracle.truffle.llvm.runtime.LLVMThreadLocalSymbol;
import com.oracle.truffle.llvm.runtime.datalayout.DataLayout;
import com.oracle.truffle.llvm.runtime.except.LLVMLinkerException;
import com.oracle.truffle.llvm.runtime.global.LLVMGlobal;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.options.SulongEngineOption;
import com.oracle.truffle.llvm.runtime.types.PointerType;
import com.oracle.truffle.llvm.runtime.types.PrimitiveType;
import com.oracle.truffle.llvm.runtime.types.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;

public final class LLVMParser {
    private final Source source;
    private final LLVMParserRuntime runtime;
    private int threadLocalGlobalObjectCounter;

    public LLVMParser(Source source, LLVMParserRuntime runtime) {
        this.source = source;
        this.runtime = runtime;
        this.threadLocalGlobalObjectCounter = 0;
    }

    public LLVMParserResult parse(ModelModule module, DataLayout targetDataLayout) {
        ArrayList<GlobalVariable> externalGlobals = new ArrayList<GlobalVariable>();
        ArrayList<GlobalVariable> definedGlobals = new ArrayList<GlobalVariable>();
        ArrayList<GlobalVariable> threadLocalGlobals = new ArrayList<GlobalVariable>();
        ArrayList<FunctionSymbol> externalFunctions = new ArrayList<FunctionSymbol>();
        ArrayList<FunctionSymbol> definedFunctions = new ArrayList<FunctionSymbol>();
        this.defineGlobals(module.getGlobalVariables(), definedGlobals, externalGlobals, threadLocalGlobals);
        this.defineFunctions(module, definedFunctions, externalFunctions, targetDataLayout);
        this.defineAliases(module.getAliases(), targetDataLayout);
        return new LLVMParserResult(this.runtime, definedFunctions, externalFunctions, definedGlobals, externalGlobals, threadLocalGlobals, this.threadLocalGlobalObjectCounter, targetDataLayout, module.getTargetInformation(TargetTriple.class), module.getTotalSize());
    }

    private static boolean ignoreGlobal(GlobalVariable g) {
        String name = g.getName();
        return name.equals("llvm.used") || name.equals("llvm.compiler.used");
    }

    private void defineGlobals(List<GlobalVariable> globals, List<GlobalVariable> definedGlobals, List<GlobalVariable> externalGlobals, List<GlobalVariable> threadLocalGlobals) {
        for (GlobalVariable global : globals) {
            if (LLVMParser.ignoreGlobal(global)) continue;
            if (global.isExternal()) {
                externalGlobals.add(global);
                continue;
            }
            this.defineGlobal(global, definedGlobals, threadLocalGlobals);
        }
    }

    private void defineFunctions(ModelModule model, List<FunctionSymbol> definedFunctions, List<FunctionSymbol> externalFunctions, DataLayout dataLayout) {
        for (FunctionDefinition functionDefinition : model.getDefinedFunctions()) {
            if (functionDefinition.isExternal()) {
                externalFunctions.add(functionDefinition);
                continue;
            }
            this.defineFunction(functionDefinition, model, dataLayout);
            definedFunctions.add(functionDefinition);
        }
        for (FunctionDeclaration functionDeclaration : model.getDeclaredFunctions()) {
            assert (functionDeclaration.isExternal());
            externalFunctions.add(functionDeclaration);
        }
    }

    private void defineAliases(List<GlobalAlias> aliases, DataLayout targetDataLayout) {
        for (GlobalAlias alias : aliases) {
            this.defineAlias(alias, targetDataLayout);
        }
    }

    private void defineGlobal(GlobalVariable global, List<GlobalVariable> definedGlobals, List<GlobalVariable> threadLocalGlobals) {
        LLVMSymbol symbol;
        assert (!global.isExternal());
        if (global.isThreadLocal()) {
            symbol = LLVMThreadLocalSymbol.create(global.getName(), global.getSourceSymbol(), this.runtime.getBitcodeID(), global.getIndex(), global.isExported(), global.isExternalWeak());
            Type type = global.getType().getPointeeType();
            if (LLVMParser.isSpecialGlobalSlot(type)) {
                ++this.threadLocalGlobalObjectCounter;
            }
            threadLocalGlobals.add(global);
        } else {
            symbol = LLVMGlobal.create(global.getName(), global.getType(), global.getSourceSymbol(), global.isReadOnly(), global.getIndex(), this.runtime.getBitcodeID(), global.isExported(), global.isExternalWeak());
            definedGlobals.add(global);
        }
        this.runtime.getFileScope().register(symbol);
        this.registerInPublicFileScope(symbol);
    }

    public static boolean isSpecialGlobalSlot(Type type) {
        if (type instanceof PointerType) {
            return true;
        }
        return type == PrimitiveType.I64;
    }

    private void defineFunction(FunctionSymbol functionSymbol, ModelModule model, DataLayout dataLayout) {
        assert (!functionSymbol.isExternal());
        FunctionDefinition functionDefinition = (FunctionDefinition)functionSymbol;
        LazyToTruffleConverterImpl lazyConverter = new LazyToTruffleConverterImpl(this.runtime, functionDefinition, this.source, model.getFunctionParser(functionDefinition), model.getFunctionProcessor(), dataLayout);
        LLVMFunctionCode.LazyLLVMIRFunction function = new LLVMFunctionCode.LazyLLVMIRFunction(lazyConverter);
        LLVMFunction llvmFunction = LLVMFunction.create(functionSymbol.getName(), function, functionSymbol.getType(), this.runtime.getBitcodeID(), functionSymbol.getIndex(), functionDefinition.isExported(), this.runtime.getPath(), functionDefinition.isExternalWeak());
        lazyConverter.setRootFunction(llvmFunction);
        this.runtime.getFileScope().register(llvmFunction);
        this.registerInPublicFileScope(llvmFunction);
        boolean cxxInterop = (Boolean)LLVMLanguage.getContext().getEnv().getOptions().get(SulongEngineOption.CXX_INTEROP);
        if (cxxInterop) {
            model.getFunctionParser(functionDefinition).parseLinkageName(this.runtime);
        }
    }

    private void defineAlias(GlobalAlias alias, DataLayout targetDataLayout) {
        LLVMSymbol alreadyRegisteredSymbol = this.runtime.getFileScope().get(alias.getName());
        if (alreadyRegisteredSymbol != null) {
            assert (alreadyRegisteredSymbol instanceof LLVMAlias);
            return;
        }
        this.defineAlias(alias.getName(), alias.isExported(), alias.getValue(), targetDataLayout);
    }

    private void registerInPublicFileScope(LLVMSymbol symbol) {
        if (symbol.isExported()) {
            this.runtime.getPublicFileScope().register(symbol);
        }
    }

    private void defineAlias(String aliasName, boolean isAliasExported, SymbolImpl value, DataLayout targetDataLayout) {
        if (value instanceof FunctionSymbol) {
            FunctionSymbol function = (FunctionSymbol)value;
            this.defineAlias(function.getName(), aliasName, isAliasExported);
        } else if (value instanceof GlobalVariable) {
            GlobalVariable global = (GlobalVariable)value;
            this.defineAlias(global.getName(), aliasName, isAliasExported);
        } else if (value instanceof GlobalAlias) {
            GlobalAlias target = (GlobalAlias)value;
            this.defineAlias(target, targetDataLayout);
            this.defineAlias(target.getName(), aliasName, isAliasExported);
        } else if (value instanceof CastConstant) {
            CastConstant cast = (CastConstant)value;
            this.defineAlias(aliasName, isAliasExported, cast.getValue(), targetDataLayout);
        } else if (value instanceof GetElementPointerConstant) {
            GetElementPointerConstant elementPointerConstant = (GetElementPointerConstant)value;
            this.defineExpressionSymbol(aliasName, isAliasExported, elementPointerConstant, targetDataLayout);
        } else {
            throw new LLVMLinkerException("Unknown alias type: " + String.valueOf(value.getClass()));
        }
    }

    private void defineExpressionSymbol(String aliasName, boolean isAliasExported, GetElementPointerConstant elementPointerConstant, DataLayout targetDataLayout) {
        LLVMSymbol baseSymbol = this.runtime.getFileScope().get(elementPointerConstant.getBasePointer().toString());
        Supplier<LLVMExpressionNode> createElemPtrNode = () -> elementPointerConstant.createNode(this.runtime, targetDataLayout, GetStackSpaceFactory.createAllocaFactory());
        LLVMElemPtrSymbol expressionSymbol = new LLVMElemPtrSymbol(aliasName, this.runtime.getBitcodeID(), -1, isAliasExported, elementPointerConstant.getType(), baseSymbol, createElemPtrNode);
        this.runtime.getFileScope().register(expressionSymbol);
    }

    private void defineAlias(String existingName, String newName, boolean newExported) {
        LLVMSymbol aliasTarget = this.runtime.lookupSymbol(existingName);
        LLVMAlias aliasSymbol = new LLVMAlias(newName, aliasTarget, newExported);
        this.runtime.getFileScope().register(aliasSymbol);
        this.registerInPublicFileScope(aliasSymbol);
    }
}

