/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.initialization;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.llvm.initialization.LoadNativeNode;
import com.oracle.truffle.llvm.runtime.DefaultLibraryLocator;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LibraryLocator;
import com.oracle.truffle.llvm.runtime.NativeContextExtension;
import com.oracle.truffle.llvm.runtime.except.LLVMParserException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.options.SulongEngineOption;
import java.io.IOException;

public final class LoadDependencyNode
extends LLVMNode {
    public static final LoadDependencyNode[] EMPTY = new LoadDependencyNode[0];
    private final String libraryName;
    private final String reason;
    private final LibraryLocator libraryLocator;

    private LoadDependencyNode(String libraryName, LibraryLocator libraryLocator, String reason) {
        this.libraryName = libraryName;
        this.libraryLocator = libraryLocator;
        this.reason = reason;
    }

    public static LoadDependencyNode create(String libraryName, LibraryLocator libraryLocator, String reason) {
        return new LoadDependencyNode(libraryName, libraryLocator, reason);
    }

    public CallTarget execute() {
        LLVMContext context = this.getContext();
        CallTarget callTarget = context.getCalltargetFromCache(this.libraryName);
        if (LibraryLocator.loggingEnabled()) {
            LibraryLocator.traceStaticInits(context, "load dependency execute, loading library", this.libraryLocator);
            LibraryLocator.traceStaticInits(context, "load dependency execute, call target is", callTarget);
        }
        if (callTarget != null) {
            return callTarget;
        }
        return this.parse(context);
    }

    @CompilerDirectives.TruffleBoundary
    private CallTarget parse(LLVMContext context) {
        Source source;
        try {
            source = this.libraryLocator.locateSource(context, this.libraryName, this.reason);
        }
        catch (IOException | OutOfMemoryError | SecurityException ex) {
            throw new LLVMParserException("Error reading library " + this.libraryName + ".");
        }
        if (source == null) {
            TruffleFile nativeFile = this.createNativeTruffleFile(this.libraryName);
            if (nativeFile == null) {
                return null;
            }
            return this.createNativeLibraryCallTarget(nativeFile);
        }
        CallTarget cached = this.getLanguage().getCachedLibrary(source);
        if (LibraryLocator.loggingEnabled()) {
            LibraryLocator.traceStaticInits(context, "load dependency execute, cached library", cached);
        }
        if (cached != null) {
            return cached;
        }
        return this.getContext().getEnv().parseInternal(source, new String[0]);
    }

    private TruffleFile createNativeTruffleFile(String libName) {
        LLVMContext context = this.getContext();
        NativeContextExtension nativeContextExtension = context.getContextExtensionOrNull(NativeContextExtension.class);
        if (nativeContextExtension != null) {
            TruffleFile file = DefaultLibraryLocator.INSTANCE.locateFile(context, libName, "<native library>");
            if (file == null) {
                LibraryLocator.traceDelegateNative(context, libName);
                file = context.getEnv().getInternalTruffleFile(libName);
            }
            return file;
        }
        return null;
    }

    private CallTarget createNativeLibraryCallTarget(TruffleFile file) {
        if (((Boolean)this.getContext().getEnv().getOptions().get(SulongEngineOption.PARSE_ONLY)).booleanValue()) {
            return RootNode.createConstantNode((Object)0).getCallTarget();
        }
        LoadNativeNode loadNative = LoadNativeNode.create(this.getLanguage(), file);
        return loadNative.getCallTarget();
    }

    public String getLibraryName() {
        return this.libraryName;
    }
}

